package ui;

import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSynchronizedSlider extends JSlider implements ChangeListener
{
	private int synchronizedValue;
	
	private final boolean UPDATE_SLIDER_VALUE_ONLY_ON_RELEASE = false;
	
	public JSynchronizedSlider(int orientation, int min, int max, int value)
	{
		super(orientation, min, max, value);
		this.synchronizedValue = value;
		this.addChangeListener(this);
	}

	private synchronized void setSyncValue(int v)
	{
		this.synchronizedValue = v;
	}
	
	public synchronized int getSyncValue()
	{
		return this.synchronizedValue;
	}
	
	public void stateChanged(ChangeEvent e) 
	{
		JSlider source = (JSlider)e.getSource();
		
        if(UPDATE_SLIDER_VALUE_ONLY_ON_RELEASE)
        {
			if (!source.getValueIsAdjusting()) {
	            int value = (int)source.getValue();
	            this.setSyncValue(value);
	        }
        }
        else
        {
        	int value = (int)source.getValue();
            this.setSyncValue(value);
        }
	}

	
}
