package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;

public class JSynchronizedComboBox extends JComboBox
{
	Object selectedItem;
	
	public JSynchronizedComboBox()
	{
		super();
		this.selectedItem = null;
		
		this.addActionListener(new SyncActionListener());
	}
	
	public void addItem(Object o)
	{
		if(this.selectedItem == null)
			this.selectedItem = o;
		
		super.addItem(o);
	}
	
	public synchronized Object getSyncSelectedItem()
	{
		return this.selectedItem;
	}
	
	public synchronized void setSyncSelectedItem(Object o)
	{
		this.selectedItem = o;
	}
	
	class SyncActionListener implements ActionListener
	{
		public void actionPerformed(ActionEvent e)
		{		
			JComboBox source = (JComboBox)e.getSource();
			setSyncSelectedItem(source.getSelectedItem());
		}
	}
}