package ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;

public class JSynchronizedCheckBox extends JCheckBox implements ItemListener
{
	private boolean selected;

	public JSynchronizedCheckBox(String s)
	{
		super(s);
		this.selected = false;
		this.addItemListener(this);
	}
	
	public synchronized void setSyncSelected(boolean b)
	{
		this.selected = b;
	}
	
	public synchronized boolean isSyncSelected()
	{
		
		return this.selected;
	}
	
	public void itemStateChanged(ItemEvent e) {
		JCheckBox source = (JCheckBox)e.getSource();
		
		if(source.isSelected())
			setSyncSelected(true);
		else
			setSyncSelected(false);
	}
}
