package predictor;

import java.awt.Color;
import java.awt.Graphics;

import geometry.DoubleVector;

public abstract class PointPredictor {
	protected static final double PREDICTION_ANGLE = Math.PI/3;
	
	public abstract DoubleVector getMostLikelyPoint(double x, double y);
	public abstract void render(Graphics g, Color c);
	public abstract double getResidual(double x, double y);
	
	public double getError(double[] pointsX, double[] pointsY)
	{
		double length = 0, weight = 0;
		double residual;
		double totError = 0;
		
		for(int i = 0; i < pointsX.length; i++)
		{
			if(i == 0)
				length = 0;
			else
			{
				DoubleVector v2 = new DoubleVector((pointsX[i] - pointsX[i-1]), (pointsY[i] - pointsY[i-1]));
				length = length + v2.length();
			}
			
			//  This gives us the error weight for this point.
			weight = 1/(1+length*length);
			
			residual = this.getResidual(pointsX[i], pointsY[i]);
			
			totError = totError + (weight*residual*residual);
		}
		
		return totError;
	}
}
