package pointstream;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.BufferedWriter;
import java.io.IOException;

import main.ShoeLaceFrame;

import geometry.DoublePoint;

public class GuidePoint extends DoublePoint 
{
	long additionTime;
	
	int pixelX, pixelY;
	double speed;
	double intendedSpeed;
	
	boolean isContinueToEndPoint;
	
	private float radius = 4.0f;
	private float snap_to_radius = 4*radius;

	private final Color GUIDE_POINT_COLOR = new Color(0.0f,1.0f,0.0f,1.0f);
	
	public static boolean USE_SPEED_MODIFIED_COLOR = false;
	
	public GuidePoint(DoublePoint p, float radius, long l, int px, int py, double s)
	{
		super(p.getX(),p.getY());
		this.additionTime = l;
		this.pixelX = px;
		this.pixelY = py;
		this.speed = s;
		this.intendedSpeed = 0;
		this.radius = radius;
		this.snap_to_radius = 4*radius;
		this.isContinueToEndPoint = false;
	}
	
	public GuidePoint(double x, double y, float radius, long l, int px, int py, double s)
	{
		super(x,y);
		this.additionTime = l;
		this.pixelX = px;
		this.pixelY = py;
		this.speed = s;
		this.radius = radius;
		this.snap_to_radius = 4*radius;
		this.isContinueToEndPoint = false;
	}

	public void setContinueToEndPoint(boolean b) {
		this.isContinueToEndPoint = b;
	}
	
	public boolean isContinueToEndPoint() {
		return isContinueToEndPoint;
	}
	
	public long getAdditionTime() {
		return additionTime;
	}
	
	public int getPixelX() {
		return pixelX;
	}

	public int getPixelY() {
		return pixelY;
	}

	public double getSpeed() {
		if(GuideStream.USE_CURVATURE_SPEED)
			return intendedSpeed;
		else
			return speed;
	}
	
	public float getSnapToRadius() {
		return snap_to_radius;
	}
	
	public float getRadius() {
		return radius;
	}
	
	public double getMeasuredSpeed()
	{
		return this.speed;
	}
	
	public double getIntendedSpeed()
	{
		return this.intendedSpeed;
	}
	
	public void setIntendedSpeed(double iSpeed)
	{
		this.intendedSpeed = iSpeed;
	}
	
	public boolean contains(DoublePoint p)
	{
		if(this.distanceTo(p) < radius)
			return true;
		else
			return false;
	}
	
//	public void renderToSVG(BufferedWriter writer) throws IOException
//	{
//		writer.write("<ellipse cx=\""+this.getX()+"\" cy=\""+(-this.getY())+"\" rx=\""+this.radius+"\" ry=\""+this.radius+"\" style=\"fill:#"+ShoeLaceFrame.getInstance().getColorHexString(GUIDE_POINT_COLOR)+";stroke=#"+ShoeLaceFrame.getInstance().getColorHexString(GUIDE_POINT_COLOR)+"\" />");
//		writer.newLine();
//	}
	
	public Color getSpeedAlteredColor(Color c)
	{
		double transComponent;
		
		if(GuideStream.USE_CURVATURE_SPEED && ShoeLaceFrame.getInstance().drawCurvatureSpeedPointsCheckBox.isSelected())
		{
			double a = -0.8/1.2;
			double b = 1 + a;
			
			double speedToUse = this.intendedSpeed;
			
			if(speedToUse > 0.2)
				speedToUse = 0.2;
			
			if(speedToUse < -1.0)
				speedToUse = -1.0;
			
			transComponent = a*speedToUse + b;
		}
		else
		{
			double a = -0.7/2.0;
			double b = 1.0;
			
			double speedToUse = this.speed;
			
			if(this.speed > 2.0)
				speedToUse = 2.0;
			
			if(this.speed < 0.0)
				speedToUse = 0.0;
			
			transComponent = a*speedToUse + b;
		}
		
		return new Color(c.getRed(),c.getGreen(),c.getBlue(),(int)(transComponent*255));
	}
	
	public void render(Graphics2D g2D/*, double height*/)
	{
		Color old = g2D.getColor();
		
		if(this.isContinueToEndPoint())
			g2D.setColor(USE_SPEED_MODIFIED_COLOR ? getSpeedAlteredColor(Color.ORANGE) : Color.ORANGE);
		else
			g2D.setColor(USE_SPEED_MODIFIED_COLOR ? getSpeedAlteredColor(GUIDE_POINT_COLOR) : GUIDE_POINT_COLOR);
		
		Ellipse2D cir = new Ellipse2D.Double(this.getX()-radius, -this.getY()-radius, 2*radius, 2*radius);//-y to reflect back into pixel plane. 
		g2D.fill(cir);
		
		g2D.setColor(old);
	}
}
