package pointstream;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.io.BufferedWriter;
import java.io.IOException;

import main.ShoeLaceFrame;

import geometry.DoublePoint;

public class GeneratedPoint extends DoublePoint {

	private int guidePointIndex;
	private boolean isContinueToEndPoint;

	private final Color CONNECTING_POINT_COLOR = Color.BLUE;
	private final Color NON_CONNECTING_POINT_COLOR = Color.MAGENTA;
	
	private float radius;
	
	private Color pointColor;
	
	public GeneratedPoint(DoublePoint p, float radius, int i, boolean b)
	{
		super(p.getX(),p.getY());
		
		this.radius = radius;
		
		this.guidePointIndex = i;
		this.isContinueToEndPoint = b;
		
		initializeColor();
	}
	
	public GeneratedPoint(double x, double y, float radius, int i, boolean b) 
	{
		super(x, y);
		
		this.radius = radius;
		
		this.guidePointIndex = i;
		this.isContinueToEndPoint = b;
		
		initializeColor();
	}
	
	private void initializeColor()
	{
//		if(this.isContinueToEndPoint)
//			this.pointColor = CONNECTING_POINT_COLOR;
//		else
			this.pointColor = NON_CONNECTING_POINT_COLOR;
	}
	
	public boolean isContinueToEndPoint() {
		return isContinueToEndPoint;
	}
	
	public int getGuidePointIndex() {
		return guidePointIndex;	
	}
	
	public float getRadius() {
		return radius;
	}
	
	public boolean contains(DoublePoint p)
	{
		if(this.distanceTo(p) < radius)
			return true;
		else
			return false;
	}
	
//	public void renderToSVG(BufferedWriter writer) throws IOException
//	{	
//		writer.write("<ellipse cx=\""+this.getX()+"\" cy=\""+(-this.getY())+"\" rx=\""+this.radius+"\" ry=\""+this.radius+"\" style=\"fill:#"+ShoeLaceFrame.getInstance().getColorHexString(pointColor)+";stroke=#"+ShoeLaceFrame.getInstance().getColorHexString(pointColor)+"\" />");
//		writer.newLine();
//	}
	
	public void render(Graphics2D g2D)
	{
		Color old = g2D.getColor();
		
		g2D.setColor(this.pointColor);
		
		Ellipse2D cir = new Ellipse2D.Double(this.getX()-radius, -this.getY()-radius, 2*radius, 2*radius);//-y to reflect back into pixel plane. 
		g2D.fill(cir);
		
		g2D.setColor(old);
	}
}
