package geometry;

import java.awt.Color;
import java.awt.Graphics;

public class Vertex 
{
	private int pX,pY;
	private boolean selected;
	
	public static final int VERTEX_RADIUS = 5;
	
	public Vertex(int i1, int i2)
	{
		this.pX = i1;
		this.pY = i2;
		
		this.selected = false;
	}
	
	public boolean withinRadius(int x, int y)
	{
		int radSq = VERTEX_RADIUS*VERTEX_RADIUS;
		
		int distX = x - pX;
		int distY = y - pY;
		int dist = distX*distX + distY*distY;
		
		return dist < radSq;
	}

	public void renderVertex(Graphics g)
	{
		if(isSelected())
  		  g.setColor(Color.GREEN);
  	  	else
  		  g.setColor(Color.MAGENTA);
  	  
  	  	g.fillOval(pX - VERTEX_RADIUS, pY - VERTEX_RADIUS, 2*VERTEX_RADIUS, 2*VERTEX_RADIUS);
	}
	
	public int getpX() {
		return pX;
	}

	public int getpY() {
		return pY;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}
}
