package geometry;

public class DoubleVector 
{
	private double x,y;
	
	public DoubleVector(int x, int y)
	{
		this.x = x;
		this.y = y;
	}
	
	public DoubleVector(float x, float y)
	{
		this.x = x;
		this.y = y;
	}
	
	public DoubleVector(double x, double y)
	{
		this.x = x;
		this.y = y;
	}
	
	public DoubleVector(DoublePoint origin, DoublePoint extremity)
	{
		this.x = extremity.getX() - origin.getX();
		this.y = extremity.getY() - origin.getY();
	}
	
	public DoubleVector perp()
	{
		return new DoubleVector(-this.y, this.x);
	}
	
	public double length()
	{
		return Math.sqrt(x*x + y*y);
	}
	
	public void unit()
	{
		double length = length();
		
		this.x = this.x/length;
		this.y = this.y/length;
	}
	
	public void add(DoubleVector v)
	{
		this.x += v.getX();
		this.y += v.getY();
	}

	public void multiply(double k)
	{
		this.x *= k;
		this.y *= k;
	}
	
	public double dot(DoubleVector v)
	{
		return this.x*v.getX() + this.y*v.getY();
	}
	
	public String toString()
	{
		return "("+this.getX()+","+this.getY()+")";
	}
	
	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}
}
