package geometry;

import pointstream.LinearPointStream;

public class DoublePoint 
{
	double x,y;

	public DoublePoint(int x, int y)
	{
		this.x = x;
		this.y = y;
	}
	
	public DoublePoint(double x, double y)
	{
		this.x = x;
		this.y = y;
	}
	
	public DoublePoint multiply(double k)
	{
		return new DoublePoint(k*this.x, k*this.y);
	}
	
	public DoublePoint add(DoublePoint p2)
	{
		return new DoublePoint(this.x + p2.getX(), this.y + p2.getY());
	}
	
	public DoublePoint add(double x, double y)
	{
		return new DoublePoint(this.x + x, this.y + y);
	}
	
	public DoublePoint subtract(DoublePoint p2)
	{
		return new DoublePoint(this.x - p2.getX(), this.y - p2.getY());
	}
	
	public DoublePoint subtract(double x, double y)
	{
		return new DoublePoint(this.x - x, this.y - y);
	}
	
	public double distanceTo(DoublePoint p2)
	{
		double diffX = this.x - p2.getX();
		double diffY = this.y - p2.getY();
		
		return Math.sqrt(diffX*diffX + diffY*diffY);
	}
	
	public String toString()
	{
		return "("+this.getX()+","+this.getY()+")";
	}
	
	public boolean equals(Object o)
	{
		DoublePoint p = (DoublePoint)o;
		
		if(Math.abs(p.getX() - this.x) < LinearPointStream.DISTANCE_THRESHOLD && Math.abs(p.getY() - this.y) < LinearPointStream.DISTANCE_THRESHOLD)
			return true;
		else
			return false;
	}
	
	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}	
}
