package geometry;

import java.awt.geom.GeneralPath;

public class ArcSegment extends Segment {

	Circle underlyingCircle;
	
	double startPointAnglePosition, endPointAnglePosition;
	double angleSize;
	
	boolean movingInPositiveDirection;

	public ArcSegment(DoublePoint startPoint, DoublePoint endPoint, Circle underlyingCircle, boolean movingPositiveDir)
	{
		super(startPoint, endPoint);
		
		this.underlyingCircle = underlyingCircle;
		this.movingInPositiveDirection = movingPositiveDir;
		
		this.startPointAnglePosition = underlyingCircle.anglePosition(startPoint.getX(), startPoint.getY());
		this.endPointAnglePosition = underlyingCircle.anglePosition(endPoint.getX(), endPoint.getY());
		
		if(this.startPointAnglePosition < 0.0)
			this.startPointAnglePosition += 360.0;
		
		if(this.endPointAnglePosition < 0.0)
			this.endPointAnglePosition += 360.0;
		
		if(this.movingInPositiveDirection)
		{
			// Moving in positive anglar direction.
			if(this.endPointAnglePosition > this.startPointAnglePosition)
				this.angleSize = this.endPointAnglePosition - this.startPointAnglePosition;
			else
				this.angleSize = (360.0 + this.endPointAnglePosition) - this.startPointAnglePosition;
		}
		else
		{
			if(this.endPointAnglePosition < startPointAnglePosition)
				this.angleSize = this.startPointAnglePosition - this.endPointAnglePosition;
			else
				this.angleSize = (360.0 + this.startPointAnglePosition) - this.endPointAnglePosition;
		}
	}
	
	public void appendToPath(GeneralPath p) {
		// TODO Auto-generated method stub

	}

	@Override
	public DoublePoint getPointAt(double t) {
		// TODO Auto-generated method stub
		return null;
	}

}
