/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.util.Spatial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowUtils {
    private static final Logger LOG = Logger.getLogger(WindowUtils.class.getName());
    static /* synthetic */ Class class$0;

    private WindowUtils() {
    }

    public static Point getPointForCentering(Window window) {
        try {
            GraphicsDevice[] devices;
            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
            GraphicsDevice[] graphicsDeviceArray = devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = 0;
            int n2 = graphicsDeviceArray.length;
            while (n < n2) {
                GraphicsDevice device = graphicsDeviceArray[n];
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                if (mousePoint.x >= bounds.x && mousePoint.y >= bounds.y && mousePoint.x <= bounds.x + bounds.width && mousePoint.y <= bounds.y + bounds.height) {
                    int screenWidth = bounds.width;
                    int screenHeight = bounds.height;
                    int width = window.getWidth();
                    int height = window.getHeight();
                    Point p = new Point((screenWidth - width) / 2 + bounds.x, (screenHeight - height) / 2 + bounds.y);
                    return p;
                }
                ++n;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, String.valueOf(e.getLocalizedMessage()) + " - this can occur do to a Security exception in sandboxed apps");
        }
        return new Point(0, 0);
    }

    public static Point getPointForCentering(JInternalFrame window, JDesktopPane desktop) {
        try {
            GraphicsDevice[] devices;
            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
            GraphicsDevice[] graphicsDeviceArray = devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = 0;
            int n2 = graphicsDeviceArray.length;
            while (n < n2) {
                GraphicsDevice device = graphicsDeviceArray[n];
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                if (mousePoint.x >= bounds.x && mousePoint.y >= bounds.y && mousePoint.x <= bounds.x + bounds.width && mousePoint.y <= bounds.y + bounds.height) {
                    int screenWidth = bounds.width;
                    int screenHeight = bounds.height;
                    int width = window.getWidth();
                    int height = window.getHeight();
                    Point p = new Point((screenWidth - width) / 2 + bounds.x, (screenHeight - height) / 2 + bounds.y);
                    return p;
                }
                ++n;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, String.valueOf(e.getLocalizedMessage()) + " - this can occur do to a Security exception in sandboxed apps");
        }
        return new Point(0, 0);
    }

    public static Point getPointForStaggering(Window originWindow) {
        Point origin = originWindow.getLocation();
        Insets insets = originWindow.getInsets();
        origin.x += insets.top;
        origin.y += insets.top;
        return origin;
    }

    public static void setConstraints(GridBagConstraints gbc, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, int top, int left, int bottom, int right) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = new Insets(top, left, bottom, right);
    }

    public static Spatial getSpatial(Window win) {
        Spatial spatial = new Spatial(win.getY(), win.getX(), win.getWidth(), win.getHeight());
        return spatial;
    }

    public static Spatial getSpatial(JComponent comp) {
        Spatial spatial = new Spatial(comp.getY(), comp.getX(), comp.getWidth(), comp.getHeight());
        return spatial;
    }

    public static RootPaneContainer findRootPaneContainer(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)c);
        }
        return WindowUtils.findRootPaneContainer(c.getParent());
    }

    public static JFrame findJFrame(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof RootPaneContainer) {
            return (JFrame)c;
        }
        return WindowUtils.findJFrame(c.getParent());
    }

    public static JDialog findJDialog(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JDialog) {
            return (JDialog)c;
        }
        return WindowUtils.findJDialog(c.getParent());
    }

    public static Window findWindow(Component c) {
        if (c == null) {
            return JOptionPane.getRootFrame();
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return WindowUtils.findWindow(c.getParent());
    }

    public static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        Component[] componentArray = comps;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component comp = componentArray[n];
            compList.add(comp);
            if (comp instanceof Container) {
                compList.addAll(WindowUtils.getAllComponents((Container)comp));
            }
            ++n;
        }
        return compList;
    }

    public static void setFontRecursively(Container c, Font font) {
        for (Component comp : WindowUtils.getAllComponents(c)) {
            comp.setFont(font);
        }
    }

    public static void setMinimumSizeManager(Window window, int minWidth, int minHeight) {
        ComponentListener[] listeners = window.getComponentListeners();
        ComponentListener listener = null;
        boolean found = false;
        ComponentListener[] componentListenerArray = listeners;
        int n = 0;
        int n2 = componentListenerArray.length;
        while (n < n2) {
            ComponentListener l = componentListenerArray[n];
            if (l instanceof MinSizeComponentListener) {
                listener = l;
                break;
            }
            ++n;
        }
        if (listener == null) {
            window.addComponentListener(new MinSizeComponentListener(window, minWidth, minHeight));
        } else {
            ((MinSizeComponentListener)listener).resetSizes(minWidth, minHeight);
        }
    }

    public static class MinSizeComponentListener
    extends ComponentAdapter {
        private Window window;
        private int minHeight;
        private int minWidth;

        MinSizeComponentListener(Window frame, int minWidth, int minHeight) {
            this.window = frame;
            this.resetSizes(minWidth, minHeight);
        }

        public void resetSizes(int minWidth, int minHeight) {
            this.minWidth = minWidth;
            this.minHeight = minHeight;
            this.adjustIfNeeded(this.window);
        }

        public void componentResized(ComponentEvent evt) {
            this.adjustIfNeeded((Window)evt.getComponent());
        }

        private void adjustIfNeeded(Window window) {
            boolean doSize = false;
            int newWidth = window.getWidth();
            int newHeight = window.getHeight();
            if (newWidth < this.minWidth) {
                newWidth = this.minWidth;
                doSize = true;
            }
            if (newHeight < this.minHeight) {
                newHeight = this.minHeight;
                doSize = true;
            }
            if (doSize) {
                int w = newWidth;
                int h = newHeight;
                SwingUtilities.invokeLater(new Runnable(this, window, w, h){
                    final /* synthetic */ MinSizeComponentListener this$1;
                    private final /* synthetic */ Window val$window;
                    private final /* synthetic */ int val$w;
                    private final /* synthetic */ int val$h;
                    {
                        this.this$1 = minSizeComponentListener;
                        this.val$window = window;
                        this.val$w = n;
                        this.val$h = n2;
                    }

                    public void run() {
                        this.val$window.setSize(this.val$w, this.val$h);
                    }
                });
            }
        }
    }
}

