/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Font;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public final class UIManagerUtils {
    private static final Logger LOG = Logger.getLogger(UIManagerUtils.class.getName());
    static /* synthetic */ Class class$0;

    private UIManagerUtils() {
    }

    public static void initDefault(String key, Object defaultObj) {
        Object obj = UIManager.get(key);
        if (obj == null) {
            UIManager.put(key, defaultObj);
        }
    }

    public static void initDefault(String key, String defaultMetalObjName, Object defaultObj) {
        Object obj = UIManager.get(key);
        if (obj == null) {
            try {
                Method m = ((MetalLookAndFeel)UIManager.getLookAndFeel()).getClass().getMethod(defaultMetalObjName, defaultObj.getClass());
                UIManager.put(key, m.invoke((Object)UIManager.getLookAndFeel(), defaultMetalObjName));
            }
            catch (Exception e) {
                UIManager.put(key, defaultObj);
            }
        }
    }

    public static void htmlize(JComponent component, Font font) {
        String stylesheet = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;  }" + "a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;  }";
        try {
            HTMLDocument doc = null;
            if (component instanceof JEditorPane) {
                if (((JEditorPane)component).getDocument() instanceof HTMLDocument) {
                    doc = (HTMLDocument)((JEditorPane)component).getDocument();
                }
            } else {
                View v = (View)component.getClientProperty("html");
                if (v != null && v.getDocument() instanceof HTMLDocument) {
                    doc = (HTMLDocument)v.getDocument();
                }
            }
            if (doc != null) {
                doc.getStyleSheet().loadRules(new StringReader(stylesheet), null);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "", e);
        }
    }
}

