/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PropertyChangeReport
implements PropertyChangeListener {
    protected List events = new LinkedList();
    protected Map eventMap = new HashMap();

    public void propertyChange(PropertyChangeEvent evt) {
        this.events.add(0, evt);
        if (evt.getPropertyName() != null) {
            this.eventMap.put(evt.getPropertyName(), evt);
        }
    }

    public int getEventCount() {
        return this.events.size();
    }

    public void clear() {
        this.events.clear();
        this.eventMap.clear();
    }

    public boolean hasEvents() {
        return !this.events.isEmpty();
    }

    public int getEventCount(String property) {
        if (property == null) {
            return this.getMultiCastEventCount();
        }
        int count = 0;
        for (PropertyChangeEvent event : this.events) {
            if (!property.equals(event.getPropertyName())) continue;
            ++count;
        }
        return count;
    }

    public boolean hasEvents(String property) {
        return this.eventMap.get(property) != null;
    }

    public int getMultiCastEventCount() {
        int count = 0;
        for (PropertyChangeEvent event : this.events) {
            if (event.getPropertyName() != null) continue;
            ++count;
        }
        return 0;
    }

    public int getNamedEventCount() {
        return this.getEventCount() - this.getMultiCastEventCount();
    }

    public PropertyChangeEvent getLastEvent() {
        return this.events.isEmpty() ? null : (PropertyChangeEvent)this.events.get(0);
    }

    public PropertyChangeEvent getLastEvent(String property) {
        return (PropertyChangeEvent)this.eventMap.get(property);
    }

    public Object getLastOldValue() {
        PropertyChangeEvent last = this.getLastEvent();
        return last != null ? last.getOldValue() : null;
    }

    public Object getLastNewValue() {
        PropertyChangeEvent last = this.getLastEvent();
        return last != null ? last.getNewValue() : null;
    }

    public Object getLastOldValue(String property) {
        PropertyChangeEvent last = this.getLastEvent(property);
        return last != null ? last.getOldValue() : null;
    }

    public Object getLastNewValue(String property) {
        PropertyChangeEvent last = this.getLastEvent(property);
        return last != null ? last.getNewValue() : null;
    }

    public boolean getLastOldBooleanValue() {
        return (Boolean)this.getLastOldValue();
    }

    public boolean getLastNewBooleanValue() {
        return (Boolean)this.getLastNewValue();
    }
}

