/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.FileNode;

public class FileSystemModel
extends DefaultTreeTableModel {
    private static final Logger LOG = Logger.getLogger(FileSystemModel.class.getName());
    protected boolean asksAllowsChildren;
    private static final Integer ZERO = new Integer(0);
    static /* synthetic */ Class class$0;

    public FileSystemModel() {
        this(new FileNode(new File(File.separator)));
    }

    public FileSystemModel(TreeNode root) {
        this(root, false);
    }

    public FileSystemModel(TreeNode root, boolean asksAllowsChildren) {
        super(root);
        this.asksAllowsChildren = asksAllowsChildren;
    }

    public Object getChild(Object parent, int index) {
        try {
            return ((FileNode)parent).getChildren().get(index);
        }
        catch (Exception ex) {
            return super.getChild(parent, index);
        }
    }

    public int getChildCount(Object parent) {
        try {
            return ((FileNode)parent).getChildren().size();
        }
        catch (Exception ex) {
            return super.getChildCount(parent);
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "Modification Date";
            }
        }
        return "Column " + column;
    }

    public Object getValueAt(Object node, int column) {
        File file = ((FileNode)node).getFile();
        try {
            switch (column) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? new Integer((int)file.length()) : ZERO;
                }
                case 2: {
                    return new Boolean(!file.isFile());
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Problem accessing file", ex);
        }
        return null;
    }
}

