/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;
import junit.framework.TestCase;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jdesktop.swingx.util.ColumnModelReport;

public class TableColumnModelTest
extends TestCase {
    private static final int COLUMN_COUNT = 3;

    public void testGetColumns() {
        TableColumnModelExt model = this.createColumnModel(3);
        ((TableColumnExt)model.getColumn(0)).setVisible(false);
        TableColumnModelTest.assertEquals((String)"visible column count must be reduced", (int)2, (int)model.getColumns(false).size());
        TableColumnModelTest.assertEquals((String)"all columns count must be unchanged", (int)3, (int)model.getColumns(true).size());
    }

    public void testColumnCountOnSetInvisible() {
        TableColumnModelExt model = this.createColumnModel(3);
        int columnCount = model.getColumnCount();
        TableColumnExt column = (TableColumnExt)model.getColumn(columnCount - 1);
        TableColumnModelTest.assertTrue((boolean)column.isVisible());
        column.setVisible(false);
        TableColumnModelTest.assertEquals((String)"columnCount must be decremented", (int)(columnCount - 1), (int)model.getColumnCount());
    }

    public void testTotalColumnWidth() {
        TableColumnModelExt model = this.createColumnModel(3);
        int totalWidth = model.getTotalColumnWidth();
        TableColumnExt column = (TableColumnExt)model.getColumn(0);
        int columnWidth = column.getWidth();
        column.setVisible(false);
        TableColumnModelTest.assertEquals((String)("new total width must be old minus invisible column width " + columnWidth), (int)(totalWidth - columnWidth), (int)model.getTotalColumnWidth());
    }

    public void testRemovedFired() {
        TableColumnModelExt model = this.createColumnModel(3);
        ColumnModelReport l = new ColumnModelReport();
        model.addColumnModelListener(l);
        TableColumnExt column = (TableColumnExt)model.getColumn(0);
        column.setVisible(false);
        TableColumnModelTest.assertTrue((String)"must have fired columnRemoved", (boolean)l.hasRemovedEvent());
    }

    public void testAddedFired() {
        TableColumnModelExt model = this.createColumnModel(3);
        ColumnModelReport l = new ColumnModelReport();
        TableColumnExt column = (TableColumnExt)model.getColumn(0);
        column.setVisible(false);
        model.addColumnModelListener(l);
        column.setVisible(true);
        TableColumnModelTest.assertTrue((String)"must have fired columnRemoved", (boolean)l.hasAddedEvent());
    }

    public void testAddInvisibleColumn() {
        TableColumnModelExt model = this.createColumnModel(3);
        TableColumnModelListener l = new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
                TableColumnModelTest.assertTrue((String)"toIndex must be positive", (e.getToIndex() >= 0 ? 1 : 0) != 0);
                ((TableColumnModel)e.getSource()).getColumn(e.getToIndex());
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
        model.addColumnModelListener(l);
        TableColumnExt invisibleColumn = new TableColumnExt(0);
        invisibleColumn.setVisible(false);
        model.addColumn(invisibleColumn);
        model.addColumn(this.createTableColumnExt(0));
    }

    public void testColumnAt() {
        TableColumnModelExt model = this.createColumnModel(3);
        int totalWidth = model.getTotalColumnWidth();
        int lastColumn = model.getColumnIndexAtX(totalWidth - 10);
        TableColumnModelTest.assertEquals((String)"lastColumn detected", (int)(model.getColumnCount() - 1), (int)lastColumn);
        TableColumnExt column = (TableColumnExt)model.getColumn(lastColumn);
        column.setVisible(false);
        TableColumnModelTest.assertEquals((String)"out of range", (int)-1, (int)model.getColumnIndexAtX(totalWidth - 10));
    }

    private TableColumnModelExt createColumnModel(int columns) {
        DefaultTableColumnModelExt model = new DefaultTableColumnModelExt();
        int i = 0;
        while (i < columns) {
            model.addColumn(this.createTableColumnExt(i));
            ++i;
        }
        return model;
    }

    private TableColumnExt createTableColumnExt(int i) {
        TableColumnExt column = new TableColumnExt(i);
        column.setIdentifier("" + i);
        return column;
    }
}

