/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.Sorter;

public class TableColumnExt
extends TableColumn
implements Cloneable {
    public static final String SORTER_COMPARATOR = "Sorter.COMPARATOR";
    protected boolean editable = true;
    protected boolean visible = true;
    protected Object prototypeValue = null;
    private Hashtable clientProperties = null;
    protected Sorter sorter = null;
    private Constructor sorterConstructor = defaultSorterConstructor;
    private static final Constructor defaultSorterConstructor;
    private static final Class[] sorterConstructorSignature;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        sorterConstructorSignature = new Class[]{Integer.TYPE, Boolean.TYPE};
        Constructor<?> constructor = null;
        try {
            Class<?> sorterClass = Class.forName("org.jdesktop.swingx.decorator.ShuttleSorter", true, TableColumnExt.class.getClassLoader());
            constructor = sorterClass.getConstructor(sorterConstructorSignature);
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultSorterConstructor = constructor;
    }

    public TableColumnExt() {
        this(0);
    }

    public TableColumnExt(int modelIndex) {
        this(modelIndex, 75);
    }

    public TableColumnExt(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public TableColumnExt(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        super(modelIndex, width, cellRenderer, cellEditor);
    }

    public boolean getResizable() {
        return super.getResizable() && this.getMinWidth() < this.getMaxWidth();
    }

    public void setEditable(boolean editable) {
        boolean oldEditable = this.editable;
        this.editable = editable;
        this.firePropertyChange("editable", oldEditable, editable);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setPrototypeValue(Object value) {
        Object oldPrototypeValue = this.prototypeValue;
        this.prototypeValue = value;
        this.firePropertyChange("prototypeValue", oldPrototypeValue, value);
    }

    public Object getPrototypeValue() {
        return this.prototypeValue;
    }

    public void setSorterClass(String sorterClassName) {
        if (sorterClassName == null || sorterClassName.length() == 0) {
            this.sorterConstructor = null;
        } else {
            try {
                Class<?> sorterClass = Class.forName(sorterClassName, true, this.getClass().getClassLoader());
                this.sorterConstructor = sorterClass.getConstructor(sorterConstructorSignature);
            }
            catch (Exception ex) {
                this.sorterConstructor = null;
            }
        }
    }

    public String getSorterClass() {
        return this.sorterConstructor == null ? null : this.sorterConstructor.getDeclaringClass().getName();
    }

    public Sorter getSorter() {
        if (this.sorter == null && this.sorterConstructor != null) {
            try {
                this.sorter = (Sorter)this.sorterConstructor.newInstance(new Integer(this.getModelIndex()), new Boolean(true));
                Object object = this.getClientProperty(SORTER_COMPARATOR);
                if (object instanceof Comparator) {
                    this.sorter.setComparator((Comparator)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sorter;
    }

    public boolean isSortable() {
        return this.sorterConstructor != null;
    }

    public void setTitle(String title) {
        this.setHeaderValue(title);
    }

    public String getTitle() {
        return this.getHeaderValue().toString();
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldVisible, visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null && this.getClientProperty(key) == null) {
            return;
        }
        if (value == null) {
            this.getClientProperties().remove(key);
        } else {
            this.getClientProperties().put(key, value);
        }
    }

    public Object getClientProperty(Object key) {
        return key == null || this.clientProperties == null ? null : this.clientProperties.get(key);
    }

    private Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public Object clone() {
        TableColumnExt copy = new TableColumnExt(this.getModelIndex(), this.getWidth(), this.getCellRenderer(), this.getCellEditor());
        copy.setEditable(this.isEditable());
        copy.setHeaderValue(this.getHeaderValue());
        copy.setIdentifier(this.getIdentifier());
        copy.setMaxWidth(this.getMaxWidth());
        copy.setMinWidth(this.getMinWidth());
        copy.setPreferredWidth(this.getPreferredWidth());
        copy.setPrototypeValue(this.getPrototypeValue());
        copy.setResizable(super.getResizable());
        copy.setVisible(this.isVisible());
        copy.setSorterClass(this.getSorterClass());
        copy.sorterConstructor = this.sorterConstructor;
        return copy;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeListener[] pcl;
        if ((oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) && (pcl = this.getPropertyChangeListeners()) != null && pcl.length != 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            int i = 0;
            while (i < pcl.length) {
                pcl[i].propertyChange(pce);
                ++i;
            }
        }
    }
}

