/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ColumnFactory {
    private static ColumnFactory columnFactory;

    public static synchronized ColumnFactory getInstance() {
        if (columnFactory == null) {
            columnFactory = new ColumnFactory();
        }
        return columnFactory;
    }

    public static synchronized void setInstance(ColumnFactory factory) {
        columnFactory = factory;
    }

    public TableColumnExt createTableColumn(int modelIndex) {
        return new TableColumnExt(modelIndex);
    }

    public void configureTableColumn(TableModel model, TableColumnExt column) {
        if (column.getModelIndex() < 0 || column.getModelIndex() >= model.getColumnCount()) {
            throw new IllegalStateException("column must have valid modelIndex");
        }
        column.setHeaderValue(model.getColumnName(column.getModelIndex()));
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
        TableColumnExt column = this.createTableColumn(modelIndex);
        this.configureTableColumn(model, column);
        return column;
    }

    public void configureColumnWidths(JXTable table, TableColumnExt columnx) {
        Dimension cellSpacing = table.getIntercellSpacing();
        Object prototypeValue = columnx.getPrototypeValue();
        if (prototypeValue != null) {
            JTableHeader header;
            TableCellRenderer renderer = table.getCellRenderer(0, table.convertColumnIndexToView(columnx.getModelIndex()));
            Component comp = renderer.getTableCellRendererComponent(table, prototypeValue, false, false, 0, 0);
            int prefWidth = comp.getPreferredSize().width + cellSpacing.width;
            renderer = columnx.getHeaderRenderer();
            if (renderer == null && (header = table.getTableHeader()) != null) {
                renderer = header.getDefaultRenderer();
            }
            if (renderer != null) {
                comp = renderer.getTableCellRendererComponent(table, columnx.getHeaderValue(), false, false, 0, table.convertColumnIndexToView(columnx.getModelIndex()));
                prefWidth = Math.max(comp.getPreferredSize().width, prefWidth);
            }
            columnx.setPreferredWidth(prefWidth += table.getColumnModel().getColumnMargin());
        }
    }

    public void packColumn(JXTable table, TableColumnExt col, int margin, int max) {
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        int width = 0;
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        int column = table.convertColumnIndexToView(col.getModelIndex());
        if (table.getRowCount() > 0) {
            renderer = table.getCellRenderer(0, column);
        }
        int r = 0;
        while (r < table.getRowCount()) {
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, column), false, false, r, column);
            width = Math.max(width, comp.getPreferredSize().width);
            ++r;
        }
        if (max != -1 && (width += 2 * margin) > max) {
            width = max;
        }
        col.setPreferredWidth(width);
    }
}

