/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.util.AncientSwingTeam;

public class ColumnControlButtonTest
extends InteractiveTestCase {
    protected TableModel sortableTableModel;

    public void testMinimumColumnCountOne() {
        JXTable table = new JXTable(10, 2);
        table.setColumnControlVisible(true);
        table.getColumnExt(0).setVisible(false);
        ColumnControlButtonTest.assertEquals((int)1, (int)table.getColumnCount());
    }

    public void testNonStringActionKeys() {
        JXTable table = new JXTable();
        AbstractAction l = new AbstractAction("dummy"){

            public void actionPerformed(ActionEvent e) {
            }
        };
        table.registerKeyboardAction(l, KeyStroke.getKeyStroke("ESCAPE"), 0);
        table.setColumnControlVisible(true);
        table.getColumnControl();
    }

    public void testColumnControlReleaseAction() {
        JXTable table = new JXTable(this.sortableTableModel);
        TableColumnExt priorityColumn = table.getColumnExt("First Name");
        int listenerCount = priorityColumn.getPropertyChangeListeners().length;
        table.setColumnControlVisible(true);
        table.getColumnControl();
        ColumnControlButtonTest.assertEquals((String)"numbers of listeners must be increased", (int)(listenerCount + 1), (int)priorityColumn.getPropertyChangeListeners().length);
        int totalColumnCount = table.getColumnCount();
        table.removeColumn(priorityColumn);
        ColumnControlButtonTest.assertEquals((String)"number of columns reduced", (int)(totalColumnCount - 1), (int)table.getColumnCount());
        ColumnControlButtonTest.assertEquals((String)"all listeners must be removed", (int)0, (int)priorityColumn.getPropertyChangeListeners().length);
    }

    public void testColumnControlInvisibleColumns() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setColumnControlVisible(true);
        int totalColumnCount = table.getColumnCount();
        TableColumnExt priorityColumn = table.getColumnExt("First Name");
        priorityColumn.setVisible(false);
        ColumnControlButton columnControl = (ColumnControlButton)table.getColumnControl();
        ColumnControlButtonTest.assertNotNull((String)"popup menu not null", (Object)columnControl.popupMenu);
        int columnMenuItems = 0;
        Component[] items = columnControl.popupMenu.getComponents();
        int i = 0;
        while (i < items.length) {
            if (!(items[i] instanceof JMenuItem)) break;
            ++columnMenuItems;
            ++i;
        }
        ColumnControlButtonTest.assertEquals((String)"menu items must be equal to columns", (int)totalColumnCount, (int)columnMenuItems);
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)columnControl.popupMenu.getComponent(0);
        ColumnControlButtonTest.assertEquals((Object)priorityColumn.getHeaderValue(), (Object)menuItem.getText());
        ColumnControlButtonTest.assertEquals((String)"selection of menu must be equal to column visibility", (boolean)priorityColumn.isVisible(), (boolean)menuItem.isSelected());
    }

    public void interactiveTestColumnControlInvisibleColumns() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setColumnControlVisible(true);
        TableColumnExt priorityColumn = table.getColumnExt("First Name");
        priorityColumn.setVisible(false);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable (#192, #38-swingx) ColumnControl and Visibility of items");
        frame.setVisible(true);
    }

    public void interactiveTestColumnControlEarlyInvisibleColumns() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.getColumnExt("Last Name").setVisible(false);
        table.setColumnControlVisible(true);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable (#192, #38-swingx) ColumnControl and Visibility of items");
        frame.setVisible(true);
    }

    public void interactiveTestLastVisibleColumn() {
        JXTable table = new JXTable();
        table.setModel(new DefaultTableModel(10, 2));
        table.setColumnControlVisible(true);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable (#192, #38-swingx) ColumnControl and Visibility of items");
        table.getColumnExt(0).setVisible(false);
        frame.setVisible(true);
    }

    public ColumnControlButtonTest() {
        super("ColumnControlButtonTest");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sortableTableModel = new AncientSwingTeam();
    }

    public static void main(String[] args) {
        ColumnControlButtonTest.setSystemLF(false);
        ColumnControlButtonTest test = new ColumnControlButtonTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }
}

