/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import junit.framework.TestCase;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.basic.BasicLookAndFeelAddons;

public class LookAndFeelAddonsTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public LookAndFeelAddonsTest(String arg0) {
        super(arg0);
    }

    public void testIssue159() throws Exception {
        String key = "Search.searchFieldLabel";
        UIManager.put(key, "customized");
        LookAndFeelAddons.getAddon();
        LookAndFeelAddonsTest.assertEquals((String)"customized", (String)UIManager.getString(key));
        UIManager.put(key, null);
        LookAndFeelAddonsTest.assertNotNull((Object)UIManager.getString(key));
    }

    public void testIssue144() throws Exception {
        UIManager.put("Addon.title", "customized");
        UIManager.put("Addon.border", new LineBorder(Color.blue));
        Addon addon = new Addon();
        LookAndFeelAddons.contribute(addon);
        LookAndFeelAddonsTest.assertEquals((Object)"customized", (Object)UIManager.get("Addon.title"));
        LookAndFeelAddonsTest.assertEquals((Object)"my subtitle", (Object)UIManager.get("Addon.subtitle"));
        LookAndFeelAddonsTest.assertTrue((boolean)(UIManager.get("Addon.border") instanceof LineBorder));
        UIManager.put("Addon.title", null);
        LookAndFeelAddonsTest.assertEquals((Object)"my title", (Object)UIManager.get("Addon.title"));
        LookAndFeelAddons.uncontribute(addon);
        LookAndFeelAddonsTest.assertNull((Object)UIManager.get("Addon.title"));
    }

    public void testContribute() throws Exception {
        Addon addon = new Addon();
        LookAndFeelAddons.contribute(addon);
        LookAndFeelAddonsTest.assertTrue((boolean)addon.initialized);
        LookAndFeelAddons.uncontribute(addon);
        LookAndFeelAddonsTest.assertTrue((boolean)addon.uninitialized);
        LookAndFeelAddons.contribute(addon);
        addon.initialized = false;
        addon.uninitialized = false;
        LookAndFeelAddons oldLFAddon = LookAndFeelAddons.getAddon();
        LookAndFeelAddons.setAddon(BasicLookAndFeelAddons.class);
        LookAndFeelAddons newLFAddon = LookAndFeelAddons.getAddon();
        LookAndFeelAddonsTest.assertTrue((boolean)addon.uninitialized);
        LookAndFeelAddonsTest.assertEquals((Object)oldLFAddon, (Object)addon.uninitializedWith);
        LookAndFeelAddonsTest.assertTrue((boolean)addon.initialized);
        LookAndFeelAddonsTest.assertEquals((Object)newLFAddon, (Object)addon.initializedWith);
    }

    static class Addon
    extends AbstractComponentAddon {
        boolean initialized;
        LookAndFeelAddons initializedWith;
        boolean uninitialized;
        LookAndFeelAddons uninitializedWith;

        public Addon() {
            super("Addon");
        }

        public void initialize(LookAndFeelAddons addon) {
            this.initialized = true;
            this.initializedWith = addon;
            addon.loadDefaults(this.getDefaults());
        }

        public void uninitialize(LookAndFeelAddons addon) {
            this.uninitialized = true;
            this.uninitializedWith = addon;
            addon.unloadDefaults(this.getDefaults());
        }

        protected Object[] getDefaults() {
            return new Object[]{"Addon.title", "my title", "Addon.subtitle", "my subtitle", "Addon.border", new BorderUIResource(new EmptyBorder(0, 0, 0, 0)), "Addon.color", new ColorUIResource(Color.blue)};
        }
    }
}

