/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.util.logging.Level;
import junit.framework.TestCase;
import org.jdesktop.swingx.event.MessageEvent;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.MessageSourceSupport;
import org.jdesktop.swingx.event.ProgressEvent;
import org.jdesktop.swingx.event.ProgressListener;

public class MessageTest
extends TestCase {
    private MListener[] listeners;
    private PListener[] plisteners;
    private static final int COUNT = 10;

    protected void setUp() {
        this.listeners = new MListener[10];
        this.plisteners = new PListener[10];
        int i = 0;
        while (i < 10) {
            this.listeners[i] = new MListener();
            this.plisteners[i] = new PListener();
            ++i;
        }
    }

    protected void tearDown() {
        int i = 0;
        while (i < 10) {
            this.listeners[i] = null;
            this.plisteners[i] = null;
            ++i;
        }
        this.listeners = null;
        this.plisteners = null;
    }

    public void testMessageRegistration() {
        MessageSourceSupport source = new MessageSourceSupport((Object)this);
        MessageListener[] ls = source.getMessageListeners();
        MessageTest.assertNotNull((Object)ls);
        MessageTest.assertEquals((String)"Number of listeners not 0", (int)0, (int)ls.length);
        int i = 0;
        while (i < this.listeners.length) {
            source.addMessageListener(this.listeners[i]);
            ++i;
        }
        ls = source.getMessageListeners();
        MessageTest.assertEquals((int)this.listeners.length, (int)ls.length);
        i = 0;
        while (i < this.listeners.length) {
            source.removeMessageListener(this.listeners[i]);
            ++i;
        }
        ls = source.getMessageListeners();
        MessageTest.assertEquals((int)0, (int)ls.length);
        i = 0;
        while (i < 10) {
            source.addMessageListener(null);
            ls = source.getMessageListeners();
            MessageTest.assertEquals((int)0, (int)ls.length);
            ++i;
        }
        i = 0;
        while (i < this.listeners.length) {
            source.addMessageListener(this.listeners[i]);
            ++i;
        }
        i = 0;
        while (i < 10) {
            source.removeMessageListener(null);
            ls = source.getMessageListeners();
            MessageTest.assertEquals((int)this.listeners.length, (int)ls.length);
            ++i;
        }
    }

    public void testMessageDispatch() {
        MessageSourceSupport source = new MessageSourceSupport((Object)this);
        int i = 0;
        while (i < this.listeners.length) {
            source.addMessageListener(this.listeners[i]);
            ++i;
        }
        String message = "This is a simple message";
        Level level = Level.INFO;
        long when = System.currentTimeMillis();
        MessageEvent evt = null;
        source.fireMessage(message);
        int i2 = 0;
        while (i2 < this.listeners.length) {
            evt = this.listeners[i2].getLastEvent();
            MessageTest.assertNotNull((Object)evt);
            MessageTest.assertEquals((String)message, (String)evt.getMessage());
            ++i2;
        }
        source.fireMessage(message, level);
        i2 = 0;
        while (i2 < this.listeners.length) {
            evt = this.listeners[i2].getLastEvent();
            MessageTest.assertNotNull((Object)evt);
            MessageTest.assertEquals((String)message, (String)evt.getMessage());
            MessageTest.assertEquals((Object)level, (Object)evt.getLevel());
            ++i2;
        }
        source.fireMessage(message, level, when);
        i2 = 0;
        while (i2 < this.listeners.length) {
            evt = this.listeners[i2].getLastEvent();
            MessageTest.assertNotNull((Object)evt);
            MessageTest.assertEquals((String)message, (String)evt.getMessage());
            MessageTest.assertEquals((Object)level, (Object)evt.getLevel());
            MessageTest.assertEquals((long)when, (long)evt.getWhen());
            ++i2;
        }
        evt = new MessageEvent((Object)this, message, level, when);
        source.fireMessage(evt);
        i2 = 0;
        while (i2 < this.listeners.length) {
            MessageTest.assertEquals((Object)evt, (Object)this.listeners[i2].getLastEvent());
            ++i2;
        }
    }

    public void testExceptions() {
        MessageSourceSupport source = new MessageSourceSupport((Object)this);
        int i = 0;
        while (i < this.listeners.length) {
            source.addMessageListener(this.listeners[i]);
            ++i;
        }
        Exception ex = new Exception("This is a message");
        MessageEvent evt = null;
        source.fireException(ex);
        int i2 = 0;
        while (i2 < this.listeners.length) {
            evt = this.listeners[i2].getLastEvent();
            MessageTest.assertNotNull((Object)evt);
            MessageTest.assertEquals((String)ex.getMessage(), (String)evt.getMessage());
            MessageTest.assertEquals((Object)Level.SEVERE, (Object)evt.getLevel());
            ++i2;
        }
    }

    public void testDeterminteProgress() {
        MessageSourceSupport source = new MessageSourceSupport((Object)this);
        ProgressEvent evt = null;
        int i = 0;
        while (i < this.plisteners.length) {
            source.addProgressListener(this.plisteners[i]);
            ++i;
        }
        source.fireProgressStarted(0, 100);
        i = 0;
        while (i < this.plisteners.length) {
            evt = this.plisteners[i].getLastEvent();
            MessageTest.assertFalse((boolean)evt.isIndeterminate());
            MessageTest.assertTrue((boolean)this.plisteners[i].begin);
            MessageTest.assertFalse((boolean)this.plisteners[i].end);
            ++i;
        }
        source.fireProgressIncremented(50);
        i = 0;
        while (i < this.plisteners.length) {
            evt = this.plisteners[i].getLastEvent();
            MessageTest.assertFalse((boolean)evt.isIndeterminate());
            MessageTest.assertFalse((boolean)this.plisteners[i].begin);
            MessageTest.assertFalse((boolean)this.plisteners[i].end);
            ++i;
        }
        source.fireProgressEnded();
        i = 0;
        while (i < this.plisteners.length) {
            evt = this.plisteners[i].getLastEvent();
            MessageTest.assertTrue((boolean)evt.isIndeterminate());
            MessageTest.assertFalse((boolean)this.plisteners[i].begin);
            MessageTest.assertTrue((boolean)this.plisteners[i].end);
            ++i;
        }
    }

    public void testIndeterminteProgress() {
        MessageSourceSupport source = new MessageSourceSupport((Object)this);
        ProgressEvent evt = null;
        int i = 0;
        while (i < this.plisteners.length) {
            source.addProgressListener(this.plisteners[i]);
            ++i;
        }
        source.fireProgressStarted(0, 0);
        i = 0;
        while (i < this.plisteners.length) {
            evt = this.plisteners[i].getLastEvent();
            MessageTest.assertTrue((boolean)evt.isIndeterminate());
            MessageTest.assertTrue((boolean)this.plisteners[i].begin);
            MessageTest.assertFalse((boolean)this.plisteners[i].end);
            ++i;
        }
    }

    private class MListener
    implements MessageListener {
        private MessageEvent evt;

        MListener() {
        }

        public void message(MessageEvent evt) {
            this.evt = evt;
        }

        public void exception(MessageEvent evt) {
            this.evt = evt;
        }

        public MessageEvent getLastEvent() {
            return this.evt;
        }
    }

    private class PListener
    implements ProgressListener {
        private ProgressEvent evt;
        public boolean begin = false;
        public boolean end = false;

        PListener() {
        }

        public void progressStarted(ProgressEvent e) {
            this.evt = e;
            this.begin = true;
            this.end = false;
        }

        public void progressIncremented(ProgressEvent e) {
            this.evt = e;
            this.begin = false;
            this.end = false;
        }

        public void progressEnded(ProgressEvent e) {
            this.evt = e;
            this.begin = false;
            this.end = true;
        }

        public void exception(ProgressEvent e) {
        }

        public ProgressEvent getLastEvent() {
            return this.evt;
        }
    }
}

