/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.FilterTest;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.ShuttleSorter;
import org.jdesktop.swingx.util.AncientSwingTeam;

public class SelectionMapperTest
extends InteractiveTestCase {
    private TableModel ascendingModel;
    protected ComponentAdapter ascendingModelAdapter;
    static /* synthetic */ Class class$0;

    public SelectionMapperTest() {
        super("SelectionMapperTest");
    }

    public void testSynchLeadSelection() {
        DefaultListSelectionModel viewSelectionModel = new DefaultListSelectionModel();
        int selected = 0;
        viewSelectionModel.setSelectionInterval(selected, selected);
        FilterPipeline pipeline = null;
        SelectionMapper selectionMapper = new SelectionMapper(pipeline, viewSelectionModel);
        int anchor = selected;
        int lead = selected;
        this.assertAnchorLeadSynched(anchor, lead, viewSelectionModel, selectionMapper);
        anchor = 2;
        viewSelectionModel.setValueIsAdjusting(true);
        viewSelectionModel.setAnchorSelectionIndex(anchor);
        viewSelectionModel.setValueIsAdjusting(false);
        this.assertAnchorLeadSynched(anchor, lead, viewSelectionModel, selectionMapper);
    }

    public void testAnchorLeadSelection() {
        DefaultListSelectionModel viewSelectionModel = new DefaultListSelectionModel();
        int selected = 0;
        viewSelectionModel.setSelectionInterval(selected, selected);
        int anchor = selected;
        int lead = selected;
        this.assertAnchorLead(anchor, lead, viewSelectionModel);
        anchor = 2;
        viewSelectionModel.setValueIsAdjusting(true);
        viewSelectionModel.setAnchorSelectionIndex(anchor);
        viewSelectionModel.setValueIsAdjusting(false);
        this.assertAnchorLead(anchor, lead, viewSelectionModel);
    }

    private void assertAnchorLeadSynched(int anchor, int lead, ListSelectionModel viewSelection, SelectionMapper mapper) {
        this.assertAnchorLead(anchor, lead, viewSelection);
        this.assertAnchorLead(anchor, lead, mapper.modelSelection);
    }

    private void assertAnchorLead(int anchor, int lead, ListSelectionModel viewSelection) {
        SelectionMapperTest.assertEquals((String)"anchor", (int)anchor, (int)viewSelection.getAnchorSelectionIndex());
        SelectionMapperTest.assertEquals((String)"lead", (int)lead, (int)viewSelection.getLeadSelectionIndex());
    }

    public void testSelectionNullPipeline() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionInterval(0, 0);
        SelectionMapper selectionMapper = new SelectionMapper(null, selectionModel);
        selectionMapper.restoreSelection();
        SelectionMapperTest.assertTrue((String)"selection must be retained", (boolean)selectionModel.isSelectedIndex(0));
    }

    public void testLeadSelectionSetPipeline() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        int index0 = 0;
        int lead = 2;
        int index1 = 4;
        selectionModel.addSelectionInterval(index0, index0);
        selectionModel.addSelectionInterval(index1, index1);
        selectionModel.addSelectionInterval(lead, lead);
        SelectionMapperTest.assertEquals((String)"lead is last selected", (int)lead, (int)selectionModel.getLeadSelectionIndex());
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.setSorter(new ShuttleSorter(0, false));
        pipeline.assign(this.ascendingModelAdapter);
        new SelectionMapper(pipeline, selectionModel);
        SelectionMapperTest.assertEquals((String)"lead selection must be last added", (int)pipeline.convertRowIndexToView(lead), (int)selectionModel.getLeadSelectionIndex());
    }

    public void testSelectionSetPipeline() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.setSorter(new ShuttleSorter(0, false));
        pipeline.assign(this.ascendingModelAdapter);
        int index = 0;
        selectionModel.setSelectionInterval(index, index);
        SelectionMapper selectionMapper = new SelectionMapper(null, selectionModel);
        selectionMapper.setFilters(pipeline);
        SelectionMapperTest.assertEquals((String)"view selection must be last", (int)(this.ascendingModelAdapter.getRowCount() - 1), (int)selectionModel.getMinSelectionIndex());
    }

    public void testKeepSelectionOnFilterChange() {
        JXTable table = new JXTable(this.ascendingModel);
        int selectedRow = 0;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        SelectionMapperTest.assertEquals((int)selectedRow, (int)table.getSelectedRow());
        PatternFilter filter = new PatternFilter(".*", 0, 0);
        table.setFilters(new FilterPipeline(new Filter[]{filter}));
        SelectionMapperTest.assertEquals((int)this.ascendingModel.getRowCount(), (int)table.getRowCount());
        SelectionMapperTest.assertEquals((String)"table must keep selection after setting filter", (int)selectedRow, (int)table.getSelectedRow());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ascendingModel = this.createAscendingModel(0, 20);
        this.ascendingModelAdapter = new FilterTest.DirectModelAdapter(this.ascendingModel);
    }

    private DefaultTableModel createAscendingModel(int startRow, int count) {
        DefaultTableModel model = new DefaultTableModel(count, 5){

            public Class getColumnClass(int column) {
                return column == 0 ? Integer.class : super.getColumnClass(column);
            }
        };
        int i = 0;
        while (i < model.getRowCount()) {
            model.setValueAt(new Integer(startRow++), i, 0);
            ++i;
        }
        return model;
    }

    private FilterPipeline createPipeline() {
        Filter filterZero = this.createDefaultPatternFilter(0);
        Filter filterTwo = this.createDefaultPatternFilter(2);
        ShuttleSorter sorter = new ShuttleSorter();
        Filter[] filters = new Filter[]{filterZero, filterTwo, sorter};
        FilterPipeline pipeline = new FilterPipeline(filters);
        return pipeline;
    }

    protected Filter createDefaultPatternFilter(int column) {
        PatternFilter filterZero = new PatternFilter("e", 0, column);
        return filterZero;
    }

    public void interactiveTestColumnControlAndFilters() {
        final JXTable table = new JXTable(new AncientSwingTeam());
        table.setColumnControlVisible(true);
        AbstractAction toggleFilter = new AbstractAction("Toggle Filters"){
            boolean hasFilters;

            public void actionPerformed(ActionEvent e) {
                if (this.hasFilters) {
                    table.setFilters(null);
                } else {
                    table.setFilters(SelectionMapperTest.this.createPipeline());
                }
                this.hasFilters = !this.hasFilters;
            }
        };
        toggleFilter.putValue("ShortDescription", "filtering first column - problem if invisible ");
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable ColumnControl and Filters");
        this.addAction(frame, toggleFilter);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SelectionMapperTest.setSystemLF(true);
        SelectionMapperTest test = new SelectionMapperTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }
}

