/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.PatternHighlighter;

public class SearchHighlighter
extends PatternHighlighter {
    int highlightRow;
    private boolean enableHighlight;
    private static final String ALL = ".*";

    public SearchHighlighter() {
        this(Color.YELLOW.brighter(), null);
    }

    public SearchHighlighter(Color background, Color foreground) {
        super(background, foreground, null, 0, -1);
        this.setHighlightRow(-1);
    }

    public void setEnabled(boolean enableHighlight) {
        this.enableHighlight = enableHighlight;
        this.fireStateChanged();
    }

    protected boolean needsHighlight(ComponentAdapter adapter) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.highlightRow >= 0 && adapter.row != this.highlightRow) {
            return false;
        }
        return super.needsHighlight(adapter);
    }

    private boolean isEnabled() {
        Pattern pattern = this.getPattern();
        if (pattern == null || ALL.equals(pattern.pattern())) {
            return false;
        }
        return this.enableHighlight;
    }

    protected boolean test(ComponentAdapter adapter) {
        Object value;
        if (this.pattern == null) {
            return false;
        }
        int columnToTest = this.testColumn;
        if (columnToTest < 0) {
            columnToTest = adapter.viewToModel(adapter.column);
        }
        if ((value = adapter.getFilteredValueAt(adapter.row, columnToTest)) == null) {
            return false;
        }
        boolean matches = this.pattern.matcher(value.toString()).find();
        return matches;
    }

    public void setHighlightRow(int row) {
        this.highlightRow = row;
        this.fireStateChanged();
    }

    public void setHighlightAll() {
        this.setHighlightCell(-1, -1);
    }

    public void setHighlightCell(int row, int modelColumn) {
        this.testColumn = modelColumn;
        this.highlightColumn = modelColumn;
        this.highlightRow = row;
        this.setEnabled(true);
    }
}

