/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.ConditionalHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.SearchHighlighter;
import org.jdesktop.swingx.util.ChangeReport;

public class HighlighterTest
extends InteractiveTestCase {
    protected Highlighter[] highlighters;
    protected static final boolean UNSELECTED = false;
    protected static final boolean SELECTED = true;
    protected static final boolean FAIL_ALWAYS = false;
    protected static final boolean PASS_ALWAYS = true;
    protected JLabel backgroundNull;
    protected JLabel foregroundNull;
    protected JLabel allNull;
    protected JLabel allColored;
    protected Color background = Color.RED;
    protected Color foreground = Color.BLUE;
    protected Highlighter emptyHighlighter;

    protected void setUp() {
        this.highlighters = new Highlighter[]{new AlternateRowHighlighter(Color.white, new Color(240, 240, 224), null), new PatternHighlighter(null, this.foreground, "^s", 0, 0)};
        this.backgroundNull = new JLabel("test");
        this.backgroundNull.setForeground(this.foreground);
        this.backgroundNull.setBackground(null);
        this.foregroundNull = new JLabel("test");
        this.foregroundNull.setForeground(null);
        this.foregroundNull.setBackground(this.background);
        this.allNull = new JLabel("test");
        this.allNull.setForeground(null);
        this.allNull.setBackground(null);
        this.allColored = new JLabel("test");
        this.allColored.setForeground(this.foreground);
        this.allColored.setBackground(this.background);
        this.emptyHighlighter = new Highlighter();
    }

    protected void tearDown() {
        int i = 0;
        while (i < this.highlighters.length) {
            this.highlighters[i] = null;
            ++i;
        }
        this.highlighters = null;
    }

    public void testUIHighlighter() {
        AlternateRowHighlighter.UIAlternateRowHighlighter highlighter = new AlternateRowHighlighter.UIAlternateRowHighlighter();
    }

    public void testConstructors() {
        Highlighter empty = new Highlighter();
        this.assertColors(empty, null, null, null, null, false);
        Highlighter normal = new Highlighter(this.background, this.foreground);
        this.assertColors(normal, this.background, this.foreground, null, null, false);
        Highlighter normalImmutable = new Highlighter(this.background, this.foreground, true);
        this.assertColors(normalImmutable, this.background, this.foreground, null, null, true);
        Color selectedBackground = Color.YELLOW;
        Color selectedForeground = Color.BLACK;
        Highlighter full = new Highlighter(this.background, this.foreground, selectedBackground, selectedForeground);
        this.assertColors(full, this.background, this.foreground, selectedBackground, selectedForeground, false);
        Highlighter fullImmutable = new Highlighter(this.background, this.foreground, selectedBackground, selectedForeground, true);
        this.assertColors(fullImmutable, this.background, this.foreground, selectedBackground, selectedForeground, true);
    }

    public void testImmutable() {
        Highlighter immutable = new Highlighter(this.background, this.foreground, true);
        ChangeReport report = new ChangeReport();
        immutable.addChangeListener(report);
        HighlighterTest.assertEquals((String)"no listeners", (int)0, (int)immutable.getChangeListeners().length);
        immutable.setForeground(Color.BLACK);
        immutable.setBackground(Color.YELLOW);
        immutable.setSelectedForeground(Color.BLACK);
        immutable.setSelectedBackground(Color.YELLOW);
        this.assertColors(immutable, this.background, this.foreground, null, null, true);
    }

    public void testAlternateRowImmutable() {
        Color evenColor = Color.YELLOW;
        AlternateRowHighlighter immutable = new AlternateRowHighlighter(this.background, evenColor, this.foreground, true);
        this.assertColors(immutable, this.background, this.foreground, null, null, true);
        this.assertAlternateColors(immutable, this.background, evenColor);
        immutable.setOddRowBackground(Color.GRAY);
        immutable.setEvenRowBackground(Color.CYAN);
        this.assertColors(immutable, this.background, this.foreground, null, null, true);
        this.assertAlternateColors(immutable, this.background, evenColor);
    }

    private void assertAlternateColors(AlternateRowHighlighter immutable, Color oddColor, Color evenColor) {
        HighlighterTest.assertEquals((String)"oddbackground", (Object)oddColor, (Object)immutable.getOddRowBackground());
        HighlighterTest.assertEquals((String)"evenbackground", (Object)evenColor, (Object)immutable.getEvenRowBackground());
    }

    public void testImmutablePredefinedHighlighters() {
        HighlighterTest.assertTrue((String)"ledger must be immutable", (boolean)Highlighter.ledgerBackground.isImmutable());
        HighlighterTest.assertTrue((String)"notepad must be immutable", (boolean)Highlighter.notePadBackground.isImmutable());
        HighlighterTest.assertTrue((String)"beige must be immutable", (boolean)AlternateRowHighlighter.beige.isImmutable());
        HighlighterTest.assertTrue((String)"floral must be immutable", (boolean)AlternateRowHighlighter.floralWhite.isImmutable());
        HighlighterTest.assertTrue((String)"lineprinter must be immutable", (boolean)AlternateRowHighlighter.linePrinter.isImmutable());
        HighlighterTest.assertTrue((String)"classiclineprinter must be immutable", (boolean)AlternateRowHighlighter.classicLinePrinter.isImmutable());
        HighlighterTest.assertTrue((String)"quickSilver must be immutable", (boolean)AlternateRowHighlighter.quickSilver.isImmutable());
    }

    private void assertColors(Highlighter highlighter, Color background, Color foreground, Color selectedBackground, Color selectedForeground, boolean immutable) {
        HighlighterTest.assertEquals((String)"background", (Object)background, (Object)highlighter.getBackground());
        HighlighterTest.assertEquals((String)"foreground", (Object)foreground, (Object)highlighter.getForeground());
        HighlighterTest.assertEquals((String)"selectedbackground", (Object)selectedBackground, (Object)highlighter.getSelectedBackground());
        HighlighterTest.assertEquals((String)"selectedForeground", (Object)selectedForeground, (Object)highlighter.getSelectedForeground());
        HighlighterTest.assertEquals((String)"immutable", (boolean)immutable, (boolean)highlighter.isImmutable());
    }

    public void testAddToEmptyHighlighterPipeline() {
        HighlighterPipeline pipeline = new HighlighterPipeline(new Highlighter[0]);
        pipeline.addHighlighter(new Highlighter());
    }

    public void testRemoveFromEmptyHighlighterPipeline() {
        HighlighterPipeline pipeline = new HighlighterPipeline(new Highlighter[0]);
        pipeline.removeHighlighter(new Highlighter());
    }

    public void testApplyEmptyHighlighterPipeline() {
        HighlighterPipeline pipeline = new HighlighterPipeline(new Highlighter[0]);
        pipeline.apply(new JLabel(), this.createComponentAdapter(new JLabel(), false));
    }

    public void testHighlighterPipelineWithDuplicates() {
    }

    public void testHighlighterPipelineChange() {
        Highlighter highlighter = new Highlighter();
        HighlighterPipeline pipeline = new HighlighterPipeline();
        ChangeReport changeReport = new ChangeReport();
        pipeline.addChangeListener(changeReport);
        int count = changeReport.getEventCount();
        pipeline.addHighlighter(highlighter);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        this.assertPipelineChange(highlighter, pipeline, changeReport);
    }

    public void testHighlighterPipelineChangeConstructor() {
        Highlighter highlighter = new Highlighter();
        HighlighterPipeline pipeline = new HighlighterPipeline(new Highlighter[]{highlighter});
        ChangeReport changeReport = new ChangeReport();
        pipeline.addChangeListener(changeReport);
        this.assertPipelineChange(highlighter, pipeline, changeReport);
    }

    private void assertPipelineChange(Highlighter highlighter, HighlighterPipeline pipeline, ChangeReport changeReport) {
        int count = changeReport.getEventCount();
        highlighter.setBackground(Color.red);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        HighlighterTest.assertEquals((String)"event source must be pipeline", (Object)pipeline, (Object)changeReport.getLastEvent().getSource());
        pipeline.removeHighlighter(highlighter);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        pipeline.removeHighlighter(highlighter);
        HighlighterTest.assertEquals((String)"event count must not be increased", (int)count, (int)changeReport.getEventCount());
        highlighter.setBackground(Color.BLUE);
        HighlighterTest.assertEquals((String)"event count must not be increased", (int)count, (int)changeReport.getEventCount());
    }

    public void testHighlighterChange() {
        Highlighter highlighter = new Highlighter();
        ChangeReport changeReport = new ChangeReport();
        highlighter.addChangeListener(changeReport);
        this.assertBaseHighlighterChange(highlighter, changeReport);
    }

    private void assertBaseHighlighterChange(Highlighter highlighter, ChangeReport changeReport) {
        int count = changeReport.getEventCount();
        highlighter.setBackground(Color.red);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setForeground(Color.red);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setSelectedBackground(Color.red);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setSelectedForeground(Color.red);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
    }

    public void testAlternateRowHighlighterChange() {
        AlternateRowHighlighter highlighter = new AlternateRowHighlighter();
        ChangeReport changeReport = new ChangeReport();
        highlighter.addChangeListener(changeReport);
        this.assertBaseHighlighterChange(highlighter, changeReport);
        int count = changeReport.getEventCount();
        highlighter.setOddRowBackground(Color.red);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setEvenRowBackground(Color.red);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
    }

    public void testColumnPropertyHighlighterChange() {
    }

    public void testConditionalHighlighterChange() {
        ConditionalHighlighter highlighter = new ConditionalHighlighter(){

            protected boolean test(ComponentAdapter adapter) {
                return false;
            }
        };
        ChangeReport changeReport = new ChangeReport();
        highlighter.addChangeListener(changeReport);
        this.assertBaseHighlighterChange(highlighter, changeReport);
        this.assertBaseConditionalChange(highlighter, changeReport);
    }

    public void testPatternHighlighterChange() {
        PatternHighlighter highlighter = new PatternHighlighter();
        ChangeReport changeReport = new ChangeReport();
        highlighter.addChangeListener(changeReport);
        this.assertBaseHighlighterChange(highlighter, changeReport);
        this.assertBasePatternChange(highlighter, changeReport);
    }

    public void testSearchHighlighterChange() {
        SearchHighlighter highlighter = new SearchHighlighter();
        ChangeReport changeReport = new ChangeReport();
        highlighter.addChangeListener(changeReport);
        this.assertBaseHighlighterChange(highlighter, changeReport);
        this.assertBasePatternChange(highlighter, changeReport);
        this.assertBaseConditionalChange(highlighter, changeReport);
        int count = changeReport.getEventCount();
        highlighter.setEnabled(true);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setHighlightRow(3);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setHighlightAll();
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setHighlightCell(5, 7);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
    }

    private void assertBasePatternChange(PatternHighlighter highlighter, ChangeReport changeReport) {
        this.assertBaseConditionalChange(highlighter, changeReport);
        int count = changeReport.getEventCount();
        highlighter.setPattern("x", 0);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setPattern(Pattern.compile(".*", 0));
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
    }

    private void assertBaseConditionalChange(ConditionalHighlighter highlighter, ChangeReport changeReport) {
        int count = changeReport.getEventCount();
        highlighter.setHighlightColumnIndex(5);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setMask(255);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
        highlighter.setTestColumnIndex(255);
        HighlighterTest.assertEquals((String)"event count must be increased", (int)(++count), (int)changeReport.getEventCount());
    }

    public void testJavaDocExample() {
        Highlighter[] highlighters = new Highlighter[]{new AlternateRowHighlighter(Color.white, new Color(240, 240, 224), null), new PatternHighlighter(null, Color.red, "^s", 0, 0)};
        HighlighterPipeline highlighterPipeline = new HighlighterPipeline(highlighters);
        JXTable table = new JXTable();
        table.setHighlighters(highlighterPipeline);
    }

    public void testAddRemoveHighlighter() {
        HighlighterPipeline pipeline = new HighlighterPipeline(this.highlighters);
        PatternHighlighter hl = new PatternHighlighter(Color.blue, Color.red, "mark", 0, 0);
        PatternHighlighter hl2 = new PatternHighlighter(Color.white, Color.black, "amy", 0, 0);
        pipeline.addHighlighter(hl);
        Highlighter[] hls = pipeline.getHighlighters();
        HighlighterTest.assertTrue((hls.length == 3 ? 1 : 0) != 0);
        HighlighterTest.assertTrue((hls[2] == hl ? 1 : 0) != 0);
        pipeline.addHighlighter(hl2, true);
        hls = pipeline.getHighlighters();
        HighlighterTest.assertTrue((hls.length == 4 ? 1 : 0) != 0);
        HighlighterTest.assertTrue((hls[0] == hl2 ? 1 : 0) != 0);
        pipeline.removeHighlighter(hl);
        hls = pipeline.getHighlighters();
        HighlighterTest.assertTrue((hls.length == 3 ? 1 : 0) != 0);
        int i = 0;
        while (i < hls.length) {
            HighlighterTest.assertTrue((hls[i] != hl ? 1 : 0) != 0);
            ++i;
        }
        pipeline.removeHighlighter(hl2);
        hls = pipeline.getHighlighters();
        HighlighterTest.assertTrue((hls.length == 2 ? 1 : 0) != 0);
        i = 0;
        while (i < hls.length) {
            HighlighterTest.assertTrue((hls[i] != hl2 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testLabelSanity() {
        HighlighterTest.assertNull((String)"foreground must be null", (Object)this.foregroundNull.getForeground());
        HighlighterTest.assertNotNull((String)"background must not be null", (Object)this.foregroundNull.getBackground());
        HighlighterTest.assertNull((String)"background must be null", (Object)this.backgroundNull.getBackground());
        HighlighterTest.assertNotNull((String)"foreground must not be null", (Object)this.backgroundNull.getForeground());
        HighlighterTest.assertNull((String)"foreground must be null", (Object)this.allNull.getForeground());
        HighlighterTest.assertNull((String)"background must be null", (Object)this.allNull.getBackground());
        HighlighterTest.assertEquals((Object)this.background, (Object)this.allColored.getBackground());
        HighlighterTest.assertEquals((Object)this.foreground, (Object)this.allColored.getForeground());
    }

    public void testNullBackgroundOnConditional() {
        this.assertApply(this.backgroundNull, false, false);
    }

    public void testNullForegroundOnConditional() {
        this.assertApply(this.foregroundNull, false, false);
    }

    public void testNullBackgroundOnConditionalSelected() {
        this.assertApply(this.backgroundNull, false, true);
    }

    public void testNullForegroundOnConditionalSelected() {
        this.assertApply(this.foregroundNull, false, true);
    }

    public void testNullForegroundOnConditionalPass() {
        this.assertApply(this.foregroundNull, true, false);
    }

    public void testNullBackgroundOnConditionalPass() {
        this.assertApply(this.backgroundNull, true, false);
    }

    public void testNullForegroundOnConditionalPassSelected() {
        this.assertApply(this.foregroundNull, true, true);
    }

    public void testNullBackgroundOnConditionalPassSelected() {
        this.assertApply(this.backgroundNull, true, true);
    }

    private void assertApply(JLabel label, boolean testStatus, boolean selected) {
        this.assertApplyHighlightColors(Color.green, Color.magenta, label, testStatus, selected);
    }

    private void assertApplyNoColors(JLabel label, boolean testStatus, boolean selected) {
        this.assertApplyHighlightColors(null, null, label, testStatus, selected);
    }

    private void assertApplyHighlightColors(Color background, Color foreground, JLabel label, boolean testStatue, boolean selected) {
        Highlighter highlighter = this.createConditionalHighlighter(background, foreground, testStatue);
        ComponentAdapter adapter = this.createComponentAdapter(label, selected);
        highlighter.highlight(label, adapter);
    }

    private Highlighter createConditionalHighlighter(Color background, Color foreground, final boolean pass) {
        ConditionalHighlighter highlighter = new ConditionalHighlighter(background, foreground, 0, -1){

            protected boolean test(ComponentAdapter adapter) {
                return pass;
            }
        };
        return highlighter;
    }

    public void testNullBackgroundOnHighlighter() {
        HighlighterPipeline pipeline = new HighlighterPipeline(new Highlighter[]{new Highlighter(null, null)});
        ComponentAdapter adapter = this.createComponentAdapter(this.backgroundNull, false);
        pipeline.apply(this.backgroundNull, adapter);
    }

    public void testNullForegroundOnHighlighter() {
        HighlighterPipeline pipeline = new HighlighterPipeline(new Highlighter[]{new Highlighter(null, null)});
        ComponentAdapter adapter = this.createComponentAdapter(this.foregroundNull, false);
        pipeline.apply(this.foregroundNull, adapter);
    }

    public void testUnSelectedDoNothingHighlighter() {
        ComponentAdapter adapter = this.createComponentAdapter(this.allColored, false);
        this.emptyHighlighter.highlight(this.allColored, adapter);
        HighlighterTest.assertEquals((String)"default highlighter must not change foreground", (Object)this.foreground, (Object)this.allColored.getForeground());
        HighlighterTest.assertEquals((String)"default highlighter must not change background", (Object)this.background, (Object)this.allColored.getBackground());
    }

    protected ComponentAdapter createComponentAdapter(final JLabel label, final boolean selected) {
        ComponentAdapter adapter = new ComponentAdapter(label){

            public Object getValueAt(int row, int column) {
                return label.getText();
            }

            public Object getFilteredValueAt(int row, int column) {
                return this.getValueAt(row, column);
            }

            public void setValueAt(Object aValue, int row, int column) {
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public boolean hasFocus() {
                return false;
            }

            public boolean isSelected() {
                return selected;
            }

            public String getColumnName(int columnIndex) {
                return null;
            }

            public String getColumnIdentifier(int columnIndex) {
                return null;
            }
        };
        return adapter;
    }
}

