/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.ListModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.HighlighterTest;

public class HighlighterIssues
extends HighlighterTest {
    protected Color ledger = new Color(245, 255, 245);

    public static void main(String[] args) {
        HighlighterIssues test = new HighlighterIssues();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }

    public void interactiveUITableWithAlternateRow() {
        final AlternateRowHighlighter.UIAlternateRowHighlighter highlighter = new AlternateRowHighlighter.UIAlternateRowHighlighter();
        JXTable table = new JXTable(10, 2){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ComponentAdapter componentAdapter = this.getComponentAdapter();
                componentAdapter.row = row;
                componentAdapter.column = column;
                return highlighter.highlight(comp, componentAdapter);
            }

            public void updateUI() {
                super.updateUI();
                highlighter.updateUI();
                this.repaint();
            }
        };
        table.setBackground(this.ledger);
        JXTable nohighlight = new JXTable(10, 2);
        nohighlight.setBackground(this.ledger);
        JXFrame frame = this.wrapWithScrollingInFrame(table, nohighlight, "colored table with alternate highlighter");
        frame.setVisible(true);
    }

    public void interactiveColoredTableWithAlternateRow() {
        JXTable table = new JXTable(10, 2){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ComponentAdapter componentAdapter = this.getComponentAdapter();
                componentAdapter.row = row;
                componentAdapter.column = column;
                return AlternateRowHighlighter.genericGrey.highlight(comp, componentAdapter);
            }
        };
        table.setBackground(this.ledger);
        JXTable nohighlight = new JXTable(10, 2);
        nohighlight.setBackground(this.ledger);
        JXFrame frame = this.wrapWithScrollingInFrame(table, nohighlight, "colored table with alternate highlighter");
        frame.setVisible(true);
    }

    public void interactiveColoredListWithAlternateRow() {
        JXList list = new JXList(this.createListModel());
        list.setBackground(this.ledger);
        HighlighterPipeline pipeline = new HighlighterPipeline();
        pipeline.addHighlighter(AlternateRowHighlighter.genericGrey);
        list.setHighlighters(pipeline);
        JXList nohighlight = new JXList(this.createListModel());
        nohighlight.setBackground(this.ledger);
        JXFrame frame = this.wrapWithScrollingInFrame(list, nohighlight, "colored list with alternate highlighter");
        frame.setVisible(true);
    }

    public void interactiveColoredTreeWithAlternateRow() {
        JXTree nohighlight = new JXTree();
        nohighlight.setBackground(this.ledger);
        JXTree list = new JXTree();
        HighlighterPipeline pipeline = new HighlighterPipeline();
        pipeline.addHighlighter(AlternateRowHighlighter.genericGrey);
        list.setHighlighters(pipeline);
        list.setBackground(this.ledger);
        JXFrame frame = this.wrapWithScrollingInFrame(list, nohighlight, "colored tree with alternate highlighter");
        frame.setVisible(true);
    }

    public void testSelectedDoNothingHighlighter() {
        ComponentAdapter adapter = this.createComponentAdapter(this.allColored, true);
        this.emptyHighlighter.highlight(this.allColored, adapter);
        HighlighterIssues.assertEquals((String)"default highlighter must not change foreground", (Object)this.foreground, (Object)this.allColored.getForeground());
        HighlighterIssues.assertEquals((String)"default highlighter must not change background", (Object)this.background, (Object)this.allColored.getBackground());
    }

    public void interactiveTableWithDoNothingHighlighter() {
        JXTable table = new JXTable(10, 2){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ComponentAdapter componentAdapter = this.getComponentAdapter();
                componentAdapter.row = row;
                componentAdapter.column = column;
                return HighlighterIssues.this.emptyHighlighter.highlight(comp, componentAdapter);
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(table, new JXTable(10, 2), "table with empty highlighter");
        frame.setVisible(true);
    }

    public void interactiveListWithDoNothingHighlighter() {
        JXList list = new JXList(this.createListModel());
        HighlighterPipeline pipeline = new HighlighterPipeline();
        pipeline.addHighlighter(this.emptyHighlighter);
        list.setHighlighters(pipeline);
        JXFrame frame = this.wrapWithScrollingInFrame(list, new JXList(this.createListModel()), "list with empty highlighter");
        frame.setVisible(true);
    }

    public void interactiveTreeWithDoNothingHighlighter() {
        JXTree list = new JXTree();
        HighlighterPipeline pipeline = new HighlighterPipeline();
        pipeline.addHighlighter(this.emptyHighlighter);
        list.setHighlighters(pipeline);
        JXFrame frame = this.wrapWithScrollingInFrame(list, new JXTree(), "list with empty highlighter");
        frame.setVisible(true);
    }

    public void interactiveDoNothingHighlighter() {
        Box box = Box.createVerticalBox();
        this.allColored.setText("unhighlighted");
        this.allColored.setOpaque(true);
        box.add(this.allColored);
        JLabel label = new JLabel("highlighted - unselected");
        label.setBackground(this.allColored.getBackground());
        label.setForeground(this.allColored.getForeground());
        label.setOpaque(true);
        ComponentAdapter adapter = this.createComponentAdapter(label, false);
        this.emptyHighlighter.highlight(label, adapter);
        box.add(label);
        label = new JLabel("highlighted - selected");
        label.setBackground(this.allColored.getBackground());
        label.setForeground(this.allColored.getForeground());
        label.setOpaque(true);
        adapter = this.createComponentAdapter(label, true);
        this.emptyHighlighter.highlight(label, adapter);
        box.add(label);
        JXFrame frame = this.wrapInFrame(box, "labels with empty highlighter");
        frame.setVisible(true);
    }

    private ListModel createListModel() {
        DefaultListModel<Integer> model = new DefaultListModel<Integer>();
        int i = 0;
        while (i < 10) {
            model.add(i, i);
            ++i;
        }
        return model;
    }
}

