/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.ShuttleSorter;
import org.jdesktop.swingx.util.AncientSwingTeam;
import org.jdesktop.swingx.util.PipelineReport;

public class FilterTest
extends InteractiveTestCase {
    private TableModel tableModel;
    protected ComponentAdapter directModelAdapter;
    private PipelineReport pipelineReport;

    public FilterTest() {
        super("FilterTest");
    }

    public void testAndFilter() {
        PatternFilter first = new PatternFilter("a", 0, 0);
        PatternFilter second = new PatternFilter("b", 0, 1);
        FilterPipeline pipeline = new FilterPipeline(new Filter[]{first, second});
        pipeline.assign(this.directModelAdapter);
        FilterTest.assertTrue((pipeline.getOutputSize() > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < pipeline.getOutputSize()) {
            boolean firstMatch = first.getPattern().matcher(pipeline.getValueAt(i, 0).toString()).find();
            boolean secondMatch = second.getPattern().matcher(pipeline.getValueAt(i, 1).toString()).find();
            FilterTest.assertTrue((boolean)firstMatch);
            FilterTest.assertEquals((String)"both matchers must find", (boolean)firstMatch, (boolean)secondMatch);
            ++i;
        }
    }

    public void testFlushOnAssign() {
        PatternFilter filter = new PatternFilter(".*", 0, 0);
        FilterPipeline pipeline = new FilterPipeline(new Filter[]{filter});
        pipeline.assign(this.directModelAdapter);
        FilterTest.assertEquals((String)"pipeline output size must be model count", (int)this.directModelAdapter.getRowCount(), (int)pipeline.getOutputSize());
        Object value = pipeline.getValueAt(0, 0);
        FilterTest.assertEquals((String)"value access via sorter must return the same as via pipeline", (Object)value, (Object)pipeline.getValueAt(0, 0));
    }

    public void testPipelineEventOnSameSorter() {
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.assign(this.directModelAdapter);
        pipeline.addPipelineListener(this.pipelineReport);
        ShuttleSorter sorter = new ShuttleSorter();
        pipeline.setSorter(sorter);
        FilterTest.assertEquals((String)"pipeline must have fired on setSorter", (int)1, (int)this.pipelineReport.getEventCount());
        this.pipelineReport.clear();
        pipeline.setSorter(sorter);
        FilterTest.assertEquals((String)"pipeline must not have fired on same setSorter", (int)0, (int)this.pipelineReport.getEventCount());
    }

    public void testPipelineEventOnSetSorter() {
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.assign(this.directModelAdapter);
        pipeline.addPipelineListener(this.pipelineReport);
        pipeline.setSorter(new ShuttleSorter());
        FilterTest.assertEquals((String)"pipeline must have fired on setSorter", (int)1, (int)this.pipelineReport.getEventCount());
        this.pipelineReport.clear();
        pipeline.setSorter(null);
        FilterTest.assertEquals((String)"pipeline must have fired on setSorter null", (int)1, (int)this.pipelineReport.getEventCount());
    }

    public void testPipelineEventOnSetSorterUnassigned() {
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.addPipelineListener(this.pipelineReport);
        pipeline.setSorter(new ShuttleSorter());
        FilterTest.assertEquals((String)"pipeline must not fire if unassigned", (int)0, (int)this.pipelineReport.getEventCount());
        this.pipelineReport.clear();
        pipeline.setSorter(null);
        FilterTest.assertEquals((String)"pipeline must not fire if unassigned", (int)0, (int)this.pipelineReport.getEventCount());
    }

    public void testSetSorterDiffComponentAdapter() {
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.assign(this.directModelAdapter);
        ShuttleSorter sorter = new ShuttleSorter();
        sorter.assign(new DirectModelAdapter(new DefaultTableModel(10, 5)));
        try {
            pipeline.setSorter(sorter);
            FilterTest.fail((String)"interposing with a different adapter must throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            FilterTest.fail((String)("interposing with a different adapter must throw an IllegalStatetException instead of " + e));
        }
    }

    public void testInterposeDiffComponentAdapter() {
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.assign(this.directModelAdapter);
        ShuttleSorter sorter = new ShuttleSorter();
        sorter.assign(new DirectModelAdapter(new DefaultTableModel(10, 5)));
        try {
            sorter.interpose(pipeline, new DirectModelAdapter(new DefaultTableModel(10, 5)), null);
            FilterTest.fail((String)"interposing with a different adapter must throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            FilterTest.fail((String)("interposing with a different adapter must throw an IllegalStateException instead of " + e));
        }
    }

    public void testEmptyPipeline() {
        int sortColumn = 0;
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.assign(this.directModelAdapter);
        FilterTest.assertEquals((String)"size must be number of rows in adapter", (int)this.directModelAdapter.getRowCount(), (int)pipeline.getOutputSize());
        Object value = pipeline.getValueAt(0, sortColumn);
        FilterTest.assertEquals((Object)this.directModelAdapter.getValueAt(0, sortColumn), (Object)value);
    }

    public void testSorterInEmptyPipeline() {
        int sortColumn = 0;
        Filter[] sorters = new Filter[]{new ShuttleSorter()};
        FilterPipeline sortedPipeline = new FilterPipeline(sorters);
        sortedPipeline.assign(this.directModelAdapter);
        Object sortedValue = sortedPipeline.getValueAt(0, sortColumn);
        FilterPipeline pipeline = new FilterPipeline();
        pipeline.assign(this.directModelAdapter);
        ShuttleSorter sorter = new ShuttleSorter();
        pipeline.setSorter(sorter);
        FilterTest.assertEquals((String)"sorted values must be equal", (Object)sortedValue, (Object)pipeline.getValueAt(0, sortColumn));
    }

    public void testSorterInterposeNullPipeline() {
        int sortColumn = 0;
        Filter[] sorters = new Filter[]{new ShuttleSorter()};
        FilterPipeline sortedPipeline = new FilterPipeline(sorters);
        sortedPipeline.assign(this.directModelAdapter);
        Object sortedValue = sortedPipeline.getValueAt(0, sortColumn);
        ShuttleSorter sorter = new ShuttleSorter();
        sorter.interpose(null, this.directModelAdapter, null);
        FilterTest.assertEquals((Object)sortedValue, (Object)sorter.getValueAt(0, sortColumn));
    }

    public void testSorterInPipeline() {
        Filter filter = this.createDefaultPatternFilter(0);
        FilterPipeline pipeline = new FilterPipeline(new Filter[]{filter});
        pipeline.assign(this.directModelAdapter);
        ShuttleSorter sorter = new ShuttleSorter();
        pipeline.setSorter(sorter);
        FilterTest.assertEquals((String)"value access via sorter must return the same as via pipeline", (Object)pipeline.getValueAt(0, 0), (Object)sorter.getValueAt(0, 0));
    }

    public void testInterpose() {
        int sortColumn = 0;
        PatternFilter filter = new PatternFilter("s", 0, sortColumn);
        Filter[] filters = new Filter[]{filter, new ShuttleSorter()};
        FilterPipeline pipeline = new FilterPipeline(filters);
        pipeline.assign(this.directModelAdapter);
        Object value = pipeline.getValueAt(0, sortColumn);
        Object lastValue = pipeline.getValueAt(pipeline.getOutputSize() - 1, sortColumn);
        ShuttleSorter sorter = new ShuttleSorter();
        sorter.interpose(pipeline, this.directModelAdapter, null);
        FilterTest.assertEquals((String)"value must be unchanged by interactive sorter", (Object)value, (Object)sorter.getValueAt(0, sortColumn));
        sorter.setAscending(false);
        FilterTest.assertEquals((String)"first value must be old last", (Object)lastValue, (Object)sorter.getValueAt(0, sortColumn));
        PatternFilter other = new PatternFilter();
        Filter[] otherFilters = new Filter[]{other};
        FilterPipeline otherPipeline = new FilterPipeline(otherFilters);
        otherPipeline.assign(this.directModelAdapter);
        sorter.interpose(otherPipeline, this.directModelAdapter, null);
    }

    public void testUnassignedFilter() {
        Filter filter = this.createDefaultPatternFilter(0);
        FilterTest.assertEquals((int)0, (int)filter.getSize());
        Filter[] filters = new Filter[]{filter};
        FilterPipeline pipeline = new FilterPipeline(filters);
        FilterTest.assertEquals((int)0, (int)pipeline.getOutputSize());
    }

    public void testUnassignedEmptyFilter() {
        FilterPipeline filters = new FilterPipeline();
        FilterTest.assertEquals((int)0, (int)filters.getOutputSize());
    }

    public void testDirectComponentAdapterAccess() {
        FilterPipeline pipeline = this.createPipeline();
        pipeline.assign(this.directModelAdapter);
        FilterTest.assertTrue((String)"pipeline must have filtered values", (pipeline.getOutputSize() < this.directModelAdapter.getRowCount() ? 1 : 0) != 0);
    }

    public void testFilterOrder() {
        Filter filterZero = this.createDefaultPatternFilter(0);
        Filter filterTwo = this.createDefaultPatternFilter(2);
        ShuttleSorter sorter = new ShuttleSorter();
        FilterTest.assertEquals((String)"order < 0", (int)-1, (int)sorter.order);
        Filter[] filters = new Filter[]{filterZero, filterTwo, sorter};
        new FilterPipeline(filters);
        this.assertOrder(filterZero, filters);
    }

    public void testDuplicatedSortColumnException() {
        Filter[] filters = new Filter[]{new ShuttleSorter(), new ShuttleSorter()};
        try {
            new FilterPipeline(filters);
            FilterTest.fail((String)"trying to sort one column more than once must throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            FilterTest.fail((String)("trying to sort one column more than once must throw IllegalArgumentExceptioninstead of " + e));
        }
    }

    public void testAssignFilterPipelineBoundFilterException() {
        Filter filter = this.createDefaultPatternFilter(0);
        FilterTest.assertEquals((String)"order < 0", (int)-1, (int)filter.order);
        Filter[] filters = new Filter[]{filter};
        new FilterPipeline(filters);
        try {
            new FilterPipeline(filters);
            FilterTest.fail((String)"sharing filters are not allowed - must throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            FilterTest.fail((String)("exception must be illegalArgument instead of " + e));
        }
    }

    public void testAssignFilterPipeline() {
        Filter filter = this.createDefaultPatternFilter(0);
        Filter[] filters = new Filter[]{filter};
        FilterPipeline pipeline = new FilterPipeline(filters);
        FilterTest.assertEquals((String)"assigned to pipeline", (Object)pipeline, (Object)filter.getPipeline());
        JXTable table = new JXTable(this.tableModel);
        table.setFilters(pipeline);
        FilterTest.assertEquals((String)"assigned to table's componentadapter", (Object)table, (Object)filter.adapter.getComponent());
    }

    private void assertOrder(Filter filter, Filter[] filters) {
        int position = this.getFilterPosition(filter, filters);
        FilterTest.assertEquals((String)"order equals position in array", (int)position, (int)filter.order);
    }

    protected void assertOrders(Filter[] filters) {
        int i = 0;
        while (i < filters.length) {
            FilterTest.assertEquals((String)"order must be equal to filter position", (int)i, (int)filters[i].order);
            ++i;
        }
    }

    private int getFilterPosition(Filter filter, Filter[] filters) {
        int i = 0;
        while (i < filters.length) {
            if (filters[i].equals(filter)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected FilterPipeline createPipeline() {
        Filter filterZero = this.createDefaultPatternFilter(0);
        Filter filterTwo = this.createDefaultPatternFilter(2);
        ShuttleSorter sorter = new ShuttleSorter();
        Filter[] filters = new Filter[]{filterZero, filterTwo, sorter};
        FilterPipeline pipeline = new FilterPipeline(filters);
        return pipeline;
    }

    protected Filter createDefaultPatternFilter(int column) {
        PatternFilter filterZero = new PatternFilter("e", 0, column);
        return filterZero;
    }

    public void testJavaDocExample() {
        Filter[] filters = new Filter[]{new PatternFilter("^S", 0, 1), new ShuttleSorter(1, false), new ShuttleSorter(0, true)};
        FilterPipeline pipeline = new FilterPipeline(filters);
        JXTable table = new JXTable();
        table.setFilters(pipeline);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tableModel = new AncientSwingTeam();
        this.directModelAdapter = new DirectModelAdapter(this.tableModel);
        this.pipelineReport = new PipelineReport();
    }

    public void interactiveTestColumnControlAndFilters() {
        final JXTable table = new JXTable(this.tableModel);
        table.setColumnControlVisible(true);
        AbstractAction toggleFilter = new AbstractAction("Toggle Filters"){
            boolean hasFilters;

            public void actionPerformed(ActionEvent e) {
                if (this.hasFilters) {
                    table.setFilters(null);
                } else {
                    table.setFilters(FilterTest.this.createPipeline());
                }
                this.hasFilters = !this.hasFilters;
            }
        };
        toggleFilter.putValue("ShortDescription", "filtering first column - problem if invisible ");
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable ColumnControl and Filters");
        this.addAction(frame, toggleFilter);
        frame.setVisible(true);
    }

    public void interactiveTestAndFilter() {
        final JXTable table = new JXTable(this.tableModel);
        table.setColumnControlVisible(true);
        AbstractAction toggleFilter = new AbstractAction("Toggle Filters"){
            boolean hasFilters;

            public void actionPerformed(ActionEvent e) {
                if (this.hasFilters) {
                    table.setFilters(null);
                } else {
                    PatternFilter first = new PatternFilter("a", 0, 0);
                    PatternFilter second = new PatternFilter("b", 0, 1);
                    FilterPipeline pipeline = new FilterPipeline(new Filter[]{first, second});
                    table.setFilters(pipeline);
                }
                this.hasFilters = !this.hasFilters;
            }
        };
        toggleFilter.putValue("ShortDescription", "Filtered rows: col(0) contains 'a' AND col(1) contains 'b'");
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable ColumnControl and Filters");
        this.addAction(frame, toggleFilter);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        FilterTest.setSystemLF(true);
        FilterTest test = new FilterTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }

    public static class DirectModelAdapter
    extends ComponentAdapter {
        private TableModel tableModel;

        public DirectModelAdapter(TableModel tableModel) {
            super(null);
            this.tableModel = tableModel;
        }

        public int getColumnCount() {
            return this.tableModel.getColumnCount();
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        public String getColumnName(int columnIndex) {
            return this.tableModel.getColumnName(columnIndex);
        }

        public String getColumnIdentifier(int columnIndex) {
            return this.getColumnName(columnIndex);
        }

        public Object getValueAt(int row, int column) {
            return this.tableModel.getValueAt(row, column);
        }

        public Object getFilteredValueAt(int row, int column) {
            return null;
        }

        public void setValueAt(Object aValue, int row, int column) {
            this.tableModel.setValueAt(aValue, row, column);
        }

        public boolean isCellEditable(int row, int column) {
            return this.tableModel.isCellEditable(row, column);
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isSelected() {
            return false;
        }

        public void refresh() {
        }
    }
}

