/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.Sorter;

public class FilterPipeline {
    protected EventListenerList listenerList = new EventListenerList();
    private ComponentAdapter adapter = null;
    private Sorter sorter = null;
    private final Filter[] filters;
    static /* synthetic */ Class class$0;

    public FilterPipeline() {
        this(new Filter[0]);
    }

    public FilterPipeline(Filter[] inList) {
        this.filters = this.reorderSorters(inList, this.locateSorters(inList));
        this.assignFilters();
    }

    private void assignFilters() {
        int i = 0;
        while (i < this.filters.length) {
            this.filters[i].assign(this, i);
            ++i;
        }
    }

    public void setSorter(Sorter sorter) {
        Sorter oldSorter = this.getSorter();
        if (oldSorter == sorter) {
            return;
        }
        if (oldSorter != null) {
            oldSorter.assign((FilterPipeline)null);
        }
        this.sorter = sorter;
        if (sorter != null) {
            sorter.assign((FilterPipeline)null);
            sorter.assign(this);
            if (this.adapter != null) {
                sorter.assign(this.adapter);
                sorter.refresh();
            }
        }
        if (sorter == null && this.isAssigned()) {
            this.fireContentsChanged();
        }
    }

    public Sorter getSorter() {
        return this.sorter;
    }

    public final void assign(ComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("null adapter");
        }
        if (this.adapter == null) {
            this.adapter = adapter;
            int i = 0;
            while (i < this.filters.length) {
                this.filters[i].assign(adapter);
                ++i;
            }
            if (this.sorter != null) {
                this.sorter.assign(adapter);
            }
            this.flush();
        } else if (this.adapter != adapter) {
            throw new IllegalStateException("Can't bind to a different adapter");
        }
    }

    public boolean isAssigned() {
        return this.adapter != null;
    }

    boolean contains(Filter filter) {
        return filter.equals(this.sorter) || filter.order >= 0 && this.filters.length > 0 && this.filters[filter.order] == filter;
    }

    Filter first() {
        return this.filters.length > 0 ? this.filters[0] : null;
    }

    Filter last() {
        if (this.sorter != null) {
            return this.sorter;
        }
        return this.filters.length > 0 ? this.filters[this.filters.length - 1] : null;
    }

    Filter next(Filter filter) {
        if (this.last().equals(filter)) {
            return null;
        }
        return filter.order + 1 < this.filters.length ? this.filters[filter.order + 1] : this.getSorter();
    }

    Filter previous(Filter filter) {
        if (filter.equals(this.sorter)) {
            return this.filters.length > 0 ? this.filters[this.filters.length - 1] : null;
        }
        return this.first().equals(filter) ? null : this.filters[filter.order - 1];
    }

    protected void filterChanged(Filter filter) {
        Filter next = this.next(filter);
        if (next == null) {
            this.fireContentsChanged();
        } else {
            next.refresh();
        }
    }

    public int getInputSize() {
        return this.isAssigned() ? this.adapter.getRowCount() : 0;
    }

    int getInputSize(Filter filter) {
        Filter previous = this.previous(filter);
        if (previous != null) {
            return previous.getSize();
        }
        return this.getInputSize();
    }

    public int getOutputSize() {
        if (!this.isAssigned()) {
            return 0;
        }
        Filter last = this.last();
        return last == null ? this.adapter.getRowCount() : last.getSize();
    }

    public int convertRowIndexToModel(int row) {
        Filter last = this.last();
        return last == null ? row : last.convertRowIndexToModel(row);
    }

    public int convertRowIndexToView(int row) {
        Filter last = this.last();
        return last == null ? row : last.convertRowIndexToView(row);
    }

    public Object getValueAt(int row, int column) {
        Filter last = this.last();
        return last == null ? null : last.getValueAt(row, column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        Filter last = this.last();
        if (last != null) {
            last.setValueAt(aValue, row, column);
        }
    }

    public boolean isCellEditable(int row, int column) {
        Filter last = this.last();
        return last == null ? false : last.isCellEditable(row, column);
    }

    public void flush() {
        if (this.filters != null && this.filters.length > 0) {
            this.filters[0].refresh();
        } else if (this.sorter != null) {
            this.sorter.refresh();
        }
    }

    public void addPipelineListener(PipelineListener l) {
        this.listenerList.add(PipelineListener.class, l);
    }

    public void removePipelineListener(PipelineListener l) {
        this.listenerList.remove(PipelineListener.class, l);
    }

    public PipelineListener[] getPipelineListeners() {
        return (PipelineListener[])this.listenerList.getListeners(PipelineListener.class);
    }

    protected void fireContentsChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        PipelineEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == PipelineListener.class) {
                if (e == null) {
                    e = new PipelineEvent(this, 0);
                }
                ((PipelineListener)listeners[i + 1]).contentsChanged(e);
            }
            i -= 2;
        }
    }

    private List locateSorters(Filter[] inList) {
        BitSet sortableColumns = new BitSet();
        Vector<Integer> sorterLocations = new Vector<Integer>();
        int i = 0;
        while (i < inList.length) {
            if (inList[i] instanceof Sorter) {
                int columnIndex = inList[i].getColumnIndex();
                if (columnIndex < 0) {
                    throw new IndexOutOfBoundsException("Negative column index for filter: " + inList[i]);
                }
                if (sortableColumns.get(columnIndex)) {
                    throw new IllegalArgumentException("Filter " + i + " attempting to overwrite sorter for column " + columnIndex);
                }
                sortableColumns.set(columnIndex);
                sorterLocations.add(new Integer(i));
            }
            ++i;
        }
        return sorterLocations;
    }

    private Filter[] reorderSorters(Filter[] inList, List sorterLocations) {
        if (inList.length == 0) {
            return new Filter[]{new IdentityFilter()};
        }
        Filter[] outList = (Filter[])inList.clone();
        int max = sorterLocations.size() - 1;
        int i = 0;
        while (i <= max) {
            int orig = (Integer)sorterLocations.get(max - i);
            int copy = (Integer)sorterLocations.get(i);
            outList[copy] = inList[orig];
            ++i;
        }
        return outList;
    }

    public class IdentityFilter
    extends Filter {
        protected void init() {
        }

        protected void reset() {
        }

        protected void filter() {
        }

        public int getSize() {
            return this.getInputSize();
        }

        protected int mapTowardModel(int row) {
            return row;
        }

        protected int mapTowardView(int row) {
            return row;
        }
    }
}

