/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.FilterTest;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.ShuttleSorter;

public class FilterIssues
extends FilterTest {
    public void testSorterOrder() {
        ShuttleSorter sorter = new ShuttleSorter();
        FilterIssues.assertEquals((String)"order < 0", (int)-1, (int)sorter.order);
        Filter[] filters = new Filter[]{sorter, new ShuttleSorter(2, true)};
        new FilterPipeline(filters);
        this.assertOrders(filters);
    }

    public void testConvertRowIndicesInLastAndPipeline() {
        Filter filterZero = this.createDefaultPatternFilter(0);
        Filter filterTwo = this.createDefaultPatternFilter(2);
        ShuttleSorter sorter = new ShuttleSorter(2, true);
        Filter[] filters = new Filter[]{filterZero, filterTwo, sorter};
        FilterPipeline pipeline = new FilterPipeline(filters);
        pipeline.assign(this.directModelAdapter);
    }

    public void testConvertRowIndicesToModel() {
        FilterPipeline pipeline = this.createPipeline();
        Filter intermediateSorter = pipeline.last();
        intermediateSorter.setColumnIndex(2);
        pipeline.assign(this.directModelAdapter);
        int lastViewRow = pipeline.getOutputSize() - 1;
        Object firstValue = pipeline.getValueAt(0, 0);
        Object lastValue = pipeline.getValueAt(lastViewRow, 0);
        int modelRow = pipeline.convertRowIndexToModel(lastViewRow);
        Filter intermediateFilter1 = pipeline.previous(intermediateSorter);
        Filter intermediateFilter2 = pipeline.previous(intermediateFilter1);
        FilterIssues.assertEquals((int)modelRow, (int)intermediateSorter.convertRowIndexToModel(lastViewRow));
        FilterIssues.assertEquals((int)modelRow, (int)intermediateFilter1.convertRowIndexToModel(lastViewRow));
        FilterIssues.assertEquals((int)modelRow, (int)intermediateFilter2.convertRowIndexToModel(lastViewRow));
    }

    public void testConvertRowIndicesToView() {
        FilterPipeline pipeline = this.createPipeline();
        Filter intermediateSorter = pipeline.last();
        intermediateSorter.setColumnIndex(2);
        pipeline.assign(this.directModelAdapter);
        int lastViewRow = pipeline.getOutputSize() - 1;
        Object firstValue = pipeline.getValueAt(0, 0);
        Object lastValue = pipeline.getValueAt(lastViewRow, 0);
        int modelRow = pipeline.convertRowIndexToModel(lastViewRow);
        Filter intermediateFilter1 = pipeline.previous(intermediateSorter);
        Filter intermediateFilter2 = pipeline.previous(intermediateFilter1);
        FilterIssues.assertEquals((int)lastViewRow, (int)pipeline.convertRowIndexToView(modelRow));
        FilterIssues.assertEquals((int)lastViewRow, (int)intermediateSorter.convertRowIndexToView(modelRow));
        FilterIssues.assertEquals((int)lastViewRow, (int)intermediateFilter1.convertRowIndexToView(modelRow));
        FilterIssues.assertEquals((int)lastViewRow, (int)intermediateFilter2.convertRowIndexToView(modelRow));
    }

    public void testGetValue() {
        FilterPipeline pipeline = this.createPipeline();
        pipeline.assign(this.directModelAdapter);
        int size = pipeline.getOutputSize();
        Object firstValue = pipeline.getValueAt(0, 0);
        Object lastValue = pipeline.getValueAt(size - 1, 0);
        ShuttleSorter sorter = new ShuttleSorter();
        pipeline.setSorter(sorter);
        FilterIssues.assertEquals((int)size, (int)pipeline.getOutputSize());
        FilterIssues.assertEquals((Object)firstValue, (Object)pipeline.getValueAt(0, 0));
        FilterIssues.assertEquals((Object)firstValue, (Object)sorter.getValueAt(0, 0));
        FilterIssues.assertEquals((Object)lastValue, (Object)sorter.getValueAt(size - 1, 0));
        sorter.setAscending(false);
        FilterIssues.assertEquals((Object)lastValue, (Object)sorter.getValueAt(0, 0));
        FilterIssues.assertEquals((Object)firstValue, (Object)sorter.getValueAt(size - 1, 0));
        Filter intermediateSorter = pipeline.previous(sorter);
        Filter intermediateFilter1 = pipeline.previous(intermediateSorter);
        Filter intermediateFilter2 = pipeline.previous(intermediateFilter1);
        FilterIssues.assertTrue((boolean)(intermediateFilter2 instanceof PatternFilter));
        FilterIssues.assertEquals((Object)lastValue, (Object)intermediateFilter2.getValueAt(0, 0));
        FilterIssues.assertEquals((Object)firstValue, (Object)intermediateFilter2.getValueAt(size - 1, 0));
    }

    public void testInterposeWithOldSorter() {
    }
}

