/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.autocomplete.AbstractComponentAdaptor;

public class Document
extends PlainDocument {
    boolean selecting = false;
    boolean strictMatching;
    AbstractComponentAdaptor adaptor;

    public Document(AbstractComponentAdaptor adaptor, boolean strictMatching) {
        this.adaptor = adaptor;
        this.strictMatching = strictMatching;
        Object selected = adaptor.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        adaptor.markEntireText();
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(offs, len);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(offs);
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(offs, str, a);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        if (item != null) {
            this.setSelectedItem(item);
        } else if (this.strictMatching) {
            item = this.adaptor.getSelectedItem();
            offs -= str.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
        } else {
            item = this.getText(0, this.getLength());
            this.setSelectedItem(item);
        }
        this.setText(item == null ? "" : item.toString());
        this.adaptor.markText(offs + str.length());
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void setSelectedItem(Object item) {
        this.selecting = true;
        this.adaptor.setSelectedItem(item);
        this.selecting = false;
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.adaptor.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
            return selectedItem;
        }
        int i = 0;
        int n = this.adaptor.getItemCount();
        while (i < n) {
            Object currentItem = this.adaptor.getItem(i);
            if (currentItem != null && this.startsWithIgnoreCase(currentItem.toString(), pattern)) {
                return currentItem;
            }
            ++i;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string1, String string2) {
        return string1.toUpperCase().startsWith(string2.toUpperCase());
    }
}

