/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.awt.EventQueue;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginListener;
import org.jdesktop.swingx.util.SwingWorker;

public abstract class LoginService {
    private Logger LOG = Logger.getLogger(LoginService.class.getName());
    private Vector<LoginListener> listenerList = new Vector();
    private SwingWorker loginWorker;
    private boolean synchronous;
    private String server;
    static /* synthetic */ Class class$0;

    public LoginService() {
    }

    public LoginService(String server) {
        this.setServer(server);
    }

    public abstract boolean authenticate(String var1, char[] var2, String var3) throws Exception;

    public String[] getUserRoles() {
        return null;
    }

    public void cancelAuthentication() {
        if (this.loginWorker != null) {
            this.loginWorker.cancel(true);
        }
    }

    public void startAuthentication(final String user, final char[] password, final String server) throws Exception {
        block5: {
            if (this.getSynchronous()) {
                try {
                    if (this.authenticate(user, password, server)) {
                        this.fireLoginSucceeded(new LoginEvent(this));
                        break block5;
                    }
                    this.fireLoginFailed(new LoginEvent(this));
                }
                catch (Exception e) {
                    this.fireLoginFailed(new LoginEvent(this, e));
                }
            } else {
                this.loginWorker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        try {
                            boolean result = LoginService.this.authenticate(user, password, server);
                            if (this.isCancelled()) {
                                EventQueue.invokeLater(new Runnable(this){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        1.access$0(this.this$1).fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                                return false;
                            }
                            EventQueue.invokeLater(new Runnable(this, result){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ boolean val$result;
                                {
                                    this.this$1 = var1_1;
                                    this.val$result = bl;
                                }

                                public void run() {
                                    if (this.val$result) {
                                        1.access$0(this.this$1).fireLoginSucceeded(new LoginEvent(1.access$0(this.this$1)));
                                    } else {
                                        1.access$0(this.this$1).fireLoginFailed(new LoginEvent(1.access$0(this.this$1)));
                                    }
                                }
                            });
                            return result;
                        }
                        catch (Exception failed) {
                            if (!this.isCancelled()) {
                                SwingUtilities.invokeLater(new Runnable(this, failed){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ Exception val$failed;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$failed = exception;
                                    }

                                    public void run() {
                                        1.access$0(this.this$1).fireLoginFailed(new LoginEvent(1.access$0(this.this$1), this.val$failed));
                                    }
                                });
                            } else {
                                EventQueue.invokeLater(new Runnable(this){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        1.access$0(this.this$1).fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                            }
                            return false;
                        }
                    }

                    static /* synthetic */ LoginService access$0(1 var0) {
                        return var0.LoginService.this;
                    }
                };
                this.loginWorker.execute();
                this.fireLoginStarted(new LoginEvent(this));
            }
        }
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void addLoginListener(LoginListener listener) {
        this.listenerList.add(listener);
    }

    public void removeLoginListener(LoginListener listener) {
        this.listenerList.remove(listener);
    }

    void fireLoginStarted(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginStarted(source);
        }
    }

    void fireLoginSucceeded(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginSucceeded(source);
        }
    }

    void fireLoginFailed(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginFailed(source);
        }
    }

    void fireLoginCanceled(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginCanceled(source);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

