/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import junit.framework.TestCase;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.action.ActionFactory;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.TargetManager;
import org.jdesktop.swingx.action.Targetable;
import org.jdesktop.swingx.action.TargetableAction;

public class TargetableActionTest
extends TestCase {
    public static int tableNum = 0;

    public void testDummy() {
    }

    public static void main(String[] args) {
        TargetableActionTest.showActionMaps();
        TargetableActionTest.showUI();
    }

    public static TargetableAction createTargetableAction(String id, String name) {
        return TargetableActionTest.createTargetableAction(id, name, null);
    }

    public static TargetableAction createTargetableAction(String id, String name, String mnemonic) {
        return TargetableActionTest.createTargetableAction(id, name, mnemonic, false);
    }

    public static TargetableAction createTargetableAction(String id, String name, String mnemonic, boolean toggle) {
        return ActionFactory.createTargetableAction(id, name, mnemonic, toggle, null);
    }

    public static TargetableAction createTargetableAction(String id, String name, String mnemonic, boolean toggle, String group) {
        return ActionFactory.createTargetableAction(id, name, mnemonic, toggle, group);
    }

    public static void showUI() {
        ActionManager manager = new ActionManager();
        ActionManager.setInstance(manager);
        manager.addAction(TargetableActionTest.createTargetableAction("cut-to-clipboard", "Cut", "C"));
        manager.addAction(TargetableActionTest.createTargetableAction("copy-to-clipboard", "Copy", "P"));
        manager.addAction(TargetableActionTest.createTargetableAction("paste-from-clipboard", "Paste", "T"));
        manager.addAction(TargetableActionTest.createTargetableAction("print", "Print", "P"));
        manager.addAction(TargetableActionTest.createTargetableAction("find", "Find", "F"));
        manager.addAction(TargetableActionTest.createTargetableAction("collapse-all", "Collapse", "l"));
        manager.addAction(TargetableActionTest.createTargetableAction("expand-all", "Expand", "x"));
        manager.addAction(TargetableActionTest.createTargetableAction("left-justify", "Left", "L", true, "position-group"));
        manager.addAction(TargetableActionTest.createTargetableAction("center-justify", "Center", "C", true, "position-group"));
        manager.addAction(TargetableActionTest.createTargetableAction("right-justify", "Right", "R", true, "position-group"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("cut-to-clipboard");
        list.add("copy-to-clipboard");
        list.add("paste-from-clipboard");
        list.add(null);
        list.add("left-justify");
        list.add("center-justify");
        list.add("right-justify");
        list.add(null);
        list.add("print");
        list.add("find");
        list.add("collapse-all");
        list.add("expand-all");
        ActionContainerFactory factory = manager.getFactory();
        JToolBar toolbar = factory.createToolBar(list);
        JPanel panel = new JPanel(new GridLayout(2, 2, 5, 5));
        JXEditorPane editor = new JXEditorPane("text/html", "This is an example of some text");
        panel.add(editor);
        panel.add(new JXEditorPane());
        panel.add(TargetableActionTest.createTabbedPane());
        panel.add(TargetableActionTest.createTree());
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)toolbar, "North");
        frame.getContentPane().add(panel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public static JComponent createTabbedPane() {
        JTabbedPane pane = new JTabbedPane();
        pane.add(TargetableActionTest.createTable());
        pane.add(TargetableActionTest.createTable());
        pane.add(TargetableActionTest.createTable());
        pane.add(TargetableActionTest.createTable());
        pane.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                Component comp = pane.getSelectedComponent();
                if (comp instanceof Targetable) {
                    TargetManager.getInstance().setTarget((Targetable)((Object)comp));
                }
            }

            public void focusLost(FocusEvent evt) {
                if (!evt.isTemporary()) {
                    TargetManager.getInstance().setTarget(null);
                }
            }
        });
        pane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                Component comp = pane.getSelectedComponent();
                if (comp instanceof Targetable) {
                    TargetManager.getInstance().setTarget((Targetable)((Object)comp));
                }
            }
        });
        return pane;
    }

    public static JComponent createTable() {
        AbstractTableModel dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                return 4;
            }

            public Object getValueAt(int row, int col) {
                return new Integer(row * col);
            }

            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        JXTable table = new JXTable(dataModel);
        table.setName("Table: " + tableNum++);
        return table;
    }

    public static JComponent createTree() {
        JTree jtree = new JTree();
        JXTree tree = new JXTree(jtree.getModel());
        tree.setEditable(true);
        ActionMap map = tree.getActionMap();
        MyAction action = new MyAction("print", "Print on JTree");
        map.put(action.getValue("Name"), action);
        action = new MyAction("find", "Find on JTree");
        map.put(action.getValue("Name"), action);
        return tree;
    }

    public static void showActionMaps() {
        System.out.println("\nActionMap keys for JXTable\n===================");
        TargetableActionTest.showActionMap(new JXTable());
        System.out.println("\nActionMap keys for JXEditorPane\n==================");
        TargetableActionTest.showActionMap(new JXEditorPane());
        System.out.println("\nActionMap keys for an HTML JXEditorPane\n==================");
        TargetableActionTest.showActionMap(new JXEditorPane("text/html", ""));
        System.out.println("\nActionMap keys for JXTree\n====================");
        TargetableActionTest.showActionMap(new JXTree());
        System.out.println("\nActionMap keys for JXTreeTable\n====================");
        TargetableActionTest.showActionMap(new JXTreeTable());
    }

    public static void showActionMap(JComponent comp) {
        ActionMap map = comp.getActionMap();
        Object[] keys = map.allKeys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                System.out.println(keys[i]);
                ++i;
            }
        }
    }

    public static class MyAction
    extends AbstractAction {
        private String description;

        public MyAction(String name, String desc) {
            super(name);
            this.description = desc;
        }

        public void actionPerformed(ActionEvent evt) {
            System.out.println(this.getValue("Name") + " has been invoked: " + this.description);
        }
    }
}

