/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import junit.framework.TestCase;
import org.jdesktop.swingx.action.TargetManager;
import org.jdesktop.swingx.action.Targetable;

public class TargetManagerTest
extends TestCase {
    protected void tearDown() {
        TargetManager manager = TargetManager.getInstance();
        manager.reset();
    }

    public void testGetTargets() {
        TargetManager manager = TargetManager.getInstance();
        TargetManagerTest.assertNull((Object)manager.getTarget());
        Targetable[] targets = manager.getTargets();
        TargetManagerTest.assertNotNull((Object)targets);
        TargetManagerTest.assertTrue((targets.length == 0 ? 1 : 0) != 0);
    }

    public void testAddRemoveTargets() {
        FooTarget foo = new FooTarget();
        BarTarget bar = new BarTarget();
        TargetManager manager = TargetManager.getInstance();
        manager.addTarget(foo);
        manager.addTarget(bar);
        Targetable[] targets = manager.getTargets();
        TargetManagerTest.assertNotNull((Object)targets);
        TargetManagerTest.assertTrue((targets.length == 2 ? 1 : 0) != 0);
        TargetManagerTest.assertTrue((targets[0] == foo ? 1 : 0) != 0);
        TargetManagerTest.assertTrue((targets[1] == bar ? 1 : 0) != 0);
        manager.removeTarget(foo);
        manager.removeTarget(bar);
        targets = manager.getTargets();
        TargetManagerTest.assertNotNull((Object)targets);
        TargetManagerTest.assertTrue((targets.length == 0 ? 1 : 0) != 0);
        manager.addTarget(foo);
        manager.addTarget(bar, true);
        targets = manager.getTargets();
        TargetManagerTest.assertNotNull((Object)targets);
        TargetManagerTest.assertTrue((targets.length == 2 ? 1 : 0) != 0);
        TargetManagerTest.assertTrue((targets[0] == bar ? 1 : 0) != 0);
        TargetManagerTest.assertTrue((targets[1] == foo ? 1 : 0) != 0);
    }

    public void testDoCommand() {
        FooTarget foo = new FooTarget();
        BarTarget bar = new BarTarget();
        TargetManager manager = TargetManager.getInstance();
        manager.setTarget(foo);
        TargetManagerTest.assertTrue((boolean)manager.doCommand("foo", null));
        TargetManagerTest.assertFalse((boolean)manager.doCommand("bar", null));
        manager.setTarget(bar);
        TargetManagerTest.assertTrue((boolean)manager.doCommand("bar", null));
        TargetManagerTest.assertFalse((boolean)manager.doCommand("foo", null));
        manager.setTarget(null);
        manager.addTarget(foo);
        manager.addTarget(bar);
        TargetManagerTest.assertTrue((boolean)manager.doCommand("bar", null));
        TargetManagerTest.assertTrue((boolean)manager.doCommand("foo", null));
    }

    private class FooTarget
    implements Targetable {
        public String FOO_ACTION = "foo";

        FooTarget() {
        }

        public boolean doCommand(Object command, Object value) {
            return this.hasCommand(command);
        }

        public boolean hasCommand(Object command) {
            return command.equals(this.FOO_ACTION);
        }

        public Object[] getCommands() {
            return new Object[]{this.FOO_ACTION};
        }
    }

    private class BarTarget
    implements Targetable {
        public String BAR_ACTION = "bar";

        BarTarget() {
        }

        public boolean doCommand(Object command, Object value) {
            return this.hasCommand(command);
        }

        public boolean hasCommand(Object command) {
            return command.equals(this.BAR_ACTION);
        }

        public Object[] getCommands() {
            return new Object[]{this.BAR_ACTION};
        }
    }
}

