/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.Statement;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import junit.framework.TestCase;
import org.jdesktop.swingx.action.ActionFactory;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.action.CompositeAction;
import org.jdesktop.swingx.action.ServerAction;

public class ActionManagerTest
extends TestCase {
    private ActionManager manager;

    protected void setUp() {
        this.manager = ActionManager.getInstance();
        this.manager.addAction(this.createBoundAction("simple-command", "Simple", "S"));
        this.manager.addAction(this.createBoundAction("simple2-command", "Simple 2", "2"));
        this.manager.addAction(this.createBoundAction("simple3-command", "Simple 3", "3"));
        this.manager.addAction(this.createBoundAction("toggle-command", "Toggle", "T", true));
        this.manager.addAction(this.createBoundAction("left-command", "Left", "L", true, "position-group"));
        this.manager.addAction(this.createBoundAction("center-command", "Center", "C", true, "position-group"));
        this.manager.addAction(this.createBoundAction("right-command", "Right", "R", true, "position-group"));
        CompositeAction action = ActionFactory.createCompositeAction("composite-command", "Composite", "C");
        action.addAction("simple-command");
        action.addAction("simple2-command");
        this.manager.addAction(action);
        ServerAction saction = ActionFactory.createServerAction("namefinder-command", "NameFinder", "N");
        saction.setURL("http://namefinder.sfbay/NameFinder");
        saction.addParam("nfquery", "Mark Davidson");
        this.manager.addAction(saction);
        saction = ActionFactory.createServerAction("server-command", "Google", "G");
        saction.setURL("http://www.google.com/search");
        saction.addParam("q", "Zaphod+Beeblebrox");
        this.manager.addAction(saction);
    }

    public BoundAction createBoundAction(String id, String name, String mnemonic) {
        return this.createBoundAction(id, name, mnemonic, false);
    }

    public BoundAction createBoundAction(String id, String name, String mnemonic, boolean toggle) {
        return this.createBoundAction(id, name, mnemonic, toggle, null);
    }

    public BoundAction createBoundAction(String id, String name, String mnemonic, boolean toggle, String group) {
        return ActionFactory.createBoundAction(id, name, mnemonic, toggle, group);
    }

    public void testActionTypes() {
        ActionManagerTest.assertTrue((boolean)this.manager.isBoundAction("simple-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isBoundAction("simple2-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isBoundAction("simple3-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isBoundAction("toggle-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isBoundAction("left-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isBoundAction("right-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isBoundAction("center-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isCompositeAction("composite-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isServerAction("namefinder-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isServerAction("server-command"));
        ActionManagerTest.assertTrue((!this.manager.isStateAction("simple-command") ? 1 : 0) != 0);
        ActionManagerTest.assertTrue((!this.manager.isStateAction("simple2-command") ? 1 : 0) != 0);
        ActionManagerTest.assertTrue((!this.manager.isStateAction("simple3-command") ? 1 : 0) != 0);
        ActionManagerTest.assertTrue((boolean)this.manager.isStateAction("toggle-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isStateAction("left-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isStateAction("right-command"));
        ActionManagerTest.assertTrue((boolean)this.manager.isStateAction("center-command"));
        ActionManagerTest.assertTrue((!this.manager.isStateAction("composite-command") ? 1 : 0) != 0);
        ActionManagerTest.assertTrue((!this.manager.isStateAction("namefinder-command") ? 1 : 0) != 0);
        ActionManagerTest.assertTrue((!this.manager.isStateAction("server-command") ? 1 : 0) != 0);
    }

    public void testRegisterMethod() {
        Controller controller = new Controller();
        Iterator iter = this.manager.getActionIDs().iterator();
        while (iter.hasNext()) {
            this.manager.registerCallback(iter.next(), controller, "action");
        }
        JButton dummy = new JButton("Dummy");
        iter = this.manager.getActionIDs().iterator();
        while (iter.hasNext()) {
            controller.reset();
            Object id = iter.next();
            Action action = this.manager.getAction(id);
            if (!this.manager.isBoundAction(id)) continue;
            if (this.manager.isStateAction(id)) {
                ItemEvent evt = new ItemEvent(dummy, 666, "test", 1);
                Statement statement = new Statement(action, "itemStateChanged", new Object[]{evt});
                try {
                    statement.execute();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ActionManagerTest.assertTrue((boolean)controller.isInvoked());
                continue;
            }
            action.actionPerformed(new ActionEvent(action, 666, "test"));
            ActionManagerTest.assertTrue((String)("ERROR: " + this.manager.getBoundAction(id).toString()), (boolean)controller.isInvoked());
        }
    }

    public void testCompositeAction() {
        Controller controller = new Controller();
        this.manager.registerCallback("simple-command", controller, "doNew");
        this.manager.registerCallback("simple2-command", controller, "doSave");
        Action action = this.manager.getAction("composite-command");
        action.actionPerformed(new ActionEvent(action, 666, "test"));
        ActionManagerTest.assertTrue((String)"ERROR: Controller was not invoked", (boolean)controller.isInvoked());
        ActionManagerTest.assertTrue((String)"ERROR: Controller should have been invoked twice", (controller.getNumInvoked() == 2 ? 1 : 0) != 0);
    }

    public void testEnabled() {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        int i = 0;
        while (i < values.length) {
            Iterator iter = this.manager.getActionIDs().iterator();
            while (iter.hasNext()) {
                this.manager.setEnabled(iter.next(), values[i]);
            }
            iter = this.manager.getActionIDs().iterator();
            while (iter.hasNext()) {
                ActionManagerTest.assertTrue((this.manager.isEnabled(iter.next()) == values[i] ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testSelected() {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        int i = 0;
        while (i < values.length) {
            Iterator iter = this.manager.getActionIDs().iterator();
            while (iter.hasNext()) {
                this.manager.setSelected(iter.next(), values[i]);
            }
            for (Object a : this.manager.getActionIDs()) {
                if (this.manager.isStateAction(a)) {
                    ActionManagerTest.assertTrue((String)("Action: " + a + " selected state not " + values[i]), (this.manager.isSelected(a) == values[i] ? 1 : 0) != 0);
                    continue;
                }
                ActionManagerTest.assertFalse((boolean)this.manager.isSelected(a));
            }
            ++i;
        }
    }

    public class Controller {
        private boolean invoked = false;
        private int numInvoked = 0;

        public void action() {
            this.invoked = true;
            ++this.numInvoked;
        }

        public void doNew() {
            this.action();
        }

        public void doSave() {
            this.action();
        }

        public void action(boolean state) {
            this.action();
        }

        public void reset() {
            this.invoked = false;
            this.numInvoked = 0;
        }

        public int getNumInvoked() {
            return this.numInvoked;
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }
}

