/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.ToggleActionPropertyChangeListener;

public class ActionContainerFactory {
    private static Insets TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private ActionManager manager;
    private Map groupMap;

    public ActionContainerFactory(ActionManager manager) {
        this.setActionManager(manager);
    }

    public ActionManager getActionManager() {
        if (this.manager == null) {
            this.manager = ActionManager.getInstance();
        }
        return this.manager;
    }

    public void setActionManager(ActionManager manager) {
        ActionManager oldManager = this.manager;
        if (oldManager != null) {
            oldManager.setFactory(null);
        }
        this.manager = manager;
        if (manager != null) {
            manager.setFactory(this);
        }
    }

    private JToolBar createToolBar(Object[] list) {
        return this.createToolBar(Arrays.asList(list));
    }

    public JToolBar createToolBar(List list) {
        JToolBar toolbar = new JToolBar();
        for (Object element : list) {
            if (element == null) {
                toolbar.addSeparator();
                continue;
            }
            AbstractButton button = this.createButton(element, (JComponent)toolbar);
            button.setFocusable(false);
            button.setMargin(TOOLBAR_BUTTON_MARGIN);
            button.setBorderPainted(false);
            toolbar.add(button);
        }
        return toolbar;
    }

    private JPopupMenu createPopup(Object[] list) {
        return this.createPopup(Arrays.asList(list));
    }

    public JPopupMenu createPopup(List list) {
        JPopupMenu popup = new JPopupMenu();
        for (Object element : list) {
            if (element == null) {
                popup.addSeparator();
                continue;
            }
            if (element instanceof List) {
                JMenu newMenu = this.createMenu((List)element);
                if (newMenu == null) continue;
                popup.add(newMenu);
                continue;
            }
            popup.add(this.createMenuItem(element, (JComponent)popup));
        }
        return popup;
    }

    public JMenuBar createMenuBar(List list) {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = null;
        for (Object element : list) {
            if (element == null) {
                if (menu == null) continue;
                menu.addSeparator();
                continue;
            }
            if (element instanceof List) {
                menu = this.createMenu((List)element);
                if (menu == null) continue;
                menubar.add(menu);
                continue;
            }
            if (menu == null) continue;
            menu.add(this.createMenuItem(element, (JComponent)menu));
        }
        return menubar;
    }

    public JMenu createMenu(List list) {
        Action action = this.getAction(list.get(0));
        if (action == null) {
            return null;
        }
        JMenu menu = new JMenu(action);
        Iterator iter = list.listIterator(1);
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element == null) {
                menu.addSeparator();
                continue;
            }
            if (element instanceof List) {
                JMenu newMenu = this.createMenu((List)element);
                if (newMenu == null) continue;
                menu.add(newMenu);
                continue;
            }
            menu.add(this.createMenuItem(element, (JComponent)menu));
        }
        return menu;
    }

    private Action getAction(Object id) {
        Action action = this.getActionManager().getAction(id);
        if (action == null) {
            throw new RuntimeException("ERROR: No Action for " + id);
        }
        return action;
    }

    private ButtonGroup getGroup(String groupid, JComponent container) {
        Integer hashCode;
        ButtonGroup group;
        if (this.groupMap == null) {
            this.groupMap = new HashMap();
        }
        int intCode = groupid.hashCode();
        if (container != null) {
            intCode ^= container.hashCode();
        }
        if ((group = (ButtonGroup)this.groupMap.get(hashCode = new Integer(intCode))) == null) {
            group = new ButtonGroup();
            this.groupMap.put(hashCode, group);
        }
        return group;
    }

    private JMenuItem createMenuItem(Object id, JComponent container) {
        return this.createMenuItem(this.getAction(id), container);
    }

    public JMenuItem createMenuItem(Action action, JComponent container) {
        AbstractActionExt ta;
        JMenuItem menuItem = null;
        if (action instanceof AbstractActionExt && (ta = (AbstractActionExt)action).isStateAction()) {
            String groupid = (String)ta.getGroup();
            menuItem = groupid != null ? this.createRadioButtonMenuItem(this.getGroup(groupid, container), (AbstractActionExt)action) : this.createCheckBoxMenuItem((AbstractActionExt)action);
        }
        if (menuItem == null) {
            menuItem = new JMenuItem(action);
            this.configureMenuItem(menuItem, action);
        }
        return menuItem;
    }

    public JMenuItem createMenuItem(Action action) {
        return this.createMenuItem(action, null);
    }

    private AbstractButton createButton(Object id, JComponent container) {
        return this.createButton(this.getAction(id), container);
    }

    public AbstractButton createButton(Action action, JComponent container) {
        AbstractActionExt ta;
        if (action == null) {
            return null;
        }
        AbstractButton button = null;
        if (action instanceof AbstractActionExt && (ta = (AbstractActionExt)action).isStateAction()) {
            String groupid = (String)ta.getGroup();
            button = groupid == null ? this.createToggleButton(ta) : this.createToggleButton(ta, this.getGroup(groupid, container));
        }
        if (button == null) {
            button = new JButton(action);
            this.configureButton(button, action);
        }
        return button;
    }

    public AbstractButton createButton(Action action) {
        return this.createButton(action, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt a) {
        return this.createToggleButton(a, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt a, ButtonGroup group) {
        JToggleButton button = new JToggleButton();
        this.configureButton(button, a, group);
        return button;
    }

    public void configureButton(JToggleButton button, AbstractActionExt a, ButtonGroup group) {
        button.setAction(a);
        button.addItemListener(a);
        button.setSelected(a.isSelected());
        if (group != null) {
            group.add(button);
        }
        this.configureToggleButton(button, a);
    }

    protected void configureToggleButton(JToggleButton button, Action action) {
        this.configureButton(button, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(button));
    }

    protected void configureButton(AbstractButton button, Action action) {
        if (action.getValue("ShortDescription") == null) {
            button.setToolTipText((String)action.getValue("Name"));
        }
        if (action.getValue("__LargeIcon__") != null) {
            button.setIcon((Icon)action.getValue("__LargeIcon__"));
        }
        if (button.getIcon() != null) {
            button.setText("");
        }
    }

    protected void configureToggleMenuItem(JMenuItem menuItem, Action action) {
        this.configureMenuItem(menuItem, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(menuItem));
    }

    protected void configureMenuItem(JMenuItem menuItem, Action action) {
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(AbstractActionExt a) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(a);
        mi.addItemListener(a);
        mi.setSelected(a.isSelected());
        this.configureToggleMenuItem(mi, a);
        return mi;
    }

    private JRadioButtonMenuItem createRadioButtonMenuItem(ButtonGroup group, AbstractActionExt a) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(a);
        mi.addItemListener(a);
        mi.setSelected(a.isSelected());
        if (group != null) {
            group.add(mi);
        }
        this.configureToggleMenuItem(mi, a);
        return mi;
    }
}

