/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.JXFindBar;
import org.jdesktop.swingx.JXFindPanel;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class SearchFactory {
    private static SearchFactory searchFactory;
    protected JXFindPanel findPanel;
    protected JXFindBar findBar;
    protected JComponent lastFindBarTarget;
    private boolean useFindBar;
    private Point lastFindDialogLocation;
    private FindRemover findRemover;

    static {
        LookAndFeelAddons.getAddon();
    }

    public static SearchFactory getInstance() {
        if (searchFactory == null) {
            searchFactory = new SearchFactory();
        }
        return searchFactory;
    }

    public static void setInstance(SearchFactory factory) {
        searchFactory = factory;
    }

    public void showFindInput(JComponent target, Searchable searchable) {
        if (this.isUseFindBar(target, searchable)) {
            this.showFindBar(target, searchable);
        } else {
            this.showFindDialog(target, searchable);
        }
    }

    public void showFindBar(JComponent target, Searchable searchable) {
        if (target == null) {
            return;
        }
        if (this.findBar == null) {
            this.findBar = this.getSharedFindBar();
        } else {
            this.releaseFindBar();
        }
        Window topLevel = SwingUtilities.getWindowAncestor(target);
        if (topLevel instanceof JXFrame) {
            JXRootPane rootPane = ((JXFrame)topLevel).getRootPaneExt();
            JToolBar toolBar = rootPane.getToolBar();
            if (toolBar == null) {
                toolBar = new JToolBar();
                rootPane.setToolBar(toolBar);
            }
            toolBar.add((Component)this.findBar, 0);
            rootPane.revalidate();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.findBar);
        }
        this.lastFindBarTarget = target;
        target.putClientProperty("match.highlighter", Boolean.TRUE);
        this.installFindRemover(target, this.findBar);
        this.getSharedFindBar().setSearchable(searchable);
    }

    protected void installFindRemover(Container target, Container findWidget) {
        if (target != null) {
            this.getFindRemover().addTarget(target);
        }
        this.getFindRemover().addTarget(findWidget);
    }

    private FindRemover getFindRemover() {
        if (this.findRemover == null) {
            this.findRemover = new FindRemover();
        }
        return this.findRemover;
    }

    protected void removeFromParent(JComponent component) {
        Container oldParent = component.getParent();
        if (oldParent != null) {
            oldParent.remove(component);
            if (oldParent instanceof JComponent) {
                ((JComponent)oldParent).revalidate();
            } else {
                oldParent.invalidate();
                oldParent.validate();
            }
        }
    }

    public JXFindBar getSharedFindBar() {
        if (this.findBar == null) {
            this.findBar = this.createFindBar();
            this.configureSharedFindBar();
        }
        return this.findBar;
    }

    protected void configureSharedFindBar() {
        AbstractAction removeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchFactory.this.removeFromParent(SearchFactory.this.findBar);
            }
        };
        this.findBar.getActionMap().put("close", removeAction);
    }

    public JXFindBar createFindBar() {
        return new JXFindBar();
    }

    public JXFindPanel getSharedFindPanel() {
        if (this.findPanel == null) {
            this.findPanel = this.createFindPanel();
            this.configureSharedFindPanel();
        }
        return this.findPanel;
    }

    protected void configureSharedFindPanel() {
    }

    public JXFindPanel createFindPanel() {
        return new JXFindPanel();
    }

    public void showFindDialog(JComponent target, Searchable searchable) {
        JXDialog findDialog;
        JXDialog topLevel;
        Frame frame = JOptionPane.getRootFrame();
        if (target != null) {
            target.putClientProperty("match.highlighter", Boolean.FALSE);
            Window window = SwingUtilities.getWindowAncestor(target);
            if (window instanceof Frame) {
                frame = (Frame)window;
            }
        }
        if ((topLevel = this.getDialogForSharedFilePanel()) != null && topLevel.getOwner().equals(frame)) {
            findDialog = topLevel;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(findDialog);
        } else {
            Point location = this.hideSharedFilePanel();
            findDialog = new JXDialog(frame, this.getSharedFindPanel());
            findDialog.pack();
            if (location == null) {
                findDialog.setLocationRelativeTo(frame);
            } else {
                findDialog.setLocation(location);
            }
        }
        findDialog.setVisible(true);
        this.installFindRemover(target, findDialog);
        this.getSharedFindPanel().setSearchable(searchable);
    }

    private JXDialog getDialogForSharedFilePanel() {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        return window instanceof JXDialog ? (JXDialog)window : null;
    }

    protected Point hideSharedFilePanel() {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        Point location = this.lastFindDialogLocation;
        if (window != null) {
            this.findPanel.getParent().remove(this.findPanel);
            if (window.isVisible()) {
                location = window.getLocationOnScreen();
            }
            window.dispose();
        }
        return location;
    }

    protected void stopSearching() {
        if (this.findPanel != null) {
            this.lastFindDialogLocation = this.hideSharedFilePanel();
            this.findPanel.setSearchable(null);
        }
        if (this.findBar != null) {
            this.releaseFindBar();
        }
    }

    private void releaseFindBar() {
        this.findBar.setSearchable(null);
        if (this.lastFindBarTarget != null) {
            this.lastFindBarTarget.putClientProperty("match.highlighter", Boolean.FALSE);
            this.lastFindBarTarget = null;
        }
        this.removeFromParent(this.findBar);
    }

    public boolean isUseFindBar(JComponent target, Searchable searchable) {
        return this.useFindBar;
    }

    public void setUseFindBar(boolean inToolBar) {
        if (inToolBar == this.useFindBar) {
            return;
        }
        this.useFindBar = inToolBar;
        this.getFindRemover().endSearching();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FindRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;
        Set<Container> targets;

        public FindRemover() {
            this.updateManager();
        }

        public void addTarget(Container target) {
            this.getTargets().add(target);
        }

        public void removeTarget(Container target) {
            this.getTargets().remove(target);
        }

        private Set<Container> getTargets() {
            if (this.targets == null) {
                this.targets = new HashSet<Container>();
            }
            return this.targets;
        }

        private void updateManager() {
            if (this.focusManager != null) {
                this.focusManager.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Component c = this.focusManager.getPermanentFocusOwner();
            if (c == null) {
                return;
            }
            for (Container element : this.getTargets()) {
                if (element != c && !SwingUtilities.isDescendingFrom(c, element)) continue;
                return;
            }
            this.endSearching();
        }

        public void endSearching() {
            this.getTargets().clear();
            SearchFactory.this.stopSearching();
        }
    }
}

