/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import junit.framework.TestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.MessageSource;
import org.jdesktop.swingx.event.MessageSourceSupport;
import org.jdesktop.swingx.event.ProgressListener;
import org.jdesktop.swingx.event.ProgressSource;

public class RootPaneTest
extends TestCase {
    private Action[] actions;
    private TestComponent[] comps;
    private static final int HEAD = 0;
    private static final int BODY = 1;
    private static final int ARMS = 2;
    private static final int LEGS = 3;

    protected void setUp() {
        this.actions = new Action[4];
        this.actions[0] = new TestAction("New", 78, "Create a new item");
        this.actions[1] = new TestAction("Open", 79, "Opens an item");
        this.actions[2] = new TestAction("Save", 83, "Saves an item");
        this.actions[3] = new TestAction("Exit", 88, "Exits the application");
        this.comps = new TestComponent[4];
        this.comps[0] = new TestComponent("Head");
        this.comps[1] = new TestComponent("Body");
        this.comps[2] = new TestComponent("Arms");
        this.comps[3] = new TestComponent("Legs");
    }

    protected void tearDown() {
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i] = null;
            this.comps[i] = null;
            ++i;
        }
        this.actions = null;
        this.comps = null;
    }

    public void testComponentRegistration() {
        TestComponent comp;
        JXRootPane rootPane = new JXRootPane();
        JXStatusBar statusBar = new JXStatusBar();
        rootPane.setStatusBar(statusBar);
        int i = 0;
        while (i < this.comps.length) {
            rootPane.addComponent(this.comps[i]);
            ++i;
        }
        Component[] cs = rootPane.getContentComponents();
        RootPaneTest.assertTrue((cs.length == this.comps.length ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < this.comps.length) {
            comp = this.comps[i2];
            comp.sendMessage();
            RootPaneTest.assertEquals((String)comp.getMessage(), (String)statusBar.getTrailingMessage());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.comps.length) {
            rootPane.removeComponent(this.comps[i2]);
            ++i2;
        }
        cs = rootPane.getContentComponents();
        RootPaneTest.assertTrue((cs.length == 0 ? 1 : 0) != 0);
        statusBar.setTrailingMessage("");
        i2 = 0;
        while (i2 < this.comps.length) {
            comp = this.comps[i2];
            comp.sendMessage();
            RootPaneTest.assertEquals((String)"", (String)statusBar.getTrailingMessage());
            ++i2;
        }
    }

    public void testAggregateContainerRegistration() {
        TestComponent comp;
        this.comps[0].add(this.comps[1]);
        this.comps[1].add(this.comps[2]);
        this.comps[1].add(this.comps[3]);
        JXRootPane rootPane = new JXRootPane();
        JXStatusBar statusBar = new JXStatusBar();
        rootPane.setStatusBar(statusBar);
        rootPane.addComponent(this.comps[0]);
        Component[] cs = rootPane.getContentComponents();
        RootPaneTest.assertTrue((cs.length == 1 ? 1 : 0) != 0);
        int i = 0;
        while (i < this.comps.length) {
            comp = this.comps[i];
            comp.sendMessage();
            RootPaneTest.assertEquals((String)comp.getMessage(), (String)statusBar.getTrailingMessage());
            ++i;
        }
        rootPane.removeComponent(this.comps[0]);
        cs = rootPane.getContentComponents();
        RootPaneTest.assertTrue((cs.length == 0 ? 1 : 0) != 0);
        statusBar.setTrailingMessage("");
        i = 0;
        while (i < this.comps.length) {
            comp = this.comps[i];
            comp.sendMessage();
            RootPaneTest.assertEquals((String)"", (String)statusBar.getTrailingMessage());
            ++i;
        }
    }

    public void testStatusBar() {
        TestComponent comp;
        JXRootPane rootPane = new JXRootPane();
        int i = 0;
        while (i < this.comps.length) {
            rootPane.addComponent(this.comps[i]);
            ++i;
        }
        JXStatusBar statusBar = new JXStatusBar();
        rootPane.setStatusBar(statusBar);
        int i2 = 0;
        while (i2 < this.comps.length) {
            comp = this.comps[i2];
            comp.sendMessage();
            RootPaneTest.assertEquals((String)comp.getMessage(), (String)statusBar.getTrailingMessage());
            ++i2;
        }
        rootPane.setStatusBar(new JXStatusBar());
        RootPaneTest.assertNotSame((Object)statusBar, (Object)rootPane.getStatusBar());
        statusBar.setTrailingMessage("");
        i2 = 0;
        while (i2 < this.comps.length) {
            comp = this.comps[i2];
            comp.sendMessage();
            RootPaneTest.assertEquals((String)"", (String)statusBar.getTrailingMessage());
            ++i2;
        }
    }

    public void testToolBar() {
        MouseListener[] listeners;
        JXRootPane rootPane = new JXRootPane();
        rootPane.setStatusBar(new JXStatusBar());
        JToolBar toolBar = new JToolBar();
        int i = 0;
        while (i < this.actions.length) {
            toolBar.add(this.actions[i]);
            ++i;
        }
        Component[] comps = toolBar.getComponents();
        int[] original = new int[comps.length];
        int i2 = 0;
        while (i2 < comps.length) {
            listeners = comps[i2].getMouseListeners();
            original[i2] = listeners.length;
            ++i2;
        }
        rootPane.setToolBar(toolBar);
        comps = toolBar.getComponents();
        i2 = 0;
        while (i2 < comps.length) {
            listeners = comps[i2].getMouseListeners();
            RootPaneTest.assertEquals((int)(original[i2] + 1), (int)listeners.length);
            ++i2;
        }
        rootPane.setToolBar(new JToolBar());
        comps = toolBar.getComponents();
        i2 = 0;
        while (i2 < comps.length) {
            listeners = comps[i2].getMouseListeners();
            RootPaneTest.assertEquals((int)original[i2], (int)listeners.length);
            ++i2;
        }
    }

    public void testMenuBar() {
        MouseListener[] listeners;
        JXRootPane rootPane = new JXRootPane();
        rootPane.setStatusBar(new JXStatusBar());
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        int i = 0;
        while (i < this.actions.length) {
            menu.add(this.actions[i]);
            ++i;
        }
        menuBar.add(menu);
        Component[] comps = menu.getComponents();
        int[] original = new int[comps.length];
        int i2 = 0;
        while (i2 < comps.length) {
            listeners = comps[i2].getMouseListeners();
            original[i2] = listeners.length;
            ++i2;
        }
        rootPane.setJMenuBar(menuBar);
        comps = menu.getComponents();
        i2 = 0;
        while (i2 < comps.length) {
            listeners = comps[i2].getMouseListeners();
            RootPaneTest.assertEquals((int)(original[i2] + 1), (int)listeners.length);
            ++i2;
        }
        rootPane.setJMenuBar(new JMenuBar());
        i2 = 0;
        while (i2 < comps.length) {
            listeners = comps[i2].getMouseListeners();
            original[i2] = listeners.length;
            ++i2;
        }
    }

    public static void main(String[] args) {
        Action[] actions = new Action[]{new TestAction("New", 78, "Create a new item"), new TestAction("Open", 79, "Opens an item"), new TestAction("Save", 83, "Saves an item"), new TestAction("Exit", 88, "Exits the application")};
        JToolBar toolBar = new JToolBar();
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        int i = 0;
        while (i < actions.length) {
            toolBar.add(actions[i]);
            menu.add(actions[i]);
            ++i;
        }
        menuBar.add(menu);
        JXRootPane rootPane = new JXRootPane();
        Component[] comps = new Component[]{new TestComponent("Head"), new TestComponent("Body"), new TestComponent("Arms"), new TestComponent("Legs")};
        rootPane.setStatusBar(new JXStatusBar());
        rootPane.setToolBar(toolBar);
        rootPane.setJMenuBar(menuBar);
        int i2 = 0;
        while (i2 < comps.length) {
            rootPane.addComponent(comps[i2]);
            ++i2;
        }
        rootPane.addComponent(new ProgressComponent());
        JXFrame frame = new JXFrame();
        frame.setRootPane(rootPane);
        frame.setVisible(true);
    }

    public static class TestAction
    extends AbstractAction {
        public TestAction(String name, int mnemonic, String description) {
            super(name);
            this.putValue("MnemonicKey", new Integer(mnemonic));
            this.putValue("LongDescription", description);
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    public static class ProgressComponent
    extends TestComponent
    implements ActionListener {
        private JButton start;
        private JButton stop;
        private JButton progress;

        protected void initUI() {
            this.setBorder(BorderFactory.createTitledBorder("Progress Messages"));
            this.start = new JButton("Start");
            this.start.addActionListener(this);
            this.stop = new JButton("Stop");
            this.stop.addActionListener(this);
            this.progress = new JButton("Progress");
            this.progress.addActionListener(this);
            this.add(this.start);
            this.add(this.stop);
            this.add(this.progress);
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.start) {
                this.support.fireProgressStarted(0, 0);
            } else if (source == this.stop) {
                this.support.fireProgressEnded();
            } else if (source == this.progress) {
                this.doLongOperation();
            }
        }

        private void doLongOperation() {
            boolean start = false;
            int stop = 100;
            Integer[] values = new Integer[]{new Integer(0), new Integer(100)};
            this.support.fireProgressStarted(0, 100);
            Timer timer = new Timer();
            TimerTask task = new TimerTask(this, timer){
                int progress;
                final /* synthetic */ ProgressComponent this$1;
                private final /* synthetic */ Timer val$timer;
                {
                    this.this$1 = progressComponent;
                    this.val$timer = timer;
                    this.progress = 0;
                }

                public void run() {
                    this.progress += 10;
                    if (this.progress > 100) {
                        this.this$1.support.fireProgressEnded();
                        this.val$timer.cancel();
                    } else {
                        this.this$1.support.fireProgressIncremented(this.progress);
                    }
                }
            };
            timer.schedule(task, 250L, 250L);
        }
    }

    public static class TestComponent
    extends JPanel
    implements MessageSource,
    ProgressSource {
        protected MessageSourceSupport support = new MessageSourceSupport(this);
        private JLabel label;
        private String text;

        public TestComponent(String text) {
            this.addMouseListener(new MouseHandler());
            this.text = text;
            this.initUI();
        }

        public TestComponent() {
            this("TestComponent");
        }

        protected void initUI() {
            this.label = new JLabel(this.text);
            this.add(this.label);
        }

        public void addMessageListener(MessageListener l) {
            this.support.addMessageListener(l);
        }

        public void removeMessageListener(MessageListener l) {
            this.support.removeMessageListener(l);
        }

        public MessageListener[] getMessageListeners() {
            return this.support.getMessageListeners();
        }

        public void addProgressListener(ProgressListener l) {
            this.support.addProgressListener(l);
        }

        public void removeProgressListener(ProgressListener l) {
            this.support.removeProgressListener(l);
        }

        public ProgressListener[] getProgressListeners() {
            return this.support.getProgressListeners();
        }

        public String getMessage() {
            return "I'm a " + this.text;
        }

        public void sendMessage() {
            this.support.fireMessage(this.getMessage());
        }

        private class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mouseEntered(MouseEvent evt) {
                TestComponent.this.sendMessage();
            }
        }
    }
}

