/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.RolloverHighlighter;
import org.jdesktop.swingx.treetable.FileSystemModel;
import org.jdesktop.swingx.util.AncientSwingTeam;

public class RolloverTest
extends InteractiveTestCase {
    private TableModel sortableTableModel;
    private RolloverHighlighter backgroundHighlighter;
    private RolloverHighlighter foregroundHighlighter;
    private ListModel listModel;
    private FileSystemModel treeTableModel;

    public static void main(String[] args) {
        RolloverTest test = new RolloverTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }

    public void testDummy() {
    }

    public void interactiveTableRollover() {
        final JXTable table = new JXTable(this.sortableTableModel);
        table.setRolloverEnabled(true);
        table.setHighlighters(new HighlighterPipeline());
        table.getHighlighters().addHighlighter(this.foregroundHighlighter);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "Table with rollover");
        AbstractAction toggleAction = new AbstractAction("toggle foreground/background"){
            boolean isBackground;

            public void actionPerformed(ActionEvent e) {
                if (this.isBackground) {
                    table.getHighlighters().addHighlighter(RolloverTest.this.foregroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.backgroundHighlighter);
                } else {
                    table.getHighlighters().addHighlighter(RolloverTest.this.backgroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.foregroundHighlighter);
                }
                this.isBackground = !this.isBackground;
            }
        };
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveListRollover() {
        final JXList table = new JXList(this.listModel);
        table.setRolloverEnabled(true);
        table.setHighlighters(new HighlighterPipeline());
        table.getHighlighters().addHighlighter(this.foregroundHighlighter);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXList with rollover");
        AbstractAction toggleAction = new AbstractAction("toggle foreground/background"){
            boolean isBackground;

            public void actionPerformed(ActionEvent e) {
                if (this.isBackground) {
                    table.getHighlighters().addHighlighter(RolloverTest.this.foregroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.backgroundHighlighter);
                } else {
                    table.getHighlighters().addHighlighter(RolloverTest.this.backgroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.foregroundHighlighter);
                }
                this.isBackground = !this.isBackground;
            }
        };
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTreeRollover() {
        final JXTree table = new JXTree(this.treeTableModel);
        table.setRolloverEnabled(true);
        table.setComponentPopupMenu(this.createPopup());
        table.setHighlighters(new HighlighterPipeline());
        table.getHighlighters().addHighlighter(this.foregroundHighlighter);
        JTree tree = new JTree(this.treeTableModel);
        tree.setComponentPopupMenu(this.createPopup());
        JXFrame frame = this.wrapWithScrollingInFrame(table, tree, "JXTree (at left) with rollover");
        AbstractAction toggleAction = new AbstractAction("toggle foreground/background"){
            boolean isBackground;

            public void actionPerformed(ActionEvent e) {
                if (this.isBackground) {
                    table.getHighlighters().addHighlighter(RolloverTest.this.foregroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.backgroundHighlighter);
                } else {
                    table.getHighlighters().addHighlighter(RolloverTest.this.backgroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.foregroundHighlighter);
                }
                this.isBackground = !this.isBackground;
            }
        };
        this.addAction(frame, toggleAction);
        this.addMessage(frame, "background highlight not working in JXTree");
        frame.setVisible(true);
    }

    public JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add("dummy");
        return popup;
    }

    public void interactiveTreeTableRollover() {
        final JXTreeTable table = new JXTreeTable(this.treeTableModel);
        table.setRolloverEnabled(true);
        table.setHighlighters(new HighlighterPipeline());
        table.getHighlighters().addHighlighter(this.foregroundHighlighter);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "Table with rollover");
        AbstractAction toggleAction = new AbstractAction("toggle foreground/background"){
            boolean isBackground;

            public void actionPerformed(ActionEvent e) {
                if (this.isBackground) {
                    table.getHighlighters().addHighlighter(RolloverTest.this.foregroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.backgroundHighlighter);
                } else {
                    table.getHighlighters().addHighlighter(RolloverTest.this.backgroundHighlighter);
                    table.getHighlighters().removeHighlighter(RolloverTest.this.foregroundHighlighter);
                }
                this.isBackground = !this.isBackground;
            }
        };
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sortableTableModel = new AncientSwingTeam();
        this.listModel = new AbstractListModel(){

            public int getSize() {
                return RolloverTest.this.sortableTableModel.getRowCount();
            }

            public Object getElementAt(int index) {
                return RolloverTest.this.sortableTableModel.getValueAt(index, 0);
            }
        };
        this.treeTableModel = new FileSystemModel();
        this.foregroundHighlighter = new RolloverHighlighter(null, Color.MAGENTA);
        this.backgroundHighlighter = new RolloverHighlighter(Color.YELLOW, null);
    }
}

