/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.List;
import junit.framework.TestCase;
import org.jdesktop.swingx.PatternModel;
import org.jdesktop.swingx.util.PropertyChangeReport;

public class PatternModelTest
extends TestCase {
    static final String startAnchor = "^";
    static final String endAnchor = "$";
    static final String middleStartAnchor = "some^one";
    static final String middleEndAnchor = "some$one";
    private PropertyChangeReport propertyReport;

    public void testFoundIndexAutoAdjustBackward() {
        PatternModel model = new PatternModel();
        model.setBackwards(true);
        PatternModelTest.assertTrue((String)"is autoAdjust by default", (boolean)model.isAutoAdjustFoundIndex());
        model.addPropertyChangeListener(this.propertyReport);
        int foundIndex = 10;
        model.setFoundIndex(foundIndex);
        PatternModelTest.assertEquals((String)"foundIndex must be set", (int)(foundIndex - 1), (int)model.getFoundIndex());
        PatternModelTest.assertTrue((String)"changing foundIndex must have fired foundIndex property", (boolean)this.propertyReport.hasEvents("foundIndex"));
    }

    public void testFoundIndexAutoAdjustNotFound() {
        PatternModel model = new PatternModel();
        PatternModelTest.assertTrue((String)"is autoAdjust by default", (boolean)model.isAutoAdjustFoundIndex());
        model.addPropertyChangeListener(this.propertyReport);
        int foundIndex = -1;
        model.setFoundIndex(foundIndex);
        PatternModelTest.assertEquals((String)"foundIndex must be set", (int)foundIndex, (int)model.getFoundIndex());
    }

    public void testFoundIndexAutoAdjustForward() {
        PatternModel model = new PatternModel();
        PatternModelTest.assertTrue((String)"is autoAdjust by default", (boolean)model.isAutoAdjustFoundIndex());
        model.addPropertyChangeListener(this.propertyReport);
        int foundIndex = 10;
        model.setFoundIndex(foundIndex);
        PatternModelTest.assertEquals((String)"foundIndex must be set", (int)(foundIndex + 1), (int)model.getFoundIndex());
        PatternModelTest.assertTrue((String)"changing foundIndex must have fired foundIndex property", (boolean)this.propertyReport.hasEvents("foundIndex"));
    }

    public void testFoundIndex() {
        PatternModel model = new PatternModel();
        model.setIncremental(true);
        PatternModelTest.assertEquals((String)"not found on start", (int)-1, (int)model.getFoundIndex());
        model.addPropertyChangeListener(this.propertyReport);
        model.setFoundIndex(10);
        PatternModelTest.assertEquals((String)"foundIndex must be set", (int)10, (int)model.getFoundIndex());
        PatternModelTest.assertTrue((String)"changing foundIndex must have fired foundIndex property", (boolean)this.propertyReport.hasEvents("foundIndex"));
    }

    public void testCaseSensitive() {
        PatternModel model = new PatternModel();
        model.setRawText("tab");
        PatternModelTest.assertTrue((String)"must find not case sensitive by default", (boolean)model.getPattern().matcher("JTABLE").find());
        model.addPropertyChangeListener(this.propertyReport);
        model.setCaseSensitive(true);
        PatternModelTest.assertTrue((String)"changing case sensitive must fire casesensitive property", (boolean)this.propertyReport.hasEvents("caseSensitive"));
        PatternModelTest.assertTrue((String)"changing case sensitive must fire pattern property", (boolean)this.propertyReport.hasEvents("pattern"));
    }

    public void testAvailableMatchRules() {
        PatternModel model = new PatternModel();
        List rules = model.getMatchRules();
        PatternModelTest.assertNotNull((String)"rules must not be null", (Object)rules);
    }

    public void testRegexCreator() {
        PatternModel model = new PatternModel();
        model.addPropertyChangeListener(this.propertyReport);
        model.setRegexCreatorKey("regex");
        PatternModelTest.assertEquals((String)"search string mode must be", (String)"regex", (String)model.getRegexCreatorKey());
        PatternModelTest.assertTrue((boolean)this.propertyReport.hasEvents("regexCreatorKey"));
    }

    public void testMatchRule() {
        PatternModel model = new PatternModel();
        model.addPropertyChangeListener(this.propertyReport);
        PatternModelTest.assertEquals((String)"search string mode must be", (String)"explicit", (String)model.getRegexCreatorKey());
        PatternModelTest.assertEquals((String)"search category must be ", (String)"contains", (String)model.getMatchRule());
        model.setMatchRule("equals");
        PatternModelTest.assertTrue((String)"model must have fired matchRule ", (boolean)this.propertyReport.hasEvents("matchRule"));
    }

    public void testChangeMatchRule() {
        PatternModel model = new PatternModel();
        String contained = "t";
        model.setRawText(contained);
        String match = "x" + contained + "x";
        PatternModelTest.assertTrue((String)("pattern must find " + match), (boolean)model.getPattern().matcher(match).find());
        model.addPropertyChangeListener(this.propertyReport);
        model.setMatchRule("equals");
        PatternModelTest.assertTrue((String)"model must have fire pattern change", (boolean)this.propertyReport.hasEvents("pattern"));
        PatternModelTest.assertFalse((String)("pattern must reject " + match), (boolean)model.getPattern().matcher(match).find());
        model.setMatchRule("startsWith");
        match = "txx";
        PatternModelTest.assertTrue((String)("pattern must find " + match), (boolean)model.getPattern().matcher(match).find());
        model.setMatchRule("endsWith");
        match = "xxt";
        PatternModelTest.assertTrue((String)("pattern must find " + match), (boolean)model.getPattern().matcher(match).find());
    }

    public void testRawMiddleAnchorTokens() {
        PatternModel patternModel = new PatternModel();
        patternModel.setRawText(startAnchor);
        String literalAnchor = middleStartAnchor;
        PatternModelTest.assertTrue((String)("must find literal containing startAnchor " + literalAnchor), (boolean)patternModel.getPattern().matcher(literalAnchor).find());
        String literal = "someone";
        PatternModelTest.assertFalse((String)("must reject literal not containing startAnchor " + literal), (boolean)patternModel.getPattern().matcher(literal).find());
    }

    public void testRawStartAnchor() {
        PatternModel patternModel = new PatternModel();
        String anchored = "^hap";
        patternModel.setRawText(anchored);
        String literalAnchor = "^happy";
        PatternModelTest.assertTrue((String)("must find literal containing startAnchor " + literalAnchor), (boolean)patternModel.getPattern().matcher(literalAnchor).find());
        String literal = "happy";
        PatternModelTest.assertFalse((String)("must reject literal not containing startAnchor " + literal), (boolean)patternModel.getPattern().matcher(literal).find());
    }

    protected void setUp() {
        this.propertyReport = new PropertyChangeReport();
    }
}

