/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.ErrorReporter;
import org.jdesktop.swingx.IncidentInfo;
import org.jdesktop.swingx.util.MailTransportProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailErrorReporter
extends ErrorReporter {
    private String mailAddr;
    private List<String> toList = new ArrayList<String>();
    private MailTransportProxy mailTransportProxy;

    public MailErrorReporter(String address) {
        this.mailAddr = address;
        this.toList.add(this.mailAddr);
    }

    public String getMailAddr() {
        return this.mailAddr;
    }

    public void setMailAddr(String mailAddr) {
        this.toList.remove(this.mailAddr);
        this.mailAddr = mailAddr;
        this.toList.add(this.mailAddr);
    }

    public void setMailTransportProxy(MailTransportProxy mailTransportProxy) {
        this.mailTransportProxy = mailTransportProxy;
    }

    @Override
    public void reportIncident(IncidentInfo info) {
        if (this.mailTransportProxy != null) {
            try {
                this.mailTransportProxy.mailMessage(this.toList, null, info.getHeader(), this.getMessageBody(info), this.getAttachments(info));
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public String getMessageBody(IncidentInfo incident) {
        String body = incident.getBasicErrorMessage();
        if (incident.getDetailedErrorMessage() != null) {
            body.concat("\n" + incident.getDetailedErrorMessage());
        }
        if (incident.getErrorException() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            incident.getErrorException().printStackTrace(pw);
            body = String.valueOf(body) + "\n ----- " + sw.toString();
        }
        return body;
    }

    public List<String> getAttachments(IncidentInfo incident) {
        return null;
    }
}

