/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.LinkRenderer;

public class LinkRendererTest
extends InteractiveTestCase {
    private static final Logger LOG = Logger.getLogger(LinkRendererTest.class.getName());
    private LinkModel link;
    private boolean defaultToSystemLF;
    static /* synthetic */ Class class$0;

    public void testSelectionBackground() {
        JXTable table = new JXTable(2, 2);
        LinkRenderer linkRenderer = new LinkRenderer();
        table.getColumnModel().getColumn(0).setCellRenderer(linkRenderer);
        JXHyperlink hyperlink = (JXHyperlink)linkRenderer.getTableCellRendererComponent(table, this.link, true, false, 1, 0);
        LinkRendererTest.assertTrue((String)"renderer comp must be opaque", (boolean)hyperlink.isOpaque());
        LinkRendererTest.assertEquals((String)"background must be table selection background", (Object)table.getSelectionBackground(), (Object)hyperlink.getBackground());
        hyperlink = (JXHyperlink)linkRenderer.getTableCellRendererComponent(table, this.link, false, false, 1, 0);
        LinkRendererTest.assertEquals((String)"background must be table background", (Object)table.getBackground(), (Object)hyperlink.getBackground());
    }

    public void testRendererComponentPropertiesAfterLFChange() {
        JXTable table = new JXTable(2, 2);
        LinkRenderer linkRenderer = new LinkRenderer();
        table.getColumnModel().getColumn(0).setCellRenderer(linkRenderer);
        LinkRendererTest.assertSame((Object)linkRenderer, (Object)table.getCellRenderer(1, 0));
        JXHyperlink hyperlink = (JXHyperlink)table.prepareRenderer(linkRenderer, 1, 0);
        LinkRendererTest.assertTrue((String)"renderer comp must be opaque", (boolean)hyperlink.isOpaque());
        LinkRendererTest.assertTrue((String)"renderer must paint border", (boolean)hyperlink.isBorderPainted());
        String lf = UIManager.getLookAndFeel().getName();
        LinkRendererTest.setSystemLF(!this.defaultToSystemLF);
        if (lf.equals(UIManager.getLookAndFeel().getName())) {
            LOG.info("cannot run rendererComponentPropertiesAfterLFChange - equal LF" + lf);
            return;
        }
        SwingUtilities.updateComponentTreeUI(table);
        LinkRendererTest.assertSame((Object)linkRenderer, (Object)table.getCellRenderer(1, 0));
        hyperlink = (JXHyperlink)table.prepareRenderer(linkRenderer, 1, 0);
        LinkRendererTest.assertTrue((String)"renderer comp must be opaque", (boolean)hyperlink.isOpaque());
        LinkRendererTest.assertTrue((String)"renderer must paint border", (boolean)hyperlink.isBorderPainted());
    }

    public void testRolloverRecognition() {
        JXTable table = new JXTable(2, 2);
        LinkRenderer linkRenderer = new LinkRenderer();
        table.getColumnModel().getColumn(0).setCellRenderer(linkRenderer);
        JXHyperlink hyperlink = (JXHyperlink)linkRenderer.getTableCellRendererComponent(table, this.link, false, false, 1, 0);
        LinkRendererTest.assertFalse((String)"renderer must not be rollover", (boolean)hyperlink.getModel().isRollover());
        table.putClientProperty("swingx.rollover", new Point(0, 1));
        hyperlink = (JXHyperlink)linkRenderer.getTableCellRendererComponent(table, this.link, false, false, 1, 0);
        LinkRendererTest.assertTrue((String)"renderer must be rollover", (boolean)hyperlink.getModel().isRollover());
    }

    public void interactiveTableSelectionBackgroundOnLF() {
        final JXTable table = new JXTable(2, 2);
        LinkRenderer linkRenderer = new LinkRenderer();
        table.getColumnModel().getColumn(0).setCellRenderer(linkRenderer);
        table.setRowSelectionInterval(1, 1);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "test background");
        AbstractAction toggle = new AbstractAction("toggleLF"){
            boolean systemLF;
            {
                super($anonymous0);
                this.systemLF = LinkRendererTest.this.defaultToSystemLF;
            }

            public void actionPerformed(ActionEvent e) {
                this.systemLF = !this.systemLF;
                LinkRendererTest.setSystemLF(this.systemLF);
                SwingUtilities.updateComponentTreeUI(table);
            }
        };
        this.addAction(frame, toggle);
        frame.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        LinkRendererTest test = new LinkRendererTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        URL url = ((Object)((Object)this)).getClass().getResource("resources/test.html");
        this.link = new LinkModel("a resource", null, url);
        this.defaultToSystemLF = false;
        LinkRendererTest.setSystemLF(this.defaultToSystemLF);
    }
}

