/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.RolloverHighlighter;
import org.jdesktop.swingx.treetable.FileSystemModel;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JXTreeUnitTest
extends InteractiveTestCase {
    TreeTableModel treeTableModel;

    public JXTreeUnitTest() {
        super("JXTree Test");
    }

    public void testNullModel() {
        JXTree tree = new JXTree();
        JXTreeUnitTest.assertNotNull((Object)tree.getModel());
        tree.setModel(null);
        JXTreeUnitTest.assertEquals((int)0, (int)tree.getRowCount());
    }

    public void interactiveUnselectedFocusedBackground() {
        JXTree xtree = new JXTree(this.treeTableModel);
        xtree.setBackground(new Color(245, 255, 245));
        JTree tree = new JTree(this.treeTableModel);
        tree.setBackground(new Color(245, 255, 245));
        JXFrame frame = this.wrapWithScrollingInFrame(xtree, tree, "Unselected focused background: JXTree/JTree");
        frame.setVisible(true);
    }

    public void interactiveTestRolloverHighlight() {
        JXTree tree = new JXTree(this.treeTableModel);
        tree.setRolloverEnabled(true);
        tree.setHighlighters(this.createRolloverPipeline(true));
        JXFrame frame = this.wrapWithScrollingInFrame(tree, "Rollover  ");
        frame.setVisible(true);
    }

    private HighlighterPipeline createRolloverPipeline(boolean useForeground) {
        Color color = new Color(240, 240, 224);
        RolloverHighlighter highlighter = new RolloverHighlighter(useForeground ? null : color, useForeground ? color.darker() : null);
        return new HighlighterPipeline(new Highlighter[]{highlighter});
    }

    public void interactiveTestHighlighters() {
        JXTree tree = new JXTree(this.treeTableModel);
        String pattern = "o";
        tree.setHighlighters(new HighlighterPipeline(new Highlighter[]{new PatternHighlighter(null, Color.red, pattern, 0, 1)}));
        JXFrame frame = this.wrapWithScrollingInFrame(tree, "Highlighters: " + pattern);
        frame.setVisible(true);
    }

    public void interactiveTestToolTips() {
        JXTree tree = new JXTree(this.treeTableModel);
        tree.setCellRenderer(this.createRenderer());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(tree);
        JXFrame frame = this.wrapWithScrollingInFrame(tree, "tooltips");
        frame.setVisible(true);
    }

    private TreeCellRenderer createRenderer() {
        final DefaultTreeCellRenderer delegate = new DefaultTreeCellRenderer();
        TreeCellRenderer renderer = new TreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component result = delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                ((JComponent)result).setToolTipText(String.valueOf(tree.getPathForRow(row)));
                return result;
            }
        };
        return renderer;
    }

    public void interactiveTestLineStyle() {
        JXTree tree = new JXTree(this.treeTableModel);
        tree.setDragEnabled(true);
        tree.putClientProperty("JTree.lineStyle", "None");
        JXFrame frame = this.wrapWithScrollingInFrame(tree, "LineStyle Test");
        frame.setVisible(true);
    }

    public void interactiveTestTreeProperties() {
        final JXTree treeTable = new JXTree(this.treeTableModel);
        AbstractAction toggleHandles = new AbstractAction("Toggle Handles"){

            public void actionPerformed(ActionEvent e) {
                treeTable.setShowsRootHandles(!treeTable.getShowsRootHandles());
            }
        };
        AbstractAction toggleRoot = new AbstractAction("Toggle Root"){

            public void actionPerformed(ActionEvent e) {
                treeTable.setRootVisible(!treeTable.isRootVisible());
            }
        };
        treeTable.setRowHeight(22);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Toggle Tree properties ");
        this.addAction(frame, toggleRoot);
        this.addAction(frame, toggleHandles);
        frame.setVisible(true);
    }

    public void interactiveTestTreeExpand() {
        final JXTree treeTable = new JXTree(this.treeTableModel);
        AbstractAction toggleScrolls = new AbstractAction("Toggle Scroll"){

            public void actionPerformed(ActionEvent e) {
                treeTable.setScrollsOnExpand(!treeTable.getScrollsOnExpand());
            }
        };
        AbstractAction expand = new AbstractAction("Expand"){

            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = treeTable.getSelectionRows();
                if (selectedRows.length > 0) {
                    treeTable.expandRow(selectedRows[0]);
                }
            }
        };
        treeTable.setRowHeight(22);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Toggle Tree expand properties ");
        this.addAction(frame, toggleScrolls);
        this.addAction(frame, expand);
        frame.setVisible(true);
    }

    public void interactiveTestShowsRootHandles() {
        JXTree tree = new JXTree(this.treeTableModel);
        tree.setShowsRootHandles(false);
        tree.setRootVisible(false);
        JXTree otherTree = new JXTree(this.treeTableModel);
        otherTree.setRootVisible(true);
        otherTree.setShowsRootHandles(false);
        JXFrame frame = this.wrapWithScrollingInFrame(tree, otherTree, "ShowsRootHandles");
        frame.setVisible(true);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.treeTableModel = new FileSystemModel();
    }

    public static void main(String[] args) {
        JXTreeUnitTest.setSystemLF(true);
        JXTreeUnitTest test = new JXTreeUnitTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }
}

