/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.JXTreeTableUnitTest;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.ConditionalHighlighter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.HierarchicalColumnHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.ShuttleSorter;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.util.ComponentTreeTableModel;

public class JXTreeTableVisualCheck
extends JXTreeTableUnitTest {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        JXTreeTableVisualCheck.setSystemLF(true);
        JXTreeTableVisualCheck test = new JXTreeTableVisualCheck();
        try {
            test.runInteractiveTests("interactive.*Highligh.*");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void interactiveTestInsertNode() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        final InsertTreeTableModel model = new InsertTreeTableModel(root);
        final DefaultMutableTreeNode leaf = model.addChild(root);
        JXTree tree = new JXTree(model);
        JXTreeTable treeTable = new JXTreeTable(model);
        JXFrame frame = this.wrapWithScrollingInFrame(tree, treeTable, "update on insert");
        AbstractAction insertAction = new AbstractAction("insert node"){

            public void actionPerformed(ActionEvent e) {
                model.addChild(leaf);
                this.setEnabled(false);
            }
        };
        this.addAction(frame, insertAction);
        frame.setVisible(true);
    }

    public void interactiveTestSetModel() {
        final JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setColumnControlVisible(true);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "toggle model");
        frame.setVisible(true);
        final ComponentTreeTableModel model = new ComponentTreeTableModel(frame);
        AbstractAction action = new AbstractAction("Toggle model"){

            public void actionPerformed(ActionEvent e) {
                TreeTableModel myModel = treeTable.getTreeTableModel();
                treeTable.setTreeTableModel(myModel == model ? JXTreeTableVisualCheck.this.treeTableModel : model);
            }
        };
        this.addAction(frame, action);
    }

    public void interactiveTestFocusedCellBackground() {
        JXTreeTable xtable = new JXTreeTable(this.treeTableModel);
        xtable.setBackground(new Color(245, 255, 245));
        JXFrame frame = this.wrapWithScrollingInFrame(xtable, "Unselected focused background");
        frame.setVisible(true);
    }

    public void interactiveTestToolTips() {
        JXTreeTable tree = new JXTreeTable(this.treeTableModel);
        tree.setTreeCellRenderer(this.createRenderer());
        tree.setDefaultRenderer(Object.class, this.createTableRenderer(tree.getDefaultRenderer(Object.class)));
        JXFrame frame = this.wrapWithScrollingInFrame(tree, "tooltips");
        frame.setVisible(true);
    }

    private TableCellRenderer createTableRenderer(final TableCellRenderer delegate) {
        TableCellRenderer l = new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ((JComponent)result).setToolTipText(String.valueOf(value));
                return result;
            }
        };
        return l;
    }

    private TreeCellRenderer createRenderer() {
        final DefaultTreeCellRenderer delegate = new DefaultTreeCellRenderer();
        TreeCellRenderer renderer = new TreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component result = delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                ((JComponent)result).setToolTipText(String.valueOf(tree.getPathForRow(row)));
                return result;
            }
        };
        return renderer;
    }

    public void interactiveTestBooleanRenderer() {
        JXTreeTable treeTable = new JXTreeTable(new MyTreeTableModel());
        treeTable.setRootVisible(true);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "boolean renderers");
        frame.setVisible(true);
    }

    public void interactiveTestCompareTreeProperties() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setShowsRootHandles(false);
        treeTable.setRootVisible(false);
        JXTreeTable other = new JXTreeTable(this.treeTableModel);
        other.setRootVisible(true);
        other.setShowsRootHandles(false);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, other, "compare rootVisible");
        frame.setVisible(true);
    }

    public void interactiveTestTreeProperties() {
        final JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        AbstractAction toggleHandles = new AbstractAction("Toggle Handles"){

            public void actionPerformed(ActionEvent e) {
                treeTable.setShowsRootHandles(!treeTable.getShowsRootHandles());
            }
        };
        AbstractAction toggleRoot = new AbstractAction("Toggle Root"){

            public void actionPerformed(ActionEvent e) {
                treeTable.setRootVisible(!treeTable.isRootVisible());
            }
        };
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Toggle Tree properties ");
        this.addAction(frame, toggleRoot);
        this.addAction(frame, toggleHandles);
        frame.setVisible(true);
    }

    public void interactiveTestTreeIcons() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        ImageIcon downIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("resources/images/wellbottom.gif"));
        treeTable.setClosedIcon(downIcon);
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Toggle Tree icons ");
        frame.setVisible(true);
    }

    public void interactiveTestFilterHighlightAndLineStyle() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.putClientProperty("JTree.lineStyle", "Angled");
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        treeTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.quickSilver, new HierarchicalColumnHighlighter(), new PatternHighlighter(null, Color.red, "^s", 2, 0, -1)}));
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "QuickSilver-, Column-, PatternHighligher and LineStyle");
        frame.setVisible(true);
    }

    public void interactiveTestFilters() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.putClientProperty("JTree.lineStyle", "Angled");
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        treeTable.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("^d", 2, 0)}));
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "PatternFilter");
        frame.setVisible(true);
    }

    public void interactiveTestSortingFilters() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        treeTable.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(1, false)}));
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "SortingFilter");
        frame.setVisible(true);
    }

    public void interactiveTestHighlightAndRowHeight() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        treeTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.linePrinter, new HierarchicalColumnHighlighter()}));
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "LinePrinter-, ColumnHighlighter and RowHeight");
        frame.setVisible(true);
    }

    public void interactiveTestAlternateRowHighlighter() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.classicLinePrinter}));
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "ClassicLinePrinter and RowHeight");
        frame.setVisible(true);
    }

    public void interactiveTestBackgroundHighlighter() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.notePadBackground, new HierarchicalColumnHighlighter()}));
        treeTable.setBackground(new Color(255, 255, 204));
        treeTable.setGridColor(Color.cyan.darker());
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        treeTable.setShowHorizontalLines(true);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "NotePadBackground- HierarchicalColumnHighlighter and horiz lines");
        frame.setVisible(true);
    }

    public void interactiveTestLedgerBackground() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setBackground(new Color(245, 255, 245));
        treeTable.setGridColor(Color.cyan.darker());
        treeTable.setRowHeight(22);
        treeTable.setRowMargin(1);
        treeTable.setShowHorizontalLines(true);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "LedgerBackground");
        frame.setVisible(true);
    }

    public void interactiveTestHierarchicalColumnHighlight() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{new HierarchicalColumnHighlighter()}));
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "HierarchicalColumnHigh");
        frame.setVisible(true);
    }

    public void interactiveTestIntercellSpacing1() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setIntercellSpacing(new Dimension(1, 1));
        treeTable.setShowGrid(true);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Intercellspacing 1");
        frame.setVisible(true);
    }

    public void interactiveTestIntercellSpacing2() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setIntercellSpacing(new Dimension(2, 2));
        treeTable.setShowGrid(true);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Intercellspacing 2");
        frame.setVisible(true);
    }

    public void interactiveTestIntercellSpacing3() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setIntercellSpacing(new Dimension(3, 3));
        treeTable.setShowGrid(true);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Intercellspacing 3");
        frame.setVisible(true);
    }

    public void interactiveTestHighlighterRowHeight() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{new Highlighter(Color.orange, null)}));
        treeTable.setIntercellSpacing(new Dimension(15, 15));
        treeTable.setRowHeight(48);
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Orange, big rowheight");
        frame.setVisible(true);
    }

    public void interactiveTestHighlighters() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setIntercellSpacing(new Dimension(15, 15));
        treeTable.setRowHeight(48);
        treeTable.setShowGrid(true);
        ConditionalHighlighter conditional = new ConditionalHighlighter(Color.BLUE, null, 0, 0){

            protected boolean test(ComponentAdapter adapter) {
                return adapter.hasFocus();
            }
        };
        treeTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{new Highlighter(Color.orange, null), new HierarchicalColumnHighlighter(), new PatternHighlighter(null, Color.red, "D", 0, 0, 0), conditional}));
        JXFrame frame = this.wrapWithScrollingInFrame(treeTable, "Highlighters: conditional, orange, hierarchy, pattern D");
        frame.setVisible(true);
    }

    public static class InsertTreeTableModel
    extends DefaultTreeTableModel {
        public InsertTreeTableModel(TreeNode root) {
            super(root);
        }

        public int getColumnCount() {
            return 2;
        }

        private DefaultMutableTreeNode addChild(DefaultMutableTreeNode parent) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Child");
            parent.add(newNode);
            this.fireTreeNodesInserted(this, this.getPathToRoot(parent), new int[]{parent.getIndex(newNode)}, new Object[]{newNode});
            return newNode;
        }
    }

    private class MyTreeTableModel
    extends DefaultTreeTableModel {
        static /* synthetic */ Class class$0;

        public MyTreeTableModel() {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
            root.add(new DefaultMutableTreeNode("A"));
            root.add(new DefaultMutableTreeNode("B"));
            this.setRoot(root);
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int column) {
            if (column == 1) {
                return Boolean.class;
            }
            return super.getColumnClass(column);
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public boolean isCellEditable(Object value, int column) {
            return true;
        }

        public Object getValueAt(Object o, int column) {
            if (column == 0) {
                return o.toString();
            }
            return new Boolean(true);
        }
    }
}

