/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Point;
import javax.swing.JTable;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.FileSystemModel;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JXTreeTableUnitTest
extends InteractiveTestCase {
    protected TreeTableModel treeTableModel;
    protected TreeTableModel simpleTreeTableModel;

    public JXTreeTableUnitTest() {
        super("JXTreeTable Unit Test");
    }

    public void testRemoveAllColumsAfterModelChanged() {
        JXTreeTable table = new JXTreeTable(new FileSystemModel());
        TableColumnExt columnX = table.getColumnExt(1);
        columnX.setVisible(false);
        int columnCount = table.getColumnCount(true);
        JXTreeTableUnitTest.assertEquals((String)"total column count must be same as model", (int)table.getModel().getColumnCount(), (int)columnCount);
        JXTreeTableUnitTest.assertEquals((String)"visible column count must one less as total", (int)(columnCount - 1), (int)table.getColumnCount());
        table.setTreeTableModel(new FileSystemModel());
        JXTreeTableUnitTest.assertEquals((String)"visible columns must be same as total", (int)table.getColumnCount(), (int)table.getColumnCount(true));
    }

    public void testRemoveListeners() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        treeTable.setTreeTableModel(new FileSystemModel());
        JXTreeTableUnitTest.assertEquals((int)0, (int)((AbstractTreeTableModel)this.treeTableModel).getTreeModelListeners().length);
    }

    public void testRowForPath() {
        JXTreeTable treeTable = new JXTreeTable(this.simpleTreeTableModel);
        int rowCount = treeTable.getRowCount();
        int row = 2;
        TreePath path = treeTable.getPathForRow(row);
        JXTreeTableUnitTest.assertEquals((String)"original row must be retrieved", (int)row, (int)treeTable.getRowForPath(path));
        treeTable.expandRow(row - 1);
        JXTreeTableUnitTest.assertTrue((String)"really expanded", (treeTable.getRowCount() > rowCount ? 1 : 0) != 0);
        TreePath expanded = treeTable.getPathForRow(row);
        JXTreeTableUnitTest.assertNotSame((String)"path at original row must be different when expanded", (Object)path, (Object)expanded);
        JXTreeTableUnitTest.assertEquals((String)"original row must be retrieved", (int)row, (int)treeTable.getRowForPath(expanded));
    }

    public void testPathForRowContract() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        JXTreeTableUnitTest.assertNull((String)"row < 0 must return null path", (Object)treeTable.getPathForRow(-1));
        JXTreeTableUnitTest.assertNull((String)"row >= getRowCount must return null path", (Object)treeTable.getPathForRow(treeTable.getRowCount()));
    }

    public void testTableRowAtNegativePoint() {
        JXTable treeTable = new JXTable(1, 4);
        int negativeYRowHeight = -treeTable.getRowHeight();
        int negativeYRowHeightPlusOne = negativeYRowHeight + 1;
        int negativeYMinimal = -1;
        JXTreeTableUnitTest.assertEquals((String)("negative y location rowheight " + negativeYRowHeight + " must return row -1"), (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYRowHeight)));
        JXTreeTableUnitTest.assertEquals((String)("negative y location " + negativeYRowHeightPlusOne + " must return row -1"), (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYRowHeightPlusOne)));
        JXTreeTableUnitTest.assertEquals((String)"minimal negative y location must return row -1", (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYMinimal)));
    }

    public void testTableRowAtOutsidePoint() {
        JTable treeTable = new JTable(2, 4);
        int negativeYRowHeight = (treeTable.getRowHeight() + treeTable.getRowMargin()) * treeTable.getRowCount();
        int negativeYRowHeightPlusOne = negativeYRowHeight - 1;
        int negativeYMinimal = -1;
        JXTreeTableUnitTest.assertEquals((String)("negative y location rowheight " + negativeYRowHeight + " must return row -1"), (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYRowHeight)));
        JXTreeTableUnitTest.assertEquals((String)("negative y location " + negativeYRowHeightPlusOne + " must return row -1"), (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYRowHeightPlusOne)));
    }

    public void testPathForLocationContract() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        int negativeYRowHeight = -treeTable.getRowHeight();
        int negativeYRowHeightPlusOne = negativeYRowHeight + 1;
        int negativeYMinimal = -1;
        JXTreeTableUnitTest.assertEquals((String)("negative y location rowheight " + negativeYRowHeight + " must return row -1"), (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYRowHeight)));
        JXTreeTableUnitTest.assertEquals((String)("negative y location " + negativeYRowHeightPlusOne + " must return row -1"), (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYRowHeightPlusOne)));
        JXTreeTableUnitTest.assertEquals((String)"minimal negative y location must return row -1", (int)-1, (int)treeTable.rowAtPoint(new Point(-1, negativeYMinimal)));
    }

    public void testRendererProperties() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        boolean expandsSelected = !treeTable.getExpandsSelectedPaths();
        boolean scrollsOnExpand = !treeTable.getScrollsOnExpand();
        boolean showRootHandles = !treeTable.getShowsRootHandles();
        boolean rootVisible = !treeTable.isRootVisible();
        treeTable.setExpandsSelectedPaths(expandsSelected);
        treeTable.setScrollsOnExpand(scrollsOnExpand);
        treeTable.setShowsRootHandles(showRootHandles);
        treeTable.setRootVisible(rootVisible);
        JXTreeTableUnitTest.assertEquals((String)"expand selected", (boolean)expandsSelected, (boolean)treeTable.getExpandsSelectedPaths());
        JXTreeTableUnitTest.assertEquals((String)"scrolls expand", (boolean)scrollsOnExpand, (boolean)treeTable.getScrollsOnExpand());
        JXTreeTableUnitTest.assertEquals((String)"shows handles", (boolean)showRootHandles, (boolean)treeTable.getShowsRootHandles());
        JXTreeTableUnitTest.assertEquals((String)"root visible", (boolean)rootVisible, (boolean)treeTable.isRootVisible());
        treeTable.setTreeTableModel(new DefaultTreeTableModel());
        JXTreeTableUnitTest.assertEquals((String)"expand selected", (boolean)expandsSelected, (boolean)treeTable.getExpandsSelectedPaths());
        JXTreeTableUnitTest.assertEquals((String)"scrolls expand", (boolean)scrollsOnExpand, (boolean)treeTable.getScrollsOnExpand());
        JXTreeTableUnitTest.assertEquals((String)"shows handles", (boolean)showRootHandles, (boolean)treeTable.getShowsRootHandles());
        JXTreeTableUnitTest.assertEquals((String)"root visible", (boolean)rootVisible, (boolean)treeTable.isRootVisible());
    }

    public void testLineStyle() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        String propertyName = "JTree.lineStyle";
        treeTable.putClientProperty(propertyName, "Horizontal");
        JXTree renderer = (JXTree)((Object)treeTable.getCellRenderer(0, 0));
        JXTreeTableUnitTest.assertEquals((String)(String.valueOf(propertyName) + " set on renderer"), (Object)"Horizontal", (Object)renderer.getClientProperty(propertyName));
    }

    public void testArbitraryClientProperty() {
        JXTreeTable treeTable = new JXTreeTable(this.treeTableModel);
        String propertyName = "someproperty";
        treeTable.putClientProperty(propertyName, "Horizontal");
        JXTree renderer = (JXTree)((Object)treeTable.getCellRenderer(0, 0));
        JXTreeTableUnitTest.assertNull((String)(String.valueOf(propertyName) + " not set on renderer"), (Object)renderer.getClientProperty(propertyName));
    }

    protected void setUp() throws Exception {
        super.setUp();
        JXTree tree = new JXTree();
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        this.simpleTreeTableModel = new DefaultTreeTableModel((TreeNode)treeModel.getRoot());
        this.treeTableModel = new FileSystemModel();
    }
}

