/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableCellEditor;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JXTreeTable
extends JXTable {
    private TreeTableCellRenderer renderer;
    private static final Dimension spacing = new Dimension(0, 2);

    public JXTreeTable() {
        this(new DefaultTreeTableModel());
    }

    public JXTreeTable(TreeTableModel treeModel) {
        this(treeModel, new TreeTableCellRenderer(treeModel));
    }

    private JXTreeTable(TreeTableModel treeModel, TreeTableCellRenderer renderer) {
        super(new TreeTableModelAdapter(treeModel, renderer));
        if (treeModel != renderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.init(renderer);
        this.initActions();
        super.setSortable(false);
        this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(renderer));
        this.setShowGrid(false);
        this.setIntercellSpacing(spacing);
        this.adminSetRowHeight(this.getRowHeight());
        this.setRowMargin(this.getRowMargin());
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
    }

    public void setSortable(boolean sortable) {
    }

    public void setShowHorizontalLines(boolean show) {
        super.setShowHorizontalLines(show);
    }

    public void setShowVerticalLines(boolean show) {
        super.setShowVerticalLines(show);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        this.expandOrCollapseNode(e);
        boolean canEdit = super.editCellAt(row, column, e);
        if (canEdit && this.isHierarchical(column)) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return canEdit;
    }

    private void expandOrCollapseNode(EventObject e) {
        MouseEvent me;
        if (e instanceof MouseEvent && ((me = (MouseEvent)e).getModifiers() == 0 || me.getModifiers() == 16)) {
            int count = this.getColumnCount();
            int i = count - 1;
            while (i >= 0) {
                if (this.isHierarchical(i)) {
                    int savedHeight = this.renderer.getRowHeight();
                    this.renderer.setRowHeight(this.getRowHeight());
                    MouseEvent pressed = new MouseEvent(this.renderer, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)i, (boolean)false).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    this.renderer.dispatchEvent(pressed);
                    MouseEvent released = new MouseEvent(this.renderer, 502, pressed.getWhen(), pressed.getModifiers(), pressed.getX(), pressed.getY(), pressed.getClickCount(), pressed.isPopupTrigger());
                    this.renderer.dispatchEvent(released);
                    this.renderer.setRowHeight(savedHeight);
                    break;
                }
                --i;
            }
        }
    }

    public int getEditingRow() {
        return this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setTreeTableModel(TreeTableModel treeModel) {
        this.renderer.setModel(treeModel);
        ((TreeTableModelAdapter)this.getModel()).setTreeTableModel(treeModel);
        if (treeModel != this.renderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(this.renderer));
        this.adminSetRowHeight(this.getRowHeight());
        this.setRowMargin(this.getRowMargin());
    }

    public TreeTableModel getTreeTableModel() {
        return ((TreeTableModelAdapter)this.getModel()).getTreeTableModel();
    }

    public final void setModel(TableModel tableModel) {
        if (tableModel instanceof TreeTableModelAdapter) {
            if (((TreeTableModelAdapter)tableModel).getTreeTable() != null) {
                throw new IllegalArgumentException("model already bound");
            }
        } else {
            throw new IllegalArgumentException("unsupported model type");
        }
        super.setModel(tableModel);
        ((TreeTableModelAdapter)tableModel).bind(this);
    }

    public final void setRowHeight(int row, int rowHeight) {
        throw new UnsupportedOperationException("variable height rows not supported");
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        this.adjustTreeRowHeight();
    }

    public void setColumnMargin(int columnMargin) {
        super.setColumnMargin(columnMargin);
    }

    public void setRowMargin(int rowMargin) {
        super.setRowMargin(rowMargin);
        this.adjustTreeRowHeight();
    }

    private void adjustTreeRowHeight() {
        int treeRowHeight = this.rowHeight + (this.rowMargin << 1);
        if (this.renderer != null && this.renderer.getRowHeight() != treeRowHeight) {
            this.renderer.setRowHeight(treeRowHeight);
        }
    }

    public void setSelectionMode(int mode) {
        if (this.renderer != null) {
            switch (mode) {
                case 1: {
                    this.renderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.renderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.renderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        super.setSelectionMode(mode);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.row = row;
        adapter.column = column;
        return this.applyRenderer(component, adapter);
    }

    protected Component applyRenderer(Component component, ComponentAdapter adapter) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (adapter == null) {
            throw new IllegalArgumentException("null component data adapter");
        }
        if (this.isHierarchical(adapter.column)) {
            TreeCellRenderer tcr = this.renderer.getCellRenderer();
            if (tcr instanceof JXTree.DelegatingRenderer) {
                tcr = ((JXTree.DelegatingRenderer)tcr).getDelegateRenderer();
            }
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (adapter.isSelected()) {
                    dtcr.setTextSelectionColor(component.getForeground());
                    dtcr.setBackgroundSelectionColor(component.getBackground());
                } else {
                    dtcr.setTextNonSelectionColor(component.getForeground());
                    dtcr.setBackgroundNonSelectionColor(component.getBackground());
                }
            }
        }
        return component;
    }

    public void setTreeCellRenderer(TreeCellRenderer cellRenderer) {
        if (this.renderer != null) {
            this.renderer.setCellRenderer(cellRenderer);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.renderer.getCellRenderer();
    }

    public String getToolTipText(MouseEvent event) {
        int column = this.columnAtPoint(event.getPoint());
        if (this.isHierarchical(column)) {
            return this.renderer.getToolTipText(event);
        }
        return super.getToolTipText(event);
    }

    public void setCollapsedIcon(Icon icon) {
        this.renderer.setCollapsedIcon(icon);
    }

    public void setExpandedIcon(Icon icon) {
        this.renderer.setExpandedIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.renderer.setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.renderer.setClosedIcon(icon);
    }

    public void setLeafIcon(Icon icon) {
        this.renderer.setLeafIcon(icon);
    }

    public void clearSelection() {
        if (this.renderer != null) {
            this.renderer.clearSelection();
        }
        super.clearSelection();
    }

    public void collapseAll() {
        this.renderer.collapseAll();
    }

    public void expandAll() {
        this.renderer.expandAll();
    }

    public void collapsePath(TreePath path) {
        this.renderer.collapsePath(path);
    }

    public void expandPath(TreePath path) {
        this.renderer.expandPath(path);
    }

    public void collapseRow(int row) {
        this.renderer.collapseRow(row);
    }

    public void expandRow(int row) {
        this.renderer.expandRow(row);
    }

    public void setRootVisible(boolean visible) {
        this.renderer.setRootVisible(visible);
        this.repaint();
    }

    public boolean isRootVisible() {
        return this.renderer.isRootVisible();
    }

    public boolean isVisible(TreePath path) {
        return this.renderer.isVisible(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.renderer.isExpanded(path);
    }

    public boolean isExpanded(int row) {
        return this.renderer.isExpanded(row);
    }

    public boolean isCollapsed(TreePath path) {
        return this.renderer.isCollapsed(path);
    }

    public boolean isCollapsed(int row) {
        return this.renderer.isCollapsed(row);
    }

    public Enumeration getExpandedDescendants(TreePath parent) {
        return this.renderer.getExpandedDescendants(parent);
    }

    public void setExpandsSelectedPaths(boolean expand) {
        this.renderer.setExpandsSelectedPaths(expand);
    }

    public boolean getExpandsSelectedPaths() {
        return this.renderer.getExpandsSelectedPaths();
    }

    public TreePath getPathForLocation(int x, int y) {
        int row = this.rowAtPoint(new Point(x, y));
        if (row == -1) {
            return null;
        }
        return this.renderer.getPathForRow(row);
    }

    public TreePath getPathForRow(int row) {
        return this.renderer.getPathForRow(row);
    }

    public int getRowForPath(TreePath path) {
        return this.renderer.getRowForPath(path);
    }

    public void setScrollsOnExpand(boolean scroll) {
        this.renderer.setScrollsOnExpand(scroll);
    }

    public boolean getScrollsOnExpand() {
        return this.renderer.getScrollsOnExpand();
    }

    public void setShowsRootHandles(boolean visible) {
        this.renderer.setShowsRootHandles(visible);
        this.repaint();
    }

    public boolean getShowsRootHandles() {
        return this.renderer.getShowsRootHandles();
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.addTreeExpansionListener(tel);
    }

    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.removeTreeExpansionListener(tel);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.addTreeSelectionListener(tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.removeTreeSelectionListener(tsl);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.addTreeWillExpandListener(tel);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.removeTreeWillExpandListener(tel);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.renderer.getSelectionModel();
    }

    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.isHierarchical(this.editingColumn)) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.renderer != null) {
            this.renderer.updateUI();
            this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(this.renderer));
            if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
                this.setBackground(this.renderer.getBackground());
            }
        }
    }

    public boolean isHierarchical(int column) {
        return AbstractTreeTableModel.hierarchicalColumnClass.isAssignableFrom(this.getColumnClass(column));
    }

    private final void init(TreeTableCellRenderer renderer) {
        this.renderer = renderer;
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        if (renderer != null) {
            renderer.bind(this);
            renderer.setSelectionModel(selectionWrapper);
        }
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(AbstractTreeTableModel.hierarchicalColumnClass, renderer);
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JXTreeTable.this.renderer.putClientProperty(evt.getPropertyName(), evt.getNewValue());
            }
        };
        this.addPropertyChangeListener("JTree.lineStyle", l);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeTableDataAdapter(this);
        }
        return this.dataAdapter;
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTreeTable.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTreeTable.this.collapseAll();
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        int counter = min;
                        while (counter <= max) {
                            TreePath selPath;
                            if (this.listSelectionModel.isSelectedIndex(counter) && (selPath = JXTreeTable.this.renderer.getPathForRow(counter)) != null) {
                                this.addSelectionPath(selPath);
                            }
                            ++counter;
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    private static class TreeTableModelAdapter
    extends AbstractTableModel {
        private TreeModelListener treeModelListener;
        private TreeTableModel model;
        private final JTree tree;
        private JXTreeTable treeTable = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !TreeTableModelAdapter.class.desiredAssertionStatus();
        }

        TreeTableModelAdapter(TreeTableModel model, JTree tree) {
            if (!$assertionsDisabled && model == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            this.tree = tree;
            this.setTreeTableModel(model);
            tree.addTreeExpansionListener(new TreeExpansionListener(this){
                final /* synthetic */ TreeTableModelAdapter this$1;
                {
                    this.this$1 = treeTableModelAdapter;
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    this.this$1.fireTableDataChanged();
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    this.this$1.fireTableDataChanged();
                }
            });
        }

        public void setTreeTableModel(TreeTableModel model) {
            TreeTableModel old = this.getTreeTableModel();
            if (old != null) {
                old.removeTreeModelListener(this.getTreeModelListener());
            }
            this.model = model;
            model.addTreeModelListener(this.getTreeModelListener());
            this.fireTableStructureChanged();
        }

        private TreeModelListener getTreeModelListener() {
            if (this.treeModelListener == null) {
                this.treeModelListener = new TreeModelListener(this){
                    final /* synthetic */ TreeTableModelAdapter this$1;
                    {
                        this.this$1 = treeTableModelAdapter;
                    }

                    public void treeNodesChanged(TreeModelEvent e) {
                        TreeTableModelAdapter.access$0(this.this$1, e, 0);
                    }

                    public void treeNodesInserted(TreeModelEvent e) {
                        TreeTableModelAdapter.access$0(this.this$1, e, 1);
                    }

                    public void treeNodesRemoved(TreeModelEvent e) {
                        TreeTableModelAdapter.access$0(this.this$1, e, 2);
                    }

                    public void treeStructureChanged(TreeModelEvent e) {
                        TreeTableModelAdapter.access$1(this.this$1);
                    }
                };
            }
            return this.treeModelListener;
        }

        public TreeTableModel getTreeTableModel() {
            return this.model;
        }

        protected JXTreeTable getTreeTable() {
            return this.treeTable;
        }

        protected final void bind(JXTreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("adapter already bound");
            }
            this.treeTable = treeTable;
        }

        public Class getColumnClass(int column) {
            return this.model.getColumnClass(column);
        }

        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        public String getColumnName(int column) {
            return this.model.getColumnName(column);
        }

        public int getRowCount() {
            return this.tree.getRowCount();
        }

        public Object getValueAt(int row, int column) {
            return this.model.getValueAt(this.nodeForRow(row), column);
        }

        public boolean isCellEditable(int row, int column) {
            return this.model.isCellEditable(this.nodeForRow(row), column);
        }

        public void setValueAt(Object value, int row, int column) {
            this.model.setValueAt(value, this.nodeForRow(row), column);
        }

        protected Object nodeForRow(int row) {
            return this.tree.getPathForRow(row).getLastPathComponent();
        }

        private void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(this){
                final /* synthetic */ TreeTableModelAdapter this$1;
                {
                    this.this$1 = treeTableModelAdapter;
                }

                public void run() {
                    this.this$1.fireTableDataChanged();
                }
            });
        }

        private void delayedFireTableDataChanged(TreeModelEvent tme, int typeChange) {
            SwingUtilities.invokeLater(new Runnable(this, tme, typeChange){
                final /* synthetic */ TreeTableModelAdapter this$1;
                private final /* synthetic */ TreeModelEvent val$tme;
                private final /* synthetic */ int val$typeChange;
                {
                    this.this$1 = treeTableModelAdapter;
                    this.val$tme = treeModelEvent;
                    this.val$typeChange = n;
                }

                public void run() {
                    int[] indices = this.val$tme.getChildIndices();
                    TreePath path = this.val$tme.getTreePath();
                    if (indices != null) {
                        if (TreeTableModelAdapter.access$2(this.this$1).isExpanded(path)) {
                            int startingRow = TreeTableModelAdapter.access$2(this.this$1).getRowForPath(path) + 1;
                            int min = Integer.MAX_VALUE;
                            int max = Integer.MIN_VALUE;
                            int i = 0;
                            while (i < indices.length) {
                                if (indices[i] < min) {
                                    min = indices[i];
                                }
                                if (indices[i] > max) {
                                    max = indices[i];
                                }
                                ++i;
                            }
                            switch (this.val$typeChange) {
                                case 0: {
                                    this.this$1.fireTableRowsUpdated(startingRow + min, startingRow + max);
                                    break;
                                }
                                case 1: {
                                    this.this$1.fireTableRowsInserted(startingRow + min, startingRow + max);
                                    break;
                                }
                                case 2: {
                                    this.this$1.fireTableRowsDeleted(startingRow + min, startingRow + max);
                                }
                            }
                        } else {
                            int row = TreeTableModelAdapter.access$2(this.this$1).getRowForPath(path);
                            this.this$1.fireTableRowsUpdated(row, row);
                        }
                    } else {
                        this.this$1.fireTableDataChanged();
                    }
                }
            });
        }

        static /* synthetic */ void access$0(TreeTableModelAdapter treeTableModelAdapter, TreeModelEvent treeModelEvent, int n) {
            treeTableModelAdapter.delayedFireTableDataChanged(treeModelEvent, n);
        }

        static /* synthetic */ void access$1(TreeTableModelAdapter treeTableModelAdapter) {
            treeTableModelAdapter.delayedFireTableDataChanged();
        }

        static /* synthetic */ JTree access$2(TreeTableModelAdapter treeTableModelAdapter) {
            return treeTableModelAdapter.tree;
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        protected Border highlightBorder = null;
        protected JXTreeTable treeTable = null;
        protected int visibleRow = 0;
        private int hierarchicalColumnWidth = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !TreeTableCellRenderer.class.desiredAssertionStatus();
        }

        public TreeTableCellRenderer(TreeTableModel model) {
            super(model);
            this.putClientProperty("JTree.lineStyle", "None");
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setOverwriteRendererIcons(true);
            this.setCellRenderer(new ClippedTreeCellRenderer());
        }

        public final void bind(JXTreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("renderer already bound");
            }
            this.treeTable = treeTable;
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setBorderSelectionColor(null);
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            super.setRowHeight(rowHeight);
            if (rowHeight > 0 && this.treeTable != null) {
                int tableRowMargin = this.treeTable.getRowMargin();
                if (!$assertionsDisabled && tableRowMargin < 0) {
                    throw new AssertionError();
                }
                int tableRowHeight = rowHeight - (tableRowMargin << 1);
                if (this.treeTable.getRowHeight() != tableRowHeight) {
                    this.treeTable.adminSetRowHeight(tableRowHeight);
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            if (this.treeTable != null) {
                y = 0;
                h = this.treeTable.getRowCount() * this.getRowHeight();
            }
            super.setBounds(x, y, w, h);
        }

        public void paint(Graphics g) {
            int rowMargin = this.treeTable.getRowMargin();
            int margins = rowMargin + (rowMargin >> 1) + rowMargin % 2;
            int translationOffset = margins + this.visibleRow * this.getRowHeight();
            g.translate(0, -translationOffset);
            this.hierarchicalColumnWidth = this.getWidth();
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, translationOffset, this.getWidth(), this.getRowHeight() - (rowMargin << 1) - rowMargin);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!$assertionsDisabled && table != this.treeTable) {
                throw new AssertionError();
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.highlightBorder = null;
            if (this.treeTable != null && (this.treeTable.realEditingRow() != row || this.treeTable.getEditingColumn() != column) && hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = row;
            return this;
        }

        private class ClippedTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private final Rectangle iconRect = new Rectangle();
            private final Rectangle textRect = new Rectangle();
            private final Rectangle itemRect = new Rectangle();

            ClippedTreeCellRenderer() {
            }

            public void paint(Graphics g) {
                String fullText = super.getText();
                String shortText = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), fullText, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
                this.setText(shortText);
                super.paint(g);
                this.setText(fullText);
            }

            private Rectangle getItemRect(Rectangle itemRect) {
                this.getBounds(itemRect);
                itemRect.width = TreeTableCellRenderer.this.hierarchicalColumnWidth - itemRect.x;
                return itemRect;
            }
        }
    }

    protected static class TreeTableDataAdapter
    extends JXTable.TableAdapter {
        private final JXTreeTable table;

        public TreeTableDataAdapter(JXTreeTable component) {
            super(component);
            this.table = component;
        }

        public JXTreeTable getTreeTable() {
            return this.table;
        }

        public boolean isExpanded() {
            return super.isExpanded();
        }

        public boolean hasFocus() {
            boolean focus = super.hasFocus();
            return focus;
        }

        public boolean isLeaf() {
            return super.isLeaf();
        }

        public boolean isHierarchical() {
            return this.table.isHierarchical(this.column);
        }
    }
}

