/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.util.PropertyChangeReport;

public class JXTitledPanelTest
extends InteractiveTestCase {
    private static final Logger LOG = Logger.getLogger(JXTitledPanelTest.class.getName());
    private boolean defaultToSystemLF;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        this.defaultToSystemLF = false;
        JXTitledPanelTest.setSystemLF(this.defaultToSystemLF);
    }

    public JXTitledPanelTest() {
        super("JXTitledPane interactive test");
    }

    public void testLayoutOnLFChange() {
        JXTitledPanel titledPanel = new JXTitledPanel();
        JXTitledPanelTest.assertNotNull((Object)titledPanel.getContentContainer());
        titledPanel.getContentContainer().setLayout(new BorderLayout());
        String lf = UIManager.getLookAndFeel().getName();
        JXTitledPanelTest.setSystemLF(!this.defaultToSystemLF);
        if (lf.equals(UIManager.getLookAndFeel().getName())) {
            LOG.info("cannot run layoutOnLFChange - equal LF" + lf);
            return;
        }
        SwingUtilities.updateComponentTreeUI(titledPanel);
        JXTitledPanelTest.assertTrue((boolean)(titledPanel.getContentContainer().getLayout() instanceof BorderLayout));
    }

    public void testTitlePropertiesNotify() {
        String title = "starting title";
        JXTitledPanel panel = new JXTitledPanel(title);
        PropertyChangeReport report = new PropertyChangeReport();
        panel.addPropertyChangeListener(report);
        Font deriveFont = panel.getTitleFont().deriveFont(27.0f);
        panel.setTitleFont(deriveFont);
        JXTitledPanelTest.assertTrue((String)"panel must notify on titleFont change", (boolean)report.hasEvents("titleFont"));
        panel.setTitleForeground(Color.black);
        JXTitledPanelTest.assertTrue((String)"panel must notify on titleForeground change", (boolean)report.hasEvents("titleForeground"));
        panel.setTitleDarkBackground(Color.black);
        JXTitledPanelTest.assertTrue((String)"panel must notify on titleDarkBackground change", (boolean)report.hasEvents("titleDarkBackground"));
        panel.setTitleLightBackground(Color.black);
        JXTitledPanelTest.assertTrue((String)"panel must notify on titleLightBackground change", (boolean)report.hasEvents("titleLightBackground"));
    }

    public void testTitleNotify() {
        String title = "starting title";
        JXTitledPanel panel = new JXTitledPanel(title);
        PropertyChangeReport report = new PropertyChangeReport();
        panel.addPropertyChangeListener(report);
        panel.setTitle("new title");
        JXTitledPanelTest.assertTrue((String)"panel must have fired propertyChange", (boolean)report.hasEvents());
    }

    public void testTitleNotifyNamed() {
        String title = "starting title";
        JXTitledPanel panel = new JXTitledPanel(title);
        PropertyChangeReport report = new PropertyChangeReport();
        panel.addPropertyChangeListener("title", report);
        panel.setTitle("new title");
        JXTitledPanelTest.assertTrue((String)"panel must have fired propertyChange", (boolean)report.hasEvents());
    }

    public void testTitleNotifyPropertyValue() {
        String title = "starting title";
        JXTitledPanel panel = new JXTitledPanel(title);
        PropertyChangeReport report = new PropertyChangeReport();
        panel.addPropertyChangeListener("title", report);
        panel.setTitle(null);
        JXTitledPanelTest.assertTrue((String)"panel must have fired propertyChange", (boolean)report.hasEvents());
        JXTitledPanelTest.assertEquals((String)"new property value must be equal to getTitle", (Object)panel.getTitle(), (Object)report.getLastNewValue("title"));
    }

    public void interactiveRToL() {
        String title = "starting title";
        JXTitledPanel titledPane = new JXTitledPanel(title);
        titledPane.addLeftDecoration(new JLabel("Leading"));
        titledPane.addRightDecoration(new JLabel("Trailing"));
        ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("resources/images/wellBottom.gif"));
        final JLabel label = new JLabel(title);
        label.setIcon(icon);
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)titledPane, "North");
        panel.add(label);
        JXFrame frame = this.wrapInFrame(panel, "toggle Title");
        AbstractAction toggleCO = new AbstractAction("toggle orientation"){

            public void actionPerformed(ActionEvent e) {
                ComponentOrientation current = panel.getComponentOrientation();
                if (current == ComponentOrientation.LEFT_TO_RIGHT) {
                    panel.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    label.setText("RightToLeft");
                } else {
                    panel.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                    label.setText("LeftToRight");
                }
            }
        };
        this.addAction(frame, toggleCO);
        frame.pack();
        frame.setVisible(true);
    }

    public void interactiveIconAndHtmlTest() {
        String title = "<html><u>starting title </u></html>";
        JXTitledPanel panel = new JXTitledPanel(title);
        ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("resources/images/wellBottom.gif"));
        panel.addLeftDecoration(new JLabel(icon));
        panel.getContentContainer().setLayout(new BoxLayout(panel.getContentContainer(), 1));
        panel.getContentContainer().add(new JLabel(title));
        JXFrame frame = this.wrapInFrame(panel, "toggle Title");
        frame.setVisible(true);
    }

    public void interactiveTitleTest() {
        String title = "starting title";
        final JXTitledPanel panel = new JXTitledPanel(title);
        panel.getContentContainer().setLayout(new BoxLayout(panel.getContentContainer(), 1));
        AbstractAction toggleLight = new AbstractAction("toggle lightBackground"){

            public void actionPerformed(ActionEvent e) {
                Color oldFont = panel.getTitleLightBackground();
                panel.setTitleLightBackground(oldFont.darker());
            }
        };
        panel.getContentContainer().add(new JButton(toggleLight));
        panel.getContentContainer().setLayout(new BoxLayout(panel.getContentContainer(), 1));
        AbstractAction toggleDark = new AbstractAction("toggle darkbackground"){

            public void actionPerformed(ActionEvent e) {
                Color oldFont = panel.getTitleDarkBackground();
                panel.setTitleDarkBackground(oldFont.darker());
            }
        };
        panel.getContentContainer().add(new JButton(toggleDark));
        AbstractAction toggleForeground = new AbstractAction("toggle Foreground"){

            public void actionPerformed(ActionEvent e) {
                Color oldColor = panel.getTitleForeground();
                panel.setTitleForeground(oldColor.darker());
            }
        };
        panel.getContentContainer().add(new JButton(toggleForeground));
        AbstractAction toggleFont = new AbstractAction("toggle Font"){

            public void actionPerformed(ActionEvent e) {
                Font oldFont = panel.getTitleFont();
                System.out.println("oldfont size: " + oldFont.getSize());
                panel.setTitleFont(oldFont.deriveFont((float)oldFont.getSize() * 2.0f));
            }
        };
        panel.getContentContainer().add(new JButton(toggleFont));
        AbstractAction toggleTitle = new AbstractAction("toggle title"){
            int count;
            {
                super($anonymous0);
                this.count = 0;
            }

            public void actionPerformed(ActionEvent e) {
                panel.setTitle(" * " + this.count++ + " title");
            }
        };
        panel.getContentContainer().add(new JButton(toggleTitle));
        JXFrame frame = this.wrapInFrame(panel, "toggle Title");
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        JXTitledPanelTest test = new JXTitledPanelTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }
}

