/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.Properties;
import javax.swing.JTree;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.TestUtilities;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.tips.DefaultTip;
import org.jdesktop.swingx.tips.DefaultTipOfTheDayModel;
import org.jdesktop.swingx.tips.TipLoader;
import org.jdesktop.swingx.tips.TipOfTheDayModel;
import org.jdesktop.swingx.util.PropertyChangeReport;

public class JXTipOfTheDayTest
extends InteractiveTestCase {
    public JXTipOfTheDayTest(String arg0) {
        super(arg0);
    }

    public void testBean() {
        PropertyChangeReport report = new PropertyChangeReport();
        JXTipOfTheDay totd = new JXTipOfTheDay();
        JXTipOfTheDayTest.assertEquals((int)0, (int)totd.getCurrentTip());
        totd.nextTip();
        totd.previousTip();
        JXTipOfTheDayTest.assertFalse((boolean)report.hasEvents("currentTip"));
        totd.addPropertyChangeListener(report);
        DefaultTipOfTheDayModel model = new DefaultTipOfTheDayModel();
        model.add(new DefaultTip("name1", "description1"));
        model.add(new DefaultTip("name2", "<html>description2"));
        model.add(new DefaultTip("name3", new EmptyIcon()));
        model.add(new DefaultTip("name3", new JTree()));
        totd.setModel(model);
        JXTipOfTheDayTest.assertTrue((boolean)report.hasEvents("model"));
        JXTipOfTheDayTest.assertFalse((boolean)report.hasEvents("currentTip"));
        JXTipOfTheDayTest.assertEquals((int)0, (int)totd.getCurrentTip());
        totd.nextTip();
        JXTipOfTheDayTest.assertTrue((boolean)report.hasEvents("currentTip"));
        JXTipOfTheDayTest.assertEquals((int)1, (int)totd.getCurrentTip());
        totd.nextTip();
        JXTipOfTheDayTest.assertEquals((int)2, (int)totd.getCurrentTip());
        totd.nextTip();
        JXTipOfTheDayTest.assertEquals((int)3, (int)totd.getCurrentTip());
        totd.nextTip();
        JXTipOfTheDayTest.assertEquals((int)0, (int)totd.getCurrentTip());
        totd.previousTip();
        JXTipOfTheDayTest.assertEquals((int)3, (int)totd.getCurrentTip());
        try {
            totd.setCurrentTip(-1);
            JXTipOfTheDayTest.fail((String)"Negative tip!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            totd.setCurrentTip(totd.getModel().getTipCount());
            JXTipOfTheDayTest.fail((String)"Over the limit!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            totd.setModel(null);
            JXTipOfTheDayTest.fail((String)"Should not reach this code");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DefaultTip tip = new DefaultTip();
        JXTipOfTheDayTest.assertNull((Object)tip.getTip());
        JXTipOfTheDayTest.assertNull((Object)tip.getTipName());
        tip.setTipName("name");
        JXTipOfTheDayTest.assertEquals((String)"name", (String)tip.getTipName());
        tip.setTip("tip");
        JXTipOfTheDayTest.assertEquals((Object)"tip", (Object)tip.getTip());
        JXTipOfTheDayTest.assertEquals((String)tip.getTipName(), (String)tip.toString());
    }

    public void testTipLoader() {
        Properties props = new Properties();
        TipOfTheDayModel model = TipLoader.load(props);
        JXTipOfTheDayTest.assertEquals((int)0, (int)model.getTipCount());
        props.put("tip.1.name", "name1");
        props.put("tip.1.description", "description1");
        model = TipLoader.load(props);
        JXTipOfTheDayTest.assertEquals((int)1, (int)model.getTipCount());
        JXTipOfTheDayTest.assertEquals((String)"name1", (String)model.getTipAt(0).getTipName());
        JXTipOfTheDayTest.assertEquals((Object)"description1", (Object)model.getTipAt(0).getTip());
        props.put("tip.2.description", "description2");
        model = TipLoader.load(props);
        JXTipOfTheDayTest.assertEquals((int)2, (int)model.getTipCount());
        JXTipOfTheDayTest.assertEquals((String)"name1", (String)model.getTipAt(0).getTipName());
        JXTipOfTheDayTest.assertEquals((Object)"description1", (Object)model.getTipAt(0).getTip());
        JXTipOfTheDayTest.assertNull((Object)model.getTipAt(1).getTipName());
        JXTipOfTheDayTest.assertEquals((Object)"description2", (Object)model.getTipAt(1).getTip());
        props.put("tip.3.name", "name3");
        try {
            model = TipLoader.load(props);
            JXTipOfTheDayTest.assertTrue((String)"Must not get here", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        props.put("tip.3.description", "desc3");
        props.put("tip.5.description", "desc5");
        model = TipLoader.load(props);
        JXTipOfTheDayTest.assertEquals((int)3, (int)model.getTipCount());
    }

    public void testAddon() throws Exception {
        TestUtilities.cycleAddons(new JXTipOfTheDay());
    }

    public void testChoice() throws Exception {
        JXTipOfTheDay.ShowOnStartupChoice noshow = new JXTipOfTheDay.ShowOnStartupChoice(){

            public boolean isShowingOnStartup() {
                return false;
            }

            public void setShowingOnStartup(boolean showOnStartup) {
            }
        };
        JXTipOfTheDay totd = new JXTipOfTheDay();
        JXTipOfTheDayTest.assertFalse((boolean)totd.showDialog(null, noshow));
    }
}

