/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneBeanInfo;
import org.jdesktop.swingx.TestUtilities;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.util.PropertyChangeReport;

public class JXTaskPaneTest
extends InteractiveTestCase {
    public JXTaskPaneTest(String testTitle) {
        super(testTitle);
    }

    public void testBean() throws Exception {
        PropertyChangeReport report = new PropertyChangeReport();
        JXTaskPane group = new JXTaskPane();
        group.setAnimated(false);
        group.addPropertyChangeListener(report);
        group.setAnimated(true);
        JXTaskPaneTest.assertTrue((boolean)group.isAnimated());
        JXTaskPaneTest.assertEquals((String)"animated", (String)report.getLastEvent().getPropertyName());
        JXTaskPaneTest.assertTrue((boolean)report.getLastNewBooleanValue());
        group.setAnimated(false);
        JXTaskPaneTest.assertFalse((boolean)group.isAnimated());
        JXTaskPaneTest.assertFalse((boolean)report.getLastNewBooleanValue());
        UIManager.put("TaskPane.animate", Boolean.FALSE);
        JXTaskPane anotherGroup = new JXTaskPane();
        JXTaskPaneTest.assertFalse((boolean)anotherGroup.isAnimated());
        UIManager.put("TaskPane.animate", null);
        anotherGroup = new JXTaskPane();
        JXTaskPaneTest.assertTrue((boolean)anotherGroup.isAnimated());
        group.setTitle("the title");
        JXTaskPaneTest.assertEquals((String)"the title", (String)group.getTitle());
        JXTaskPaneTest.assertEquals((String)"title", (String)report.getLastEvent().getPropertyName());
        JXTaskPaneTest.assertEquals((Object)"the title", (Object)report.getLastNewValue());
        JXTaskPaneTest.assertNull((Object)group.getIcon());
        EmptyIcon icon = new EmptyIcon();
        group.setIcon(icon);
        JXTaskPaneTest.assertNotNull((Object)group.getIcon());
        JXTaskPaneTest.assertEquals((String)"icon", (String)report.getLastEvent().getPropertyName());
        JXTaskPaneTest.assertEquals((Object)icon, (Object)report.getLastNewValue());
        group.setIcon(null);
        JXTaskPaneTest.assertEquals((Object)icon, (Object)report.getLastOldValue());
        JXTaskPaneTest.assertNull((Object)report.getLastNewValue());
        JXTaskPaneTest.assertFalse((boolean)group.isSpecial());
        group.setSpecial(true);
        JXTaskPaneTest.assertTrue((boolean)group.isSpecial());
        JXTaskPaneTest.assertEquals((String)"special", (String)report.getLastEvent().getPropertyName());
        JXTaskPaneTest.assertTrue((boolean)report.getLastNewBooleanValue());
        JXTaskPaneTest.assertFalse((boolean)report.getLastOldBooleanValue());
        JXTaskPaneTest.assertFalse((boolean)group.isScrollOnExpand());
        group.setScrollOnExpand(true);
        JXTaskPaneTest.assertTrue((boolean)group.isScrollOnExpand());
        JXTaskPaneTest.assertEquals((String)"scrollOnExpand", (String)report.getLastEvent().getPropertyName());
        JXTaskPaneTest.assertTrue((boolean)report.getLastNewBooleanValue());
        JXTaskPaneTest.assertFalse((boolean)report.getLastOldBooleanValue());
        JXTaskPaneTest.assertTrue((boolean)group.isExpanded());
        group.setExpanded(false);
        JXTaskPaneTest.assertFalse((boolean)group.isExpanded());
        JXTaskPaneTest.assertEquals((String)"expanded", (String)report.getLastEvent().getPropertyName());
        JXTaskPaneTest.assertFalse((boolean)report.getLastNewBooleanValue());
        JXTaskPaneTest.assertTrue((boolean)report.getLastOldBooleanValue());
        new JXTaskPaneBeanInfo();
    }

    public void testContentPane() {
        JXTaskPane group = new JXTaskPane();
        JXTaskPaneTest.assertEquals((int)0, (int)group.getContentPane().getComponentCount());
        JButton button = new JButton();
        group.add(button);
        JXTaskPaneTest.assertEquals((Object)group.getContentPane(), (Object)button.getParent());
        group.remove(button);
        JXTaskPaneTest.assertNull((Object)button.getParent());
        JXTaskPaneTest.assertEquals((int)0, (int)group.getContentPane().getComponentCount());
        group.add(button);
        group.removeAll();
        JXTaskPaneTest.assertEquals((int)0, (int)group.getContentPane().getComponentCount());
        group.add(button);
        group.remove(0);
        JXTaskPaneTest.assertEquals((int)0, (int)group.getContentPane().getComponentCount());
        BorderLayout layout = new BorderLayout();
        group.setLayout(layout);
        JXTaskPaneTest.assertEquals((Object)layout, (Object)group.getContentPane().getLayout());
        JXTaskPaneTest.assertFalse((layout == group.getLayout() ? 1 : 0) != 0);
    }

    public void testActions() throws Exception {
        JXTaskPane taskPane = new JXTaskPane();
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        JXTaskPaneTest.assertEquals((int)0, (int)taskPane.getContentPane().getComponentCount());
        Component component = taskPane.add(action);
        JXTaskPaneTest.assertEquals((Object)taskPane.getContentPane(), (Object)component.getParent());
        JXTaskPaneTest.assertEquals((int)1, (int)taskPane.getContentPane().getComponentCount());
    }

    public void testAddon() throws Exception {
        TestUtilities.cycleAddons(new JXTaskPane());
    }
}

