/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableUnitTest;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.RolloverHighlighter;
import org.jdesktop.swingx.decorator.ShuttleSorter;
import org.jdesktop.swingx.table.ColumnHeaderRenderer;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.util.AncientSwingTeam;

public class JXTableVisualCheck
extends JXTableUnitTest {
    public static void main(String[] args) {
        JXTableVisualCheck test = new JXTableVisualCheck();
        try {
            test.runInteractiveTests("interactive.*Sorting.*");
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }

    public void interactiveTestCompareTableBoolean() {
        JXTable xtable = new JXTable(this.createModelWithBooleans());
        JTable table = new JTable(this.createModelWithBooleans());
        JXFrame frame = this.wrapWithScrollingInFrame(xtable, table, "Compare boolean renderer JXTable <--> JTable");
        frame.setVisible(true);
    }

    private TableModel createModelWithBooleans() {
        Object[] columnNames = new String[]{"text only", "Bool editable", "Bool not-editable"};
        DefaultTableModel model = new DefaultTableModel(columnNames, 0){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            public boolean isCellEditable(int row, int column) {
                return !this.getColumnName(column).contains("not");
            }
        };
        int i = 0;
        while (i < 4) {
            model.addRow(new Object[]{"text only " + i, Boolean.TRUE, Boolean.TRUE});
            ++i;
        }
        return model;
    }

    public void interactiveRToLTableWithColumnControl() {
        final JXTable table = new JXTable(this.createAscendingModel(0, 20));
        final JScrollPane pane = new JScrollPane(table);
        JXFrame frame = this.wrapInFrame(pane, "RToLScrollPane");
        AbstractAction toggleComponentOrientation = new AbstractAction("toggle orientation"){

            public void actionPerformed(ActionEvent e) {
                ComponentOrientation current = pane.getComponentOrientation();
                if (current == ComponentOrientation.LEFT_TO_RIGHT) {
                    pane.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                } else {
                    pane.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                }
            }
        };
        this.addAction(frame, toggleComponentOrientation);
        AbstractAction toggleColumnControl = new AbstractAction("toggle column control"){

            public void actionPerformed(ActionEvent e) {
                table.setColumnControlVisible(!table.isColumnControlVisible());
            }
        };
        this.addAction(frame, toggleColumnControl);
        frame.setVisible(true);
    }

    public void interactiveTestRowHeightAndSelection() {
        final JXTable table = new JXTable(this.sortableTableModel);
        table.setRowHeightEnabled(true);
        table.setRowHeight(0, table.getRowHeight() * 2);
        boolean column = false;
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                int selected = model.getMinSelectionIndex();
                if (selected < 0) {
                    return;
                }
                System.out.println("from selection: " + table.getValueAt(selected, 0));
            }
        });
        JXFrame frame = this.wrapWithScrollingInFrame(table, "Accessing values (indy rowheights)");
        AbstractAction updateCellAction = new AbstractAction("update cell value"){

            public void actionPerformed(ActionEvent e) {
                int anchorRow = table.getSelectionModel().getLeadSelectionIndex();
                int anchorCol = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (anchorRow < 0 || anchorCol < 0) {
                    return;
                }
                table.setValueAt("x" + table.getValueAt(anchorRow, anchorCol), anchorRow, anchorCol);
            }
        };
        this.addAction(frame, updateCellAction);
        frame.setVisible(true);
    }

    public void interactiveTestRowHeight() {
        final JXTable table = new JXTable(this.sortableTableModel);
        table.setRowHeightEnabled(true);
        table.setRowHeight(0, table.getRowHeight() * 2);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "Individual rowheight");
        AbstractAction temp = new AbstractAction("empty selection"){

            public void actionPerformed(ActionEvent e) {
                table.changeSelection(-1, -1, false, false);
            }
        };
        this.addAction(frame, temp);
        frame.setVisible(true);
    }

    public void interactiveTestSorterPatch() {
        Object[][] fourWheels = new Object[][]{{"Car", new Car(180.0f)}, {"Porsche", new Porsche(170.0f)}, {"Porsche", new Porsche(170.0f)}, {"Porsche", new Porsche(170.0f, false)}, {"Tractor", new Tractor(20.0f)}, {"Tractor", new Tractor(10.0f)}};
        DefaultTableModel model = new DefaultTableModel(fourWheels, new String[]{"Text", "Car"});
        JXTable table = new JXTable(model);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "Sorter patch");
        frame.setVisible(true);
    }

    public void interactiveTestLocaleSorter() {
        Object[][] rowData = new Object[][]{{Boolean.TRUE, "aa"}, {Boolean.FALSE, "AB"}, {Boolean.FALSE, "AC"}, {Boolean.TRUE, "BA"}, {Boolean.FALSE, "BB"}, {Boolean.TRUE, "BC"}};
        Object[] columnNames = new String[]{"Critical", "Task"};
        DefaultTableModel model = new DefaultTableModel(rowData, columnNames);
        JXTable table = new JXTable(model);
        table.setSorter(1);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "locale sorting");
        frame.setVisible(true);
    }

    public void interactiveTestColumnControlAndFilters() {
        final JXTable table = new JXTable(this.sortableTableModel);
        AbstractAction toggleFilter = new AbstractAction("Toggle Filter col. 0"){
            boolean hasFilters;

            public void actionPerformed(ActionEvent e) {
                if (this.hasFilters) {
                    table.setFilters(null);
                } else {
                    PatternFilter filter = new PatternFilter("e", 0, 0);
                    table.setFilters(new FilterPipeline(new Filter[]{filter}));
                }
                this.hasFilters = !this.hasFilters;
            }
        };
        toggleFilter.putValue("ShortDescription", "filtering first column - problem if invisible ");
        table.setColumnControlVisible(true);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable ColumnControl and Filters");
        this.addAction(frame, toggleFilter);
        frame.setVisible(true);
    }

    public void interactiveTestToggleTableModel() {
        final DefaultTableModel tableModel = this.createAscendingModel(0, 20);
        final JXTable table = new JXTable(tableModel);
        table.setColumnControlVisible(true);
        AbstractAction toggleAction = new AbstractAction("Toggle TableModel"){

            public void actionPerformed(ActionEvent e) {
                TableModel model = table.getModel();
                table.setModel(model.equals(tableModel) ? JXTableVisualCheck.this.sortableTableModel : tableModel);
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(table, "ColumnControl: set columnModel -> core default");
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestColumnControlColumnModel() {
        final JXTable table = new JXTable(10, 5);
        table.setColumnControlVisible(true);
        AbstractAction toggleAction = new AbstractAction("Set ColumnModel"){

            public void actionPerformed(ActionEvent e) {
                table.setColumnModel(new DefaultTableColumnModel());
                table.setModel(JXTableVisualCheck.this.sortableTableModel);
                this.setEnabled(false);
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(table, "ColumnControl: set columnModel -> core default");
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestColumnControlColumnModelExt() {
        final JXTable table = new JXTable();
        table.setColumnModel(new DefaultTableColumnModel());
        table.setModel(new DefaultTableModel(10, 5));
        table.setColumnControlVisible(true);
        AbstractAction toggleAction = new AbstractAction("Set ColumnModelExt"){

            public void actionPerformed(ActionEvent e) {
                table.setColumnModel(new DefaultTableColumnModelExt());
                table.setModel(JXTableVisualCheck.this.sortableTableModel);
                table.getColumnExt(0).setVisible(false);
                this.setEnabled(false);
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(table, "ColumnControl: set ColumnModel -> modelExt");
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestColumnControlConserveVerticalScrollBarPolicy() {
        final JXTable table = new JXTable();
        AbstractAction toggleAction = new AbstractAction("Toggle Control"){

            public void actionPerformed(ActionEvent e) {
                table.setColumnControlVisible(!table.isColumnControlVisible());
            }
        };
        table.setModel(new DefaultTableModel(10, 5));
        JScrollPane scrollPane1 = new JScrollPane(table);
        scrollPane1.setVerticalScrollBarPolicy(22);
        JXFrame frame = this.wrapInFrame(scrollPane1, "JXTable Vertical ScrollBar Policy");
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestColumnControlFewRows() {
        final JXTable table = new JXTable();
        AbstractAction toggleAction = new AbstractAction("Toggle Control"){

            public void actionPerformed(ActionEvent e) {
                table.setColumnControlVisible(!table.isColumnControlVisible());
            }
        };
        table.setModel(new DefaultTableModel(10, 5));
        table.setColumnControlVisible(true);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable ColumnControl with few rows");
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestColumnControlWithoutScrollPane() {
        final JXTable table = new JXTable();
        AbstractAction toggleAction = new AbstractAction("Toggle Control"){

            public void actionPerformed(ActionEvent e) {
                table.setColumnControlVisible(!table.isColumnControlVisible());
            }
        };
        toggleAction.putValue("ShortDescription", "does nothing visible - no scrollpane");
        table.setModel(new DefaultTableModel(10, 5));
        table.setColumnControlVisible(true);
        JXFrame frame = this.wrapInFrame(table, "JXTable: Toggle ColumnControl outside ScrollPane");
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestToggleScrollPaneWithColumnControlOn() {
        final JXTable table = new JXTable();
        table.setModel(new DefaultTableModel(10, 5));
        table.setColumnControlVisible(true);
        final JXFrame frame = this.wrapInFrame(table, "JXTable: Toggle ScrollPane with Columncontrol on");
        AbstractAction toggleAction = new AbstractAction("Toggle ScrollPane"){

            public void actionPerformed(ActionEvent e) {
                Container parent = table.getParent();
                boolean inScrollPane = parent instanceof JViewport;
                if (inScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)table.getParent().getParent();
                    frame.getContentPane().remove(scrollPane);
                    frame.getContentPane().add(table);
                } else {
                    parent.remove(table);
                    parent.add(new JScrollPane(table));
                }
                frame.pack();
            }
        };
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestColumnResizable() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setColumnControlVisible(true);
        final TableColumnExt priorityColumn = table.getColumnExt("First Name");
        JXFrame frame = this.wrapWithScrollingInFrame(table, "JXTable: Column with Min=Max not resizable");
        AbstractAction action = new AbstractAction("Toggle MinMax of FirstName"){

            public void actionPerformed(ActionEvent e) {
                if (priorityColumn.getMinWidth() == priorityColumn.getMaxWidth()) {
                    priorityColumn.setMinWidth(50);
                    priorityColumn.setMaxWidth(150);
                } else {
                    priorityColumn.setMinWidth(100);
                    priorityColumn.setMaxWidth(100);
                }
            }
        };
        this.addAction(frame, action);
        frame.setVisible(true);
    }

    public void interactiveMultipleComparatorsPerColumn() {
    }

    private TableModel createSplittableValues() {
        String[] values = new String[]{"avalue:zvalue", "avalue:yvalue", "avalue:xvalue", "bvalue:zvalue", "bvalue:yvalue", "bvalue:xvalue", "cvalue:zvalue", "cvalue:yvalue", "cvalue:xvalue"};
        DefaultTableModel model = new DefaultTableModel(values.length, 1);
        int i = 0;
        while (i < values.length) {
            model.setValueAt(values[i], i, 0);
            ++i;
        }
        return model;
    }

    public void interactiveTestRolloverHighlight() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setRolloverEnabled(true);
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{new RolloverHighlighter(Color.YELLOW, null)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "rollover highlight");
        frame.setVisible(true);
    }

    public void interactiveTestDisabledTableSorting() {
        final JXTable table = new JXTable(this.sortableTableModel);
        table.setColumnControlVisible(true);
        AbstractAction toggleAction = new AbstractAction("Toggle Enabled"){

            public void actionPerformed(ActionEvent e) {
                table.setEnabled(!table.isEnabled());
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(table, "Disabled tabled: no sorting");
        this.addAction(frame, toggleAction);
        frame.setVisible(true);
    }

    public void interactiveTestCustomRendererSorting() {
        JXTable table = new JXTable(this.sortableTableModel);
        TableColumn column = table.getColumn("No.");
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                value = "# " + value;
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                return comp;
            }
        };
        column.setCellRenderer(renderer);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "RendererSortingTest");
        frame.setVisible(true);
    }

    public void interactiveTestToggleSortable() {
        final JXTable table = new JXTable(this.sortableTableModel);
        table.setColumnControlVisible(true);
        AbstractAction toggleSortableAction = new AbstractAction("Toggle Sortable"){

            public void actionPerformed(ActionEvent e) {
                table.setSortable(!table.isSortable());
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(table, "ToggleSortingEnabled Test");
        this.addAction(frame, toggleSortableAction);
        frame.setVisible(true);
    }

    public void interactiveTestTableSizing1() {
        JXTable table = new JXTable();
        table.setAutoCreateColumnsFromModel(false);
        table.setModel(this.tableModel);
        table.setAutoResizeMode(0);
        TableColumnExt[] columns = new TableColumnExt[this.tableModel.getColumnCount()];
        int i = 0;
        while (i < columns.length) {
            columns[i] = new TableColumnExt(i);
            table.addColumn(columns[i]);
            ++i;
        }
        columns[0].setPrototypeValue(new Integer(0));
        columns[1].setPrototypeValue("Simple String Value");
        columns[2].setPrototypeValue(new Integer(1000));
        columns[3].setPrototypeValue(Boolean.TRUE);
        columns[4].setPrototypeValue(new Date(100L));
        columns[5].setPrototypeValue(new Float(1.5));
        columns[6].setPrototypeValue(new LinkModel("Sun Micro", "_blank", this.tableModel.linkURL));
        columns[7].setPrototypeValue(new Integer(3023));
        columns[8].setPrototypeValue("John Doh");
        columns[9].setPrototypeValue("23434 Testcase St");
        columns[10].setPrototypeValue(new Integer(33333));
        columns[11].setPrototypeValue(Boolean.FALSE);
        table.setVisibleRowCount(12);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableSizing1 Test");
        frame.setVisible(true);
    }

    public void interactiveTestEmptyTableSizing() {
        JXTable table = new JXTable(0, 5);
        table.setColumnControlVisible(true);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "Empty Table (0 rows)");
        frame.setVisible(true);
    }

    public void interactiveTestTableSizing2() {
        JXTable table = new JXTable();
        table.setAutoCreateColumnsFromModel(false);
        table.setModel(this.tableModel);
        TableColumnExt[] columns = new TableColumnExt[6];
        int viewIndex = 0;
        int i = columns.length - 1;
        while (i >= 0) {
            columns[viewIndex] = new TableColumnExt(i);
            table.addColumn(columns[viewIndex++]);
            --i;
        }
        columns[5].setHeaderValue("String Value");
        columns[5].setPrototypeValue("9999");
        columns[4].setHeaderValue("String Value");
        columns[4].setPrototypeValue("Simple String Value");
        columns[3].setHeaderValue("Int Value");
        columns[3].setPrototypeValue(new Integer(1000));
        columns[2].setHeaderValue("Bool");
        columns[2].setPrototypeValue(Boolean.FALSE);
        columns[1].setHeaderValue("Date");
        columns[1].setPrototypeValue(new Date(0L));
        columns[0].setHeaderValue("Float");
        columns[0].setPrototypeValue(new Float(5.5));
        table.setRowHeight(24);
        table.setRowMargin(2);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableSizing2 Test");
        frame.setVisible(true);
    }

    public void interactiveTestTableAlternateHighlighter1() {
        JXTable table = new JXTable(this.tableModel);
        table.setRolloverEnabled(true);
        table.setRowHeight(22);
        table.setRowMargin(1);
        table.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(0, true)}));
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.linePrinter, new RolloverHighlighter(Color.YELLOW, null)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "LinePrinter plus yellow rollover");
        frame.setVisible(true);
    }

    public void interactiveTestTableAlternateRowHighlighter2() {
        JXTable table = new JXTable(this.tableModel);
        table.setRowHeight(22);
        table.setRowMargin(1);
        table.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(1, false)}));
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.classicLinePrinter}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "classic lineprinter Test");
        frame.setVisible(true);
    }

    public void interactiveTestTableSorter1() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.notePadBackground}));
        table.setBackground(new Color(255, 255, 204));
        table.setGridColor(Color.cyan.darker());
        table.setRowHeight(22);
        table.setRowMargin(1);
        table.setShowHorizontalLines(true);
        table.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(0, true), new ShuttleSorter(1, true)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableSorter1 col 0= asc, col 1 = asc");
        frame.setVisible(true);
    }

    public void interactiveTestTableSorter2() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setBackground(new Color(245, 255, 245));
        table.setGridColor(Color.cyan.darker());
        table.setRowHeight(22);
        table.setRowMargin(1);
        table.setShowHorizontalLines(true);
        table.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(0, true), new ShuttleSorter(1, false)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableSorter2 col 0 = asc, col 1 = desc");
        frame.setVisible(true);
    }

    public void interactiveTestFocusedCellBackground() {
        AncientSwingTeam model = new AncientSwingTeam(){

            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }
        };
        JXTable xtable = new JXTable(model);
        xtable.setBackground(Highlighter.notePadBackground.getBackground());
        JTable table = new JTable(model);
        table.setBackground(new Color(245, 255, 245));
        JXFrame frame = this.wrapWithScrollingInFrame(xtable, table, "Unselected focused background: JXTable/JTable");
        frame.setVisible(true);
    }

    public void interactiveTestTableSorter3() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{new Highlighter(Color.orange, null)}));
        table.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(1, true), new ShuttleSorter(0, false)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableSorter3 col 1 = asc, col 0 = desc");
        frame.setVisible(true);
    }

    public void interactiveTestTableSorter4() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{new Highlighter(Color.orange, null)}));
        table.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(0, false), new ShuttleSorter(1, true)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableSorter4 col 0 = des, col 1 = asc");
        frame.setVisible(true);
    }

    public void interactiveTestTablePatternFilter1() {
        JXTable table = new JXTable(this.tableModel);
        table.setIntercellSpacing(new Dimension(1, 1));
        table.setShowGrid(true);
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("^A", 0, 1)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TablePatternFilter1 Test");
        frame.setVisible(true);
    }

    public void interactiveTestTablePatternFilter2() {
        JXTable table = new JXTable(this.tableModel);
        table.setIntercellSpacing(new Dimension(2, 2));
        table.setShowGrid(true);
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("^S", 0, 1), new ShuttleSorter(0, false)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TablePatternFilter2 Test");
        frame.setVisible(true);
    }

    public void interactiveTestTablePatternFilter3() {
        JXTable table = new JXTable(this.tableModel);
        table.setShowGrid(true);
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("^S", 0, 1), new ShuttleSorter(1, false), new ShuttleSorter(0, false)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TablePatternFilter3 Test");
        frame.setVisible(true);
    }

    public void interactiveTestTablePatternFilter4() {
        JXTable table = new JXTable(this.tableModel);
        table.setIntercellSpacing(new Dimension(3, 3));
        table.setShowGrid(true);
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("^A", 0, 1), new ShuttleSorter(0, false)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TablePatternFilter4 Test");
        frame.setVisible(true);
    }

    public void interactiveTestTableSortedPatternFilterPatternHighlighter() {
        JXTable table = new JXTable(this.tableModel);
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("^S", 0, 1), new ShuttleSorter(0, false), new ShuttleSorter(1, true), new ShuttleSorter(3, false)}));
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{new PatternHighlighter(null, Color.red, "^S", 0, 1)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "PatternFilter/Highlighter ^S col1");
        frame.setVisible(true);
    }

    public void interactiveTestTableViewProperties() {
        JXTable table = new JXTable(this.tableModel);
        table.setIntercellSpacing(new Dimension(15, 15));
        table.setRowHeight(48);
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableViewProperties Test");
        frame.setVisible(true);
    }

    public void interactiveTestTablePatternHighlighter() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setColumnControlVisible(true);
        table.setIntercellSpacing(new Dimension(15, 15));
        table.setRowHeight(48);
        table.setRowHeight(0, 96);
        table.setShowGrid(true);
        table.setHighlighters(new HighlighterPipeline(new Highlighter[]{new PatternHighlighter(null, Color.red, "^A", 0, 1)}));
        JXFrame frame = this.wrapWithScrollingInFrame(table, "PatternHighlighter ^A col 1");
        frame.setVisible(true);
    }

    public void interactiveTestTableColumnProperties() {
        JXTable table = new JXTable();
        table.setModel(this.tableModel);
        table.getTableHeader().setBackground(Color.green);
        table.getTableHeader().setForeground(Color.magenta);
        table.getTableHeader().setFont(new Font("Serif", 0, 10));
        ColumnHeaderRenderer headerRenderer = ColumnHeaderRenderer.createColumnHeaderRenderer();
        headerRenderer.setHorizontalAlignment(2);
        headerRenderer.setBackground(Color.blue);
        headerRenderer.setForeground(Color.yellow);
        headerRenderer.setIcon(new Icon(){

            public int getIconWidth() {
                return 12;
            }

            public int getIconHeight() {
                return 12;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(Color.red);
                g.fillOval(0, 0, 10, 10);
            }
        });
        headerRenderer.setIconTextGap(20);
        headerRenderer.setFont(new Font("Serif", 1, 18));
        int i = 0;
        while (i < table.getColumnCount()) {
            TableCellRenderer cellRenderer;
            TableColumnExt column = table.getColumnExt(i);
            if (i % 3 > 0) {
                column.setHeaderRenderer(headerRenderer);
            }
            if (i % 2 > 0 && ((cellRenderer = table.getNewDefaultRenderer(table.getColumnClass(i))) instanceof JLabel || cellRenderer instanceof AbstractButton)) {
                JComponent labelCellRenderer = (JComponent)((Object)cellRenderer);
                labelCellRenderer.setBackground(Color.gray);
                labelCellRenderer.setForeground(Color.red);
                if (cellRenderer instanceof JLabel) {
                    ((JLabel)labelCellRenderer).setHorizontalAlignment(0);
                } else {
                    ((AbstractButton)labelCellRenderer).setHorizontalAlignment(0);
                }
                column.setCellRenderer(cellRenderer);
            }
            ++i;
        }
        JXFrame frame = this.wrapWithScrollingInFrame(table, "TableColumnProperties Test");
        frame.setVisible(true);
    }

    public void testDummy() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Car
    implements Comparable<Car> {
        float speed = 100.0f;

        public Car(float speed) {
            this.speed = speed;
        }

        @Override
        public int compareTo(Car o) {
            return this.speed < o.speed ? -1 : (this.speed > o.speed ? 1 : 0);
        }

        public String toString() {
            return "Car - " + this.speed;
        }
    }

    public class Porsche
    extends Car {
        boolean hasBridgeStone;

        public Porsche(float speed) {
            super(speed);
            this.hasBridgeStone = true;
        }

        public Porsche(float speed, boolean bridgeStone) {
            this(speed);
            this.hasBridgeStone = bridgeStone;
        }

        public int compareTo(Car o) {
            if (o instanceof Porsche) {
                return ((Porsche)o).hasBridgeStone ? 0 : 1;
            }
            return super.compareTo(o);
        }

        public String toString() {
            return "Porsche - " + this.speed + (this.hasBridgeStone ? "+" : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Tractor
    implements Comparable<Tractor> {
        float speed = 20.0f;

        public Tractor(float speed) {
            this.speed = speed;
        }

        @Override
        public int compareTo(Tractor o) {
            return this.speed < o.speed ? -1 : (this.speed > o.speed ? 1 : 0);
        }

        public String toString() {
            return "Tractor - " + this.speed;
        }
    }

    public class ClassComparator
    implements Comparator {
        List packageOrder;
        int sortIndex;

        public ClassComparator(int index) {
            this.sortIndex = index;
        }

        public int compare(Object o1, Object o2) {
            String[] value1 = String.valueOf(o1).split(":");
            String[] value2 = String.valueOf(o2).split(":");
            String part1 = value1.length > this.sortIndex ? value1[this.sortIndex] : "";
            String part2 = value2.length > this.sortIndex ? value2[this.sortIndex] : "";
            return part1.compareTo(part2);
        }
    }
}

