/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.LinkRenderer;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.ShuttleSorter;
import org.jdesktop.swingx.decorator.Sorter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.util.AncientSwingTeam;

public class JXTableUnitTest
extends InteractiveTestCase {
    private static final Logger LOG = Logger.getLogger(JXTableUnitTest.class.getName());
    protected DynamicTableModel tableModel = null;
    protected TableModel sortableTableModel;
    private boolean defaultToSystemLF;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;

    public JXTableUnitTest() {
        super("JXTable unit test");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.tableModel == null) {
            this.tableModel = new DynamicTableModel();
        }
        this.sortableTableModel = new AncientSwingTeam();
        this.defaultToSystemLF = false;
        JXTableUnitTest.setSystemLF(this.defaultToSystemLF);
    }

    public void testUpdateRendererOnLFChange() {
        LinkRenderer comparison = new LinkRenderer();
        LinkRenderer linkRenderer = new LinkRenderer();
        JXTable table = new JXTable(2, 3);
        Component comparisonComponent = comparison.getTableCellEditorComponent(table, null, false, 0, 0);
        Font comparisonFont = comparisonComponent.getFont();
        table.getColumnModel().getColumn(0).setCellRenderer(linkRenderer);
        JXTableUnitTest.setSystemLF(!this.defaultToSystemLF);
        SwingUtilities.updateComponentTreeUI(comparisonComponent);
        if (comparisonFont.equals(comparisonComponent.getFont())) {
            LOG.info("cannot run test - equal font " + comparisonFont);
            return;
        }
        SwingUtilities.updateComponentTreeUI(table);
        Component rendererComp = table.prepareRenderer(table.getCellRenderer(0, 0), 0, 0);
        JXTableUnitTest.assertEquals((String)"renderer font must be updated", (Object)comparisonComponent.getFont(), (Object)rendererComp.getFont());
    }

    public void testLinkControllerListening() {
        JXTable table = new JXTable();
        table.setRolloverEnabled(true);
        JXTableUnitTest.assertNotNull((String)"LinkController must be listening", (Object)this.getLinkControllerAsPropertyChangeListener(table));
        JXTableUnitTest.assertNotNull((String)"execute button action must be registered", (Object)table.getActionMap().get("executeButtonAction"));
        table.setRolloverEnabled(false);
        JXTableUnitTest.assertNull((String)"LinkController must not be listening", (Object)this.getLinkControllerAsPropertyChangeListener(table));
        JXTableUnitTest.assertNull((String)"execute button action must be de-registered", (Object)table.getActionMap().get("executeButtonAction"));
    }

    private PropertyChangeListener getLinkControllerAsPropertyChangeListener(JXTable table) {
        PropertyChangeListener[] listeners = table.getPropertyChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof JXTable.LinkController) {
                return (JXTable.LinkController)listeners[i];
            }
            ++i;
        }
        return null;
    }

    public void testHighlighterHiddenTestColumn() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.getColumnExt(0).setVisible(false);
        PatternHighlighter highlighter = new PatternHighlighter(null, Color.RED, "a", 0, 0);
        ComponentAdapter adapter = table.getComponentAdapter();
        adapter.row = 0;
        adapter.column = 0;
        ((Highlighter)highlighter).highlight(new JLabel(), adapter);
    }

    public void testSelectionListenerNotification() {
        final JXTable table = new JXTable(this.createAscendingModel(0, 20));
        boolean modelRow = false;
        table.setRowSelectionInterval(0, 0);
        ListSelectionListener l = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int viewRow = table.getSelectedRow();
                JXTableUnitTest.assertTrue((String)"view index visible", (viewRow >= 0 ? 1 : 0) != 0);
                table.convertRowIndexToModel(viewRow);
            }
        };
        table.getSelectionModel().addListSelectionListener(l);
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("0", 0, 0)}));
    }

    public void testHideShowLastColumns() {
        JXTable table = new JXTable(10, 3);
        TableColumnExt ext = table.getColumnExt(2);
        int i = table.getModel().getColumnCount() - 1;
        while (i > 0) {
            table.getColumnExt(i).setVisible(false);
            --i;
        }
        ext.setVisible(true);
    }

    public void testConserveVerticalScrollBarPolicy() {
        if (GraphicsEnvironment.isHeadless()) {
            LOG.info("cannot run conserveVerticalScrollBarPolicy - headless environment");
            return;
        }
        JXTable table = new JXTable(0, 3);
        JScrollPane scrollPane1 = new JScrollPane(table);
        scrollPane1.setVerticalScrollBarPolicy(22);
        JXFrame frame = new JXFrame();
        frame.add(scrollPane1);
        frame.setSize(500, 400);
        frame.setVisible(true);
        JXTableUnitTest.assertEquals((String)"vertical scrollbar policy must be always", (int)22, (int)scrollPane1.getVerticalScrollBarPolicy());
    }

    public void testEnableRowHeight() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        table.setRowHeight(0, 25);
        JXTableUnitTest.assertEquals((String)"indy row height must not be set if disabled", (int)table.getRowHeight(), (int)table.getRowHeight(0));
        table.setRowHeightEnabled(true);
        JXTableUnitTest.assertEquals((String)"indy row height must not be set on setting enabled", (int)table.getRowHeight(), (int)table.getRowHeight(0));
        table.setRowHeight(0, 25);
        JXTableUnitTest.assertEquals((int)25, (int)table.getRowHeight(0));
        table.setRowHeightEnabled(false);
        JXTableUnitTest.assertEquals((String)"indy row height must not be set if disabled", (int)table.getRowHeight(), (int)table.getRowHeight(0));
    }

    public void testIndividualRowHeightAfterSetModel() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        table.setRowHeightEnabled(true);
        table.setRowHeight(0, 25);
        JXTableUnitTest.assertEquals((int)25, (int)table.getRowHeight(0));
        table.setModel(this.sortableTableModel);
        JXTableUnitTest.assertEquals((String)"individual rowheight must be reset", (int)table.getRowHeight(), (int)table.getRowHeight(0));
    }

    public void testIndividualRowHeight() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        table.setRowHeightEnabled(true);
        table.setRowHeight(0, 25);
        JXTableUnitTest.assertEquals((int)25, (int)table.getRowHeight(0));
        JXTableUnitTest.assertEquals((int)table.getRowHeight(), (int)table.getRowHeight(1));
        table.getFilters().setSorter(new ShuttleSorter(0, false));
        JXTableUnitTest.assertEquals((int)table.getRowHeight(), (int)table.getRowHeight(1));
        JXTableUnitTest.assertEquals((int)25, (int)table.getRowHeight(table.getRowCount() - 1));
        table.setRowHeight(table.getRowHeight());
        JXTableUnitTest.assertEquals((int)table.getRowHeight(), (int)table.getRowHeight(table.getRowCount() - 1));
    }

    public void testResetIndividualRowHeight() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        table.setRowHeightEnabled(true);
        table.setRowHeight(0, 25);
        table.getFilters().setSorter(new ShuttleSorter(0, false));
        JXTableUnitTest.assertEquals((String)"individual row height must be moved to last row", (int)25, (int)table.getRowHeight(table.getRowCount() - 1));
        table.setRowHeight(table.getRowHeight());
        JXTableUnitTest.assertEquals((String)"individual row height must be reset", (int)table.getRowHeight(), (int)table.getRowHeight(table.getRowCount() - 1));
    }

    public void testRowModelAccess() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setRowHeight(0, 25);
    }

    public void testRespectPatternInSearch() {
        JXTable table = new JXTable(this.createAscendingModel(0, 11));
        int row = 1;
        String lastName = table.getValueAt(row, 0).toString();
        Pattern strict = Pattern.compile("^" + lastName + "$");
        int found = table.getSearchable().search(strict, -1, false);
        JXTableUnitTest.assertEquals((String)"found must be equal to row", (int)row, (int)found);
        found = table.getSearchable().search(strict, found, false);
        JXTableUnitTest.assertEquals((String)"search must fail", (int)-1, (int)found);
    }

    public void testSetNullFilters() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setRowSelectionInterval(0, 0);
        table.setFilters(null);
        JXTableUnitTest.assertEquals((String)"selected row must be unchanged", (int)0, (int)table.getSelectedRow());
    }

    public void testInteractiveSorterOnModelChange() {
        JXTable table = new JXTable(this.sortableTableModel);
        int columnCount = table.getColumnCount();
        table.setSorter(columnCount - 1);
        table.setModel(new DefaultTableModel(10, columnCount - 1));
        JXTableUnitTest.assertEquals(null, (Object)table.getFilters().getSorter());
    }

    public void testSorterToPipeline() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setSorter(0);
        TableColumnExt columnX = table.getColumnExt(0);
        JXTableUnitTest.assertEquals((String)"interactive sorter must be same as sorter in column", (Object)columnX.getSorter(), (Object)table.getFilters().getSorter());
        table.resetSorter();
        JXTableUnitTest.assertEquals((String)"interactive sorter must be null", null, (Object)table.getFilters().getSorter());
    }

    public void testSorterAfterColumnRemoved() {
        JXTable table = new JXTable(this.sortableTableModel);
        TableColumnExt columnX = table.getColumnExt(0);
        table.setSorter(0);
        table.removeColumn(columnX);
        JXTableUnitTest.assertEquals((String)"sorter must be removed when column removed", null, (Object)table.getFilters().getSorter());
    }

    public void testSorterAfterColumnHidden() {
        JXTable table = new JXTable(this.sortableTableModel);
        TableColumnExt columnX = table.getColumnExt(0);
        table.setSorter(0);
        columnX.setVisible(false);
        JXTableUnitTest.assertEquals((String)"interactive sorter must be same as sorter in column", (Object)columnX.getSorter(), (Object)table.getFilters().getSorter());
    }

    public void testRemoveAllColumns() {
        JXTable table = new JXTable(this.sortableTableModel);
        TableColumnExt columnX = table.getColumnExt(0);
        columnX.setVisible(false);
        table.removeColumns();
        JXTableUnitTest.assertEquals((String)"all columns must have been removed", (int)table.getColumnCount(), (int)table.getColumnCount(true));
    }

    public void testRemoveAllColumsAfterModelChanged() {
        JXTable table = new JXTable(this.sortableTableModel);
        TableColumnExt columnX = table.getColumnExt(0);
        columnX.setVisible(false);
        table.setModel(new DefaultTableModel());
        JXTableUnitTest.assertEquals((String)"all columns must have been removed", (int)0, (int)table.getColumnCount(true));
        JXTableUnitTest.assertEquals((String)"all columns must have been removed", (int)table.getColumnCount(), (int)table.getColumnCount(true));
        JXTableUnitTest.assertEquals((String)"sorter must be removed when column removed", null, (Object)table.getFilters().getSorter());
    }

    public void testColumnExt() {
        JXTable table = new JXTable(this.sortableTableModel);
        Object zeroName = table.getColumnModel().getColumn(0).getIdentifier();
        Object oneName = table.getColumnModel().getColumn(1).getIdentifier();
        TableColumn column = table.getColumn(zeroName);
        ((TableColumnExt)column).setVisible(false);
        try {
            table.getColumn(zeroName);
            JXTableUnitTest.fail((String)"table.getColumn(identifier) guarantees to fail if identifier is unknown or column is hidden");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TableColumnExt columnZero = table.getColumnExt(zeroName);
        JXTableUnitTest.assertNotNull((Object)columnZero);
        int viewIndexZero = table.convertColumnIndexToView(columnZero.getModelIndex());
        JXTableUnitTest.assertTrue((String)"viewIndex must be negative for invisible", (viewIndexZero < 0 ? 1 : 0) != 0);
        JXTableUnitTest.assertEquals((boolean)columnZero.isVisible(), (viewIndexZero >= 0 ? 1 : 0) != 0);
        TableColumnExt columnOne = table.getColumnExt(oneName);
        JXTableUnitTest.assertNotNull((Object)columnOne);
        int viewIndexOne = table.convertColumnIndexToView(columnOne.getModelIndex());
        JXTableUnitTest.assertTrue((String)"viewIndex must be positive for visible", (viewIndexOne >= 0 ? 1 : 0) != 0);
        JXTableUnitTest.assertEquals((boolean)columnOne.isVisible(), (viewIndexOne >= 0 ? 1 : 0) != 0);
    }

    public void testMixedComparableTypes() {
        Object[][] rowData = new Object[][]{{Boolean.TRUE, new Integer(2)}, {Boolean.TRUE, "BC"}};
        Object[] columnNames = new String[]{"Critical", "Task"};
        DefaultTableModel model = new DefaultTableModel(rowData, columnNames);
        JXTable table = new JXTable(model);
        table.setSorter(1);
    }

    public void testMixedComparableTypesWithNonComparable() {
        Object[][] rowData = new Object[][]{{Boolean.TRUE, new Integer(2)}, {Boolean.TRUE, new Object()}};
        Object[] columnNames = new String[]{"Critical", "Task"};
        DefaultTableModel model = new DefaultTableModel(rowData, columnNames);
        JXTable table = new JXTable(model);
        table.setSorter(1);
    }

    public void testIncrementalSearch() {
        JXTable table = new JXTable(this.createAscendingModel(10, 10));
        int row = 0;
        String ten = table.getValueAt(row, 0).toString();
        JXTableUnitTest.assertEquals((String)"10", (String)ten);
        int found = table.getSearchable().search("1", -1);
        JXTableUnitTest.assertEquals((String)"must have found first row", (int)row, (int)found);
        int second = table.getSearchable().search("10", found);
        JXTableUnitTest.assertEquals((String)"must have found incrementally at same position", (int)found, (int)second);
    }

    public void testBackwardSearch() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        int row = 1;
        String lastName = table.getValueAt(row, 0).toString();
        int found = table.getSearchable().search(Pattern.compile(lastName), -1, true);
        JXTableUnitTest.assertEquals((int)row, (int)found);
    }

    public void testFilterUpdateKeepsSorter() {
        int rowCount = 20;
        int firstValue = 0;
        JXTable table = new JXTable(this.createAscendingModel(firstValue, rowCount));
        table.setSorter(0);
        table.setSorter(0);
        Object value = table.getValueAt(0, 0);
        JXTableUnitTest.assertEquals((String)"highest value", (Object)value, (Object)(firstValue + rowCount - 1));
        PatternFilter filter = new PatternFilter(".*", 0, 0);
        table.setFilters(new FilterPipeline(new Filter[]{filter}));
        JXTableUnitTest.assertEquals((String)"highest value unchanged", (Object)value, (Object)table.getValueAt(0, 0));
        filter.setPattern("^1", 0);
        JXTableUnitTest.assertTrue((String)"sorter must be active", ((Integer)table.getValueAt(0, 0) > (Integer)table.getValueAt(1, 0) ? 1 : 0) != 0);
    }

    public void testRegisterUniquePipelineListener() {
        JXTable table = new JXTable();
        PatternFilter noFilter = new PatternFilter(".*", 0, 1);
        table.setFilters(new FilterPipeline(new Filter[]{noFilter}));
        int listenerCount = table.getFilters().getPipelineListeners().length;
        table.setModel(this.createAscendingModel(0, 20));
        JXTableUnitTest.assertEquals((String)"pipeline listener count must not change after setModel", (int)listenerCount, (int)table.getFilters().getPipelineListeners().length);
    }

    public void testLeadFocusCell() {
        if (GraphicsEnvironment.isHeadless()) {
            LOG.info("cannot run leadFocusCell - headless environment");
            return;
        }
        final JXTable table = new JXTable();
        table.setModel(this.createAscendingModel(0, 10));
        final JXFrame frame = new JXFrame();
        frame.add(table);
        frame.pack();
        frame.setVisible(true);
        table.requestFocus();
        table.addRowSelectionInterval(table.getRowCount() - 2, table.getRowCount() - 1);
        final int leadRow = table.getSelectionModel().getLeadSelectionIndex();
        int anchorRow = table.getSelectionModel().getAnchorSelectionIndex();
        table.addColumnSelectionInterval(0, 0);
        final int leadColumn = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        int anchorColumn = table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        JXTableUnitTest.assertEquals((String)"lead must be last row", (int)(table.getRowCount() - 1), (int)leadRow);
        JXTableUnitTest.assertEquals((String)"anchor must be second last row", (int)(table.getRowCount() - 2), (int)anchorRow);
        JXTableUnitTest.assertEquals((String)"lead must be first column", (int)0, (int)leadColumn);
        JXTableUnitTest.assertEquals((String)"anchor must be first column", (int)0, (int)anchorColumn);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentAdapter adapter = table.getComponentAdapter();
                adapter.row = leadRow;
                adapter.column = leadColumn;
                try {
                    JXTableUnitTest.assertTrue((String)("adapter must have focus for leadRow/Column: " + adapter.row + "/" + adapter.column), (boolean)adapter.hasFocus());
                }
                finally {
                    frame.dispose();
                }
            }
        });
    }

    public void testSelectionOnSorterRefresh() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        table.setSorter(0);
        Sorter sorter = table.getSorter(0);
        JXTableUnitTest.assertTrue((boolean)sorter.isAscending());
        table.setRowSelectionInterval(0, 0);
        sorter.setAscending(false);
        JXTableUnitTest.assertEquals((String)"last row must be selected", (int)(table.getRowCount() - 1), (int)table.getSelectedRow());
    }

    public void testSelectionAndToggleModel() {
        JXTable table = new JXTable();
        table.setModel(this.createAscendingModel(0, 10));
        table.setSorter(0);
        table.addRowSelectionInterval(table.getRowCount() - 2, table.getRowCount() - 1);
        table.setSorter(0);
        table.setModel(this.createAscendingModel(0, 8));
    }

    public void testSelectionAndAddRows() {
        JXTable table = new JXTable();
        DefaultTableModel model = this.createAscendingModel(0, 10);
        table.setModel(model);
        table.setSorter(0);
        table.addRowSelectionInterval(table.getRowCount() - 2, table.getRowCount() - 1);
        table.setSorter(0);
        Integer highestValue = new Integer(100);
        model.addRow(new Object[]{highestValue});
        JXTableUnitTest.assertEquals((Object)highestValue, (Object)table.getValueAt(0, 0));
    }

    public void testSelectionRemoveRowsReselect() {
        JXTable table = new JXTable();
        DefaultTableModel model = this.createAscendingModel(0, 10);
        table.setModel(model);
        table.setSorter(0);
        table.setSorter(0);
        int modelLast = table.getRowCount() - 1;
        table.setRowSelectionInterval(modelLast, modelLast);
        model.removeRow(table.convertRowIndexToModel(modelLast));
        table.setRowSelectionInterval(table.getRowCount() - 1, table.getRowCount() - 1);
    }

    public void testSelectionAndRemoveRows() {
        JXTable table = new JXTable();
        DefaultTableModel model = this.createAscendingModel(0, 10);
        table.setModel(model);
        table.setSorter(0);
        table.addRowSelectionInterval(table.getRowCount() - 2, table.getRowCount() - 1);
        table.setSorter(0);
        model.removeRow(0);
    }

    public void testDeleteRowAboveIndividualRowHeight() {
        DefaultTableModel model = this.createAscendingModel(0, 10);
        JXTable table = new JXTable(model);
        table.setRowHeightEnabled(true);
        int selectedRow = table.getRowCount() - 1;
        table.setRowHeight(selectedRow, 25);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"last row is individual", (int)25, (int)table.getRowHeight(selectedRow));
        model.removeRow(0);
        JXTableUnitTest.assertEquals((String)"last row is individual", (int)25, (int)table.getRowHeight(selectedRow - 1));
    }

    public void testDeleteRowAboveSelection() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = table.getRowCount() - 1;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"last row must be selected", (int)selectedRow, (int)table.getSelectedRow());
        ascendingModel.removeRow(0);
        JXTableUnitTest.assertEquals((String)"last row must still be selected after remove be selected", (int)(table.getRowCount() - 1), (int)table.getSelectedRow());
    }

    public void testAddRowAboveSelection() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = table.getRowCount() - 1;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        JXTableUnitTest.assertEquals((String)"last row must be selected", (int)selectedRow, (int)table.getSelectedRow());
        ascendingModel.insertRow(0, new Object[table.getColumnCount()]);
        JXTableUnitTest.assertEquals((String)"last row must still be selected after add above", (int)(table.getRowCount() - 1), (int)table.getSelectedRow());
    }

    public void testAddRowAboveIndividualRowHeigh() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        table.setRowHeightEnabled(true);
        int selectedRow = table.getRowCount() - 1;
        table.setRowHeight(selectedRow, 25);
        JXTableUnitTest.assertEquals((String)"last row must have indy rowheight", (int)25, (int)table.getRowHeight(selectedRow));
        ascendingModel.insertRow(0, new Object[table.getColumnCount()]);
        JXTableUnitTest.assertEquals((String)"last row must still have indy rowheight after add above", (int)25, (int)table.getRowHeight(selectedRow + 1));
    }

    public void testAddRowAboveSelectionInvertedOrder() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = table.getRowCount() - 1;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        table.setSorter(0);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"first row must be selected", (int)0, (int)table.getSelectedRow());
        Object[] row = new Integer[table.getColumnCount()];
        row[0] = new Integer(100);
        ascendingModel.addRow(row);
        JXTableUnitTest.assertEquals((String)"selection must be incremented by one ", (int)1, (int)table.getSelectedRow());
    }

    public void testAddRowAboveIndividualRowHeightInvertedOrder() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        table.setRowHeightEnabled(true);
        int selectedRow = table.getRowCount() - 1;
        table.setRowHeight(selectedRow, 25);
        table.setSorter(0);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"first row must have indy rowheight", (int)25, (int)table.getRowHeight(0));
        Object[] row = new Integer[table.getColumnCount()];
        row[0] = new Integer(100);
        ascendingModel.addRow(row);
        JXTableUnitTest.assertEquals((String)"row with indy height must be incremented by one ", (int)25, (int)table.getRowHeight(1));
    }

    public void testDeleteRowAboveSelectionInvertedOrder() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = table.getRowCount() - 1;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        table.setSorter(0);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"first row must be selected", (int)0, (int)table.getSelectedRow());
        ascendingModel.removeRow(0);
        JXTableUnitTest.assertEquals((String)"first row must still be selected after remove ", (int)0, (int)table.getSelectedRow());
    }

    public void testDeleteRowBelowSelection() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = 0;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"first row must be selected", (int)selectedRow, (int)table.getSelectedRow());
        ascendingModel.removeRow(selectedRow + 1);
        JXTableUnitTest.assertEquals((String)"first row must still be selected after remove", (int)selectedRow, (int)table.getSelectedRow());
    }

    public void testDeleteRowBelowSelectionInvertedOrder() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = 0;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        table.setSorter(0);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"last row must be selected", (int)(table.getRowCount() - 1), (int)table.getSelectedRow());
        ascendingModel.removeRow(selectedRow + 1);
        JXTableUnitTest.assertEquals((String)"last row must still be selected after remove", (int)(table.getRowCount() - 1), (int)table.getSelectedRow());
    }

    public void testDeleteLastRowInSelection() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = 0;
        int lastSelectedRow = 1;
        table.setRowSelectionInterval(selectedRow, lastSelectedRow);
        table.setSorter(0);
        int[] selectedRows = table.getSelectedRows();
        int i = selectedRow;
        while (i <= lastSelectedRow) {
            JXTableUnitTest.assertEquals((String)("row must be selected " + i), (int)i, (int)selectedRows[i]);
            ++i;
        }
        ascendingModel.removeRow(lastSelectedRow);
        int[] selectedRowsAfter = table.getSelectedRows();
        int i2 = selectedRow;
        while (i2 < lastSelectedRow) {
            JXTableUnitTest.assertEquals((String)("row must be selected " + i2), (int)i2, (int)selectedRowsAfter[i2]);
            ++i2;
        }
        JXTableUnitTest.assertFalse((String)("removed row must not be selected " + lastSelectedRow), (boolean)table.isRowSelected(lastSelectedRow));
    }

    protected DefaultTableModel createAscendingModel(int startRow, int count) {
        DefaultTableModel model = new DefaultTableModel(count, 4){

            public Class getColumnClass(int column) {
                return column == 0 ? Integer.class : super.getColumnClass(column);
            }
        };
        int i = 0;
        while (i < model.getRowCount()) {
            model.setValueAt(new Integer(startRow++), i, 0);
            ++i;
        }
        return model;
    }

    public void testSortable() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        boolean sortable = table.isSortable();
        JXTableUnitTest.assertTrue((String)"JXTable sortable defaults to true", (boolean)sortable);
        table.setSorter(0);
        Object first = table.getValueAt(0, 0);
        table.setSortable(false);
        JXTableUnitTest.assertFalse((boolean)table.isSortable());
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"sorting on a non-sortable table must do nothing", (Object)first, (Object)table.getValueAt(0, 0));
    }

    public void testSortedEditability() {
        int rows = 2;
        RowObjectTableModel model = this.createRowObjectTableModel(rows);
        JXTable table = new JXTable(model);
        RowObject firstInModel = model.getRowObject(0);
        JXTableUnitTest.assertEquals((String)"rowObject data must be equal", (Object)firstInModel.getData1(), (Object)table.getValueAt(0, 0));
        JXTableUnitTest.assertEquals((String)"rowObject editability must be equal", (boolean)firstInModel.isEditable(), (boolean)table.isCellEditable(0, 0));
        table.setSorter(0);
        Object firstDataValueInTable = table.getValueAt(0, 0);
        boolean firstEditableValueInTable = table.isCellEditable(0, 0);
        JXTableUnitTest.assertEquals((String)"rowObject data must be equal", (Object)firstInModel.getData1(), (Object)table.getValueAt(0, 0));
        JXTableUnitTest.assertEquals((String)"rowObject editability must be equal", (boolean)firstInModel.isEditable(), (boolean)table.isCellEditable(0, 0));
        JXTableUnitTest.assertTrue((String)"lastValue different from first", (firstDataValueInTable != table.getValueAt(rows - 1, 0) ? 1 : 0) != 0);
        JXTableUnitTest.assertTrue((String)"lastEditability different from first", (firstEditableValueInTable != table.isCellEditable(rows - 1, 0) ? 1 : 0) != 0);
        table.setSorter(0);
        JXTableUnitTest.assertEquals((String)"last row data must be equal to former first", (Object)firstDataValueInTable, (Object)table.getValueAt(rows - 1, 0));
        JXTableUnitTest.assertEquals((String)"last row editability must be equal to former first", (boolean)firstEditableValueInTable, (boolean)table.isCellEditable(rows - 1, 0));
    }

    public void testFilteredEditability() {
        int rows = 2;
        RowObjectTableModel model = this.createRowObjectTableModel(rows);
        JXTable table = new JXTable(model);
        int i = 0;
        while (i < table.getRowCount()) {
            JXTableUnitTest.assertEquals((String)("even/uneven rows must be editable/notEditable " + i), (i % 2 == 0 ? 1 : 0) != 0, (boolean)table.isCellEditable(i, 0));
            ++i;
        }
        PatternFilter filter = new PatternFilter("^NOT", 0, 1);
        PatternFilter noFilter = new PatternFilter(".*", 0, 1);
        table.setFilters(new FilterPipeline(new Filter[]{noFilter, filter}));
        JXTableUnitTest.assertEquals((String)"row count is half", (int)(rows / 2), (int)table.getRowCount());
        int i2 = 0;
        while (i2 < table.getRowCount()) {
            JXTableUnitTest.assertFalse((String)("all rows must be not-editable " + i2), (boolean)table.isCellEditable(i2, 0));
            ++i2;
        }
    }

    private RowObjectTableModel createRowObjectTableModel(int rows) {
        ArrayList<RowObject> rowObjects = new ArrayList<RowObject>();
        int i = 0;
        while (i < rows) {
            rowObjects.add(new RowObject("somedata" + i, i % 2 == 0));
            ++i;
        }
        return new RowObjectTableModel(rowObjects);
    }

    public void testToggleFiltersWhileSorting() {
        Object[][] rowData = new Object[][]{{Boolean.TRUE, "AA"}, {Boolean.FALSE, "AB"}, {Boolean.FALSE, "AC"}, {Boolean.TRUE, "BA"}, {Boolean.FALSE, "BB"}, {Boolean.TRUE, "BC"}};
        Object[] columnNames = new String[]{"Critical", "Task"};
        JXTable table = new JXTable(rowData, columnNames);
        table.setFilters(this.createFilterPipeline(false, 1));
        table.setSorter(1);
        table.setFilters(this.createFilterPipeline(true, 1));
        table.setSorter(1);
    }

    public void testToggleFiltersWhileSortingLonger() {
        Object[][] rowData = new Object[][]{{Boolean.TRUE, "AA"}, {Boolean.FALSE, "AB"}, {Boolean.FALSE, "AC"}, {Boolean.TRUE, "BA"}, {Boolean.FALSE, "BB"}, {Boolean.TRUE, "BC"}};
        Object[] columnNames = new String[]{"Critical", "Task"};
        JXTable table = new JXTable(rowData, columnNames);
        table.setFilters(this.createFilterPipeline(false, 1));
        table.setSorter(0);
        table.setSorter(1);
        table.setFilters(this.createFilterPipeline(true, 1));
        table.setFilters(this.createFilterPipeline(false, 1));
        table.setSorter(0);
    }

    private FilterPipeline createFilterPipeline(boolean matchAll, int col) {
        PatternFilter filter = matchAll ? new PatternFilter(".*", 2, col) : new PatternFilter("^A", 2, col);
        return new FilterPipeline(new Filter[]{filter});
    }

    public void testRemoveFilterWhileSorting() {
        Object[][] rowData = new Object[][]{{Boolean.TRUE, "AA"}, {Boolean.FALSE, "AB"}, {Boolean.FALSE, "AC"}, {Boolean.TRUE, "BA"}, {Boolean.FALSE, "BB"}, {Boolean.TRUE, "BC"}};
        Object[] columnNames = new String[]{"Critical", "Task"};
        JXTable table = new JXTable(rowData, columnNames);
        int rows = table.getRowCount();
        table.setFilters(this.createFilterPipeline(false, 1));
        table.setSorter(1);
        table.setFilters(null);
        JXTableUnitTest.assertEquals((String)"rowCount must be original", (int)rows, (int)table.getRowCount());
        table.getValueAt(rows - 1, 0);
    }

    public void testLazyRenderersByClass() {
        JXTable table = new JXTable();
        JXTableUnitTest.assertEquals((String)"default Boolean renderer", JXTable.BooleanRenderer.class, table.getDefaultRenderer(Boolean.class).getClass());
        JXTableUnitTest.assertEquals((String)"default Number renderer", JXTable.NumberRenderer.class, table.getDefaultRenderer(Number.class).getClass());
        JXTableUnitTest.assertEquals((String)"default Double renderer", JXTable.DoubleRenderer.class, table.getDefaultRenderer(Double.class).getClass());
        JXTableUnitTest.assertEquals((String)"default Date renderer", JXTable.DateRenderer.class, table.getDefaultRenderer(Date.class).getClass());
        JXTableUnitTest.assertEquals((String)"default LinkModel renderer", LinkRenderer.class, table.getDefaultRenderer(LinkModel.class).getClass());
        JXTableUnitTest.assertEquals((String)"default Icon renderer", JXTable.IconRenderer.class, table.getDefaultRenderer(Icon.class).getClass());
    }

    public void testTableColumnsWithFilters() {
        JXTable table = new JXTable(this.tableModel);
        JXTableUnitTest.assertEquals((String)"table columns are equal to columns of model", (int)this.tableModel.getColumnCount(), (int)table.getColumnCount());
        TableColumnExt column = table.getColumnExt(0);
        table.removeColumn(column);
        int columnCountAfterRemove = table.getColumnCount();
        JXTableUnitTest.assertEquals((String)"table columns must be one less than columns of model", (int)(this.tableModel.getColumnCount() - 1), (int)columnCountAfterRemove);
        table.setFilters(new FilterPipeline(new Filter[]{new ShuttleSorter(1, false)}));
        JXTableUnitTest.assertEquals((String)"table columns must be unchanged after setting filter", (int)columnCountAfterRemove, (int)table.getColumnCount());
    }

    public void testColumnControlAndFilters() {
        JXTable table = new JXTable(this.sortableTableModel);
        table.setColumnControlVisible(true);
        PatternFilter filter = new PatternFilter("e", 0, 0);
        table.setFilters(new FilterPipeline(new Filter[]{filter}));
        table.getColumnExt(0).setVisible(false);
        table.setFilters(null);
    }

    static class RowObject {
        private String data1;
        private boolean editable;

        public RowObject(String data1, boolean editable) {
            this.data1 = data1;
            this.editable = editable;
        }

        public String getData1() {
            return this.data1;
        }

        public boolean isEditable() {
            return this.editable;
        }
    }

    static class RowObjectTableModel
    extends AbstractTableModel {
        List data;

        public RowObjectTableModel(List data) {
            this.data = data;
        }

        public RowObject getRowObject(int row) {
            return (RowObject)this.data.get(row);
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public Object getValueAt(int row, int col) {
            RowObject object = this.getRowObject(row);
            switch (col) {
                case 0: {
                    return object.getData1();
                }
                case 1: {
                    return object.isEditable() ? "EDITABLE" : "NOT EDITABLE";
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return this.getRowObject(row).isEditable();
        }
    }

    public static class DynamicTableModel
    extends AbstractTableModel {
        private Object[] columnSamples;
        private Object[] columnSamples2;
        public URL linkURL;
        public static final int IDX_COL_LINK = 6;

        public DynamicTableModel() {
            try {
                this.linkURL = new URL("http://www.sun.com");
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            this.columnSamples = new Object[12];
            this.columnSamples[0] = new Integer(0);
            this.columnSamples[1] = "Simple String Value";
            this.columnSamples[2] = new Integer(1000);
            this.columnSamples[3] = Boolean.TRUE;
            this.columnSamples[4] = new Date(100L);
            this.columnSamples[5] = new Float(1.5);
            this.columnSamples[6] = new LinkModel("Sun Micro", "_blank", this.linkURL);
            this.columnSamples[7] = new Integer(3023);
            this.columnSamples[8] = "John Doh";
            this.columnSamples[9] = "23434 Testcase St";
            this.columnSamples[10] = new Integer(33333);
            this.columnSamples[11] = Boolean.FALSE;
            this.columnSamples2 = new Object[12];
            this.columnSamples2[0] = new Integer(0);
            this.columnSamples2[1] = "Another String Value";
            this.columnSamples2[2] = new Integer(999);
            this.columnSamples2[3] = Boolean.FALSE;
            this.columnSamples2[4] = new Date(333L);
            this.columnSamples2[5] = new Float(22.22);
            this.columnSamples2[6] = new LinkModel("Sun Web", "new_frame", this.linkURL);
            this.columnSamples[7] = new Integer(5503);
            this.columnSamples[8] = "Jane Smith";
            this.columnSamples[9] = "2343 Table Blvd.";
            this.columnSamples[10] = new Integer(2);
            this.columnSamples[11] = Boolean.TRUE;
        }

        public DynamicTableModel(Object[] columnSamples) {
            this.columnSamples = columnSamples;
        }

        public Class getColumnClass(int column) {
            return this.columnSamples[column].getClass();
        }

        public int getRowCount() {
            return 1000;
        }

        public int getColumnCount() {
            return this.columnSamples.length;
        }

        public Object getValueAt(int row, int column) {
            Object value = row % 3 == 0 ? this.columnSamples[column] : this.columnSamples2[column];
            return column == 0 ? new Integer(row >> 3) : (column == 3 ? new Boolean(row % 2 == 0) : value);
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1) {
                if (row % 3 == 0) {
                    this.columnSamples[column] = aValue;
                } else {
                    this.columnSamples2[column] = aValue;
                }
            }
            this.fireTableDataChanged();
        }
    }
}

