/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.ShuttleSorter;

public class JXTableIssues
extends InteractiveTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JXTableIssues() {
        super("JXTableIssues");
    }

    public void testClearSelectionAndFilter() {
        JXTable table = new JXTable(this.createAscendingModel(0, 20));
        int modelRow = table.getRowCount() - 1;
        table.setRowSelectionInterval(modelRow, modelRow);
        table.clearSelection();
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("9", 0, 0)}));
        int viewRow = table.convertRowIndexToView(modelRow);
        JXTableIssues.assertTrue((String)"view index visible", (viewRow >= 0 ? 1 : 0) != 0);
        table.setRowSelectionInterval(viewRow, viewRow);
    }

    public void testSelectionAndRemoveRowOfMisbehavingModel() {
        DefaultTableModel model = new DefaultTableModel(10, 2){

            public void fireTableRowsDeleted(int firstRow, int lastRow) {
                this.fireTableStructureChanged();
            }
        };
        int i = 0;
        while (i < model.getRowCount()) {
            model.setValueAt(i, i, 0);
            ++i;
        }
        JXTable table = new JXTable(model);
        int modelRow = table.getRowCount() - 1;
        table.setSorter(0);
        table.setSorter(0);
        table.setRowSelectionInterval(modelRow, modelRow);
        model.removeRow(modelRow);
        int viewRow = table.convertRowIndexToView(table.getModel().getRowCount() - 1);
        JXTableIssues.assertTrue((String)"view index visible", (viewRow >= 0 ? 1 : 0) != 0);
        table.setRowSelectionInterval(viewRow, viewRow);
    }

    public void testKeepRowHeightOnUpdateAndEmptySelection() {
        JXTable table = new JXTable(10, 3);
        table.setRowHeightEnabled(true);
        JXTableIssues.assertTrue((String)"row height enabled", (boolean)table.isRowHeightEnabled());
        table.setRowHeight(0, 25);
        JXTableIssues.assertEquals((int)25, (int)table.getRowHeight(0));
        table.setValueAt("dummy", 1, 0);
        JXTableIssues.assertEquals((int)25, (int)table.getRowHeight(0));
        table.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("d", 0, 0)}));
        JXTableIssues.assertEquals((int)1, (int)table.getRowCount());
        table.setValueAt("otherdummy", 0, 1);
        table.setFilters(null);
        JXTableIssues.assertEquals((int)25, (int)table.getRowHeight(0));
    }

    public void testSelectionAfterDataChanged() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20, 5, false);
        JXTable table = new JXTable(ascendingModel);
        int selectedRow = table.getRowCount() - 1;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        JXTableIssues.assertEquals((String)"last row must be selected", (int)selectedRow, (int)table.getSelectedRow());
        ascendingModel.fireTableDataChanged();
        JXTableIssues.assertEquals((String)"selection must be cleared", (int)-1, (int)table.getSelectedRow());
    }

    public void testCoreTableSelectionAfterDataChanged() {
        DefaultTableModel ascendingModel = this.createAscendingModel(0, 20, 5, false);
        JTable table = new JTable(ascendingModel);
        int selectedRow = table.getRowCount() - 1;
        table.setRowSelectionInterval(selectedRow, selectedRow);
        JXTableIssues.assertEquals((String)"last row must be selected", (int)selectedRow, (int)table.getSelectedRow());
        ascendingModel.fireTableDataChanged();
        JXTableIssues.assertEquals((String)"selection must be cleared", (int)-1, (int)table.getSelectedRow());
    }

    public void testFilterInChainOnModelChange() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10, 5, true));
        int columnCount = table.getColumnCount();
        JXTableIssues.assertEquals((int)5, (int)columnCount);
        PatternFilter filter = new PatternFilter(".*", 0, columnCount - 1);
        FilterPipeline pipeline = new FilterPipeline(new Filter[]{filter});
        table.setFilters(pipeline);
        JXTableIssues.assertEquals((int)10, (int)pipeline.getOutputSize());
        table.setModel(new DefaultTableModel(10, columnCount - 1));
    }

    public void testSorterInChainOnModelChange() {
        JXTable table = new JXTable(new DefaultTableModel(10, 5));
        int columnCount = table.getColumnCount();
        ShuttleSorter sorter = new ShuttleSorter(columnCount - 1, false);
        FilterPipeline pipeline = new FilterPipeline(new Filter[]{sorter});
        table.setFilters(pipeline);
        table.setModel(new DefaultTableModel(10, columnCount - 1));
    }

    public void testComponentAdapterCoordinates() {
        JXTable table = new JXTable(this.createAscendingModel(0, 10));
        Object originalFirstRowValue = table.getValueAt(0, 0);
        Object originalLastRowValue = table.getValueAt(table.getRowCount() - 1, 0);
        JXTableIssues.assertEquals((String)"view row coordinate equals model row coordinate", (Object)table.getModel().getValueAt(0, 0), (Object)originalFirstRowValue);
        table.setSorter(0);
        JXTableIssues.assertEquals((String)"view order must be unchanged ", (Object)table.getValueAt(0, 0), (Object)originalFirstRowValue);
        table.setSorter(0);
        JXTableIssues.assertEquals((String)"view order must be reversed changed ", (Object)table.getValueAt(0, 0), (Object)originalLastRowValue);
        ComponentAdapter adapter = table.getComponentAdapter();
        JXTableIssues.assertEquals((String)"adapter filteredValue expects view coordinates", (Object)table.getValueAt(0, 0), (Object)adapter.getFilteredValueAt(0, 0));
        adapter.row = 0;
        adapter.column = 0;
        JXTableIssues.assertEquals((String)"adapter filteredValue expects view coordinates", (Object)table.getValueAt(0, 0), (Object)adapter.getValue());
    }

    public void testModifyTableContentAndSelection() {
        CompareTableBehaviour compare = new CompareTableBehaviour(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        compare.table.getSelectionModel().setSelectionInterval(2, 5);
        Object[] selectedObjects = new Object[]{"C", "D", "E", "F"};
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjects);
        compare.tableModel.setContents(new Object[]{"B", "C", "D", "F", "G", "H"});
        Object[] selectedObjectsAfterModify = new Object[]{"C", "D", "F"};
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjectsAfterModify);
    }

    public void testModifyXTableContentAndSelection() {
        CompareTableBehaviour compare = new CompareTableBehaviour(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        compare.xTable.getSelectionModel().setSelectionInterval(2, 5);
        Object[] selectedObjects = new Object[]{"C", "D", "E", "F"};
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjects);
        compare.tableModel.setContents(new Object[]{"B", "C", "D", "F", "G", "H"});
        Object[] selectedObjectsAfterModify = new Object[]{"C", "D", "F"};
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjectsAfterModify);
    }

    public void testDeleteRowAboveSelection() {
        CompareTableBehaviour compare = new CompareTableBehaviour(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        compare.table.getSelectionModel().setSelectionInterval(2, 5);
        compare.xTable.getSelectionModel().setSelectionInterval(2, 5);
        Object[] selectedObjects = new Object[]{"C", "D", "E", "F"};
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjects);
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjects);
        compare.tableModel.removeRow(0);
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjects);
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjects);
    }

    public void testDeleteRowBelowSelection() {
        CompareTableBehaviour compare = new CompareTableBehaviour(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        compare.table.getSelectionModel().setSelectionInterval(2, 5);
        compare.xTable.getSelectionModel().setSelectionInterval(2, 5);
        Object[] selectedObjects = new Object[]{"C", "D", "E", "F"};
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjects);
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjects);
        compare.tableModel.removeRow(compare.tableModel.getRowCount() - 1);
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjects);
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjects);
    }

    public void testDeleteLastRowInSelection() {
        CompareTableBehaviour compare = new CompareTableBehaviour(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        compare.table.getSelectionModel().setSelectionInterval(7, 8);
        compare.xTable.getSelectionModel().setSelectionInterval(7, 8);
        Object[] selectedObjects = new Object[]{"H", "I"};
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjects);
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjects);
        compare.tableModel.removeRow(compare.tableModel.getRowCount() - 1);
        Object[] selectedObjectsAfterDelete = new Object[]{"H"};
        this.assertSelection(compare.tableModel, compare.table.getSelectionModel(), selectedObjectsAfterDelete);
        this.assertSelection(compare.tableModel, compare.xTable.getSelectionModel(), selectedObjectsAfterDelete);
    }

    private void assertSelection(TableModel tableModel, ListSelectionModel selectionModel, Object[] expected) {
        ArrayList<Object> selected = new ArrayList<Object>();
        int r = 0;
        while (r < tableModel.getRowCount()) {
            if (selectionModel.isSelectedIndex(r)) {
                selected.add(tableModel.getValueAt(r, 0));
            }
            ++r;
        }
        List<Object> expectedList = Arrays.asList(expected);
        JXTableIssues.assertEquals((String)"selected Objects must be as expected", expectedList, selected);
    }

    public void interactiveDeleteRowAboveSelection() {
        CompareTableBehaviour compare = new CompareTableBehaviour(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        compare.table.getSelectionModel().setSelectionInterval(2, 5);
        compare.xTable.getSelectionModel().setSelectionInterval(2, 5);
        JComponent box = this.createContent(compare, this.createRowDeleteAction(0, compare.tableModel));
        JXFrame frame = this.wrapInFrame(box, "delete above selection");
        frame.setVisible(true);
    }

    public void interactiveDeleteRowBelowSelection() {
        CompareTableBehaviour compare = new CompareTableBehaviour(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        compare.table.getSelectionModel().setSelectionInterval(6, 7);
        compare.xTable.getSelectionModel().setSelectionInterval(6, 7);
        JComponent box = this.createContent(compare, this.createRowDeleteAction(-1, compare.tableModel));
        JXFrame frame = this.wrapInFrame(box, "delete below selection");
        frame.setVisible(true);
    }

    public void interactiveDataChanged() {
        final DefaultTableModel model = this.createAscendingModel(0, 10, 5, false);
        JXTable xtable = new JXTable(model);
        xtable.setRowSelectionInterval(0, 0);
        JTable table = new JTable(model);
        table.setRowSelectionInterval(0, 0);
        AbstractAction action = new AbstractAction("fire dataChanged"){

            public void actionPerformed(ActionEvent e) {
                model.fireTableDataChanged();
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(xtable, table, "selection after data changed");
        this.addAction(frame, action);
        frame.setVisible(true);
    }

    private JComponent createContent(CompareTableBehaviour compare, Action action) {
        JPanel box = new JPanel(new BorderLayout());
        box.add((Component)new JScrollPane(compare.table), "West");
        box.add((Component)new JScrollPane(compare.xTable), "East");
        box.add((Component)new JButton(action), "South");
        return box;
    }

    private Action createRowDeleteAction(final int row, final ReallySimpleTableModel simpleTableModel) {
        AbstractAction delete = new AbstractAction("DeleteRow " + (row < 0 ? "last" : "" + row)){

            public void actionPerformed(ActionEvent e) {
                int rowToDelete = row;
                if (row < 0) {
                    rowToDelete = simpleTableModel.getRowCount() - 1;
                }
                if (rowToDelete < 0 || rowToDelete >= simpleTableModel.getRowCount()) {
                    return;
                }
                simpleTableModel.removeRow(rowToDelete);
                if (simpleTableModel.getRowCount() == 0) {
                    this.setEnabled(false);
                }
            }
        };
        return delete;
    }

    private DefaultTableModel createAscendingModel(int startRow, final int rowCount, int columnCount, boolean fillLast) {
        DefaultTableModel model = new DefaultTableModel(rowCount, columnCount){

            public Class getColumnClass(int column) {
                Object value = rowCount > 0 ? this.getValueAt(0, column) : null;
                return value != null ? value.getClass() : super.getColumnClass(column);
            }
        };
        int filledColumn = fillLast ? columnCount - 1 : 0;
        int i = 0;
        while (i < model.getRowCount()) {
            model.setValueAt(new Integer(startRow++), i, filledColumn);
            ++i;
        }
        return model;
    }

    private DefaultTableModel createAscendingModel(int startRow, int count) {
        DefaultTableModel model = new DefaultTableModel(count, 5);
        int i = 0;
        while (i < model.getRowCount()) {
            model.setValueAt(new Integer(startRow++), i, 0);
            ++i;
        }
        return model;
    }

    public void testNewRendererInstance() {
        JXTable table = new JXTable();
        TableCellRenderer newRenderer = table.getNewDefaultRenderer(Boolean.class);
        TableCellRenderer sharedRenderer = table.getDefaultRenderer(Boolean.class);
        JXTableIssues.assertNotNull((Object)newRenderer);
        JXTableIssues.assertNotSame((String)"new renderer must be different from shared", (Object)sharedRenderer, (Object)newRenderer);
        JXTableIssues.assertNotSame((String)"new renderer must be different from object renderer", (Object)table.getDefaultRenderer(Object.class), (Object)newRenderer);
    }

    public void testWildCardInSearchByString() {
        JXTable table = new JXTable(this.createAscendingModel(0, 11));
        int row = 1;
        String lastName = table.getValueAt(row, 0).toString();
        int found = table.getSearchable().search(lastName, -1);
        JXTableIssues.assertEquals((String)"found must be equal to row", (int)row, (int)found);
        found = table.getSearchable().search(lastName, found);
        JXTableIssues.assertEquals((String)"search must succeed", (int)10, (int)found);
    }

    public static void main(String[] args) {
        JXTableIssues test = new JXTableIssues();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }

    public static class CompareTableBehaviour {
        public ReallySimpleTableModel tableModel = new ReallySimpleTableModel();
        public JTable table;
        public JXTable xTable;

        public CompareTableBehaviour(Object[] model) {
            this.tableModel.setContents(model);
            this.table = new JTable(this.tableModel);
            this.xTable = new JXTable(this.tableModel);
            this.table.getColumnModel().getColumn(0).setHeaderValue("JTable");
            this.xTable.getColumnModel().getColumn(0).setHeaderValue("JXTable");
        }
    }

    static class ReallySimpleTableModel
    extends AbstractTableModel {
        private List contents = new ArrayList();

        ReallySimpleTableModel() {
        }

        public void setContents(List contents) {
            this.contents.clear();
            this.contents.addAll(contents);
            this.fireTableDataChanged();
        }

        public void setContents(Object[] contents) {
            this.setContents(Arrays.asList(contents));
        }

        public void removeRow(int row) {
            this.contents.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public int getRowCount() {
            return this.contents.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int row, int column) {
            if (column != 0) {
                throw new IllegalArgumentException();
            }
            return this.contents.get(row);
        }
    }
}

