/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SizeSequence;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.LinkRenderer;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.SearchHighlighter;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.SizeSequenceMapper;
import org.jdesktop.swingx.decorator.Sorter;
import org.jdesktop.swingx.icon.ColumnControlIcon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class JXTable
extends JTable {
    private static final Logger LOG = Logger.getLogger(JXTable.class.getName());
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    public static final String HORIZONTALSCROLL_ACTION_COMMAND = "column.horizontalScroll";
    public static final String PACKALL_ACTION_COMMAND = "column.packAll";
    public static final String PACKSELECTED_ACTION_COMMAND = "column.packSelected";
    public static final String UIPREFIX = "JXTable.";
    public static final String MATCH_HIGHLIGHTER = "match.highlighter";
    protected FilterPipeline filters;
    protected HighlighterPipeline highlighters;
    protected ComponentAdapter dataAdapter;
    private SelectionMapper selectionMapper;
    private boolean sortable;
    private PipelineListener pipelineListener;
    private ChangeListener highlighterChangeListener;
    private ColumnFactory columnFactory;
    private int visibleRowCount = 18;
    private SizeSequenceMapper rowModelMapper;
    private Field rowModelField;
    private boolean rowHeightEnabled;
    private boolean columnControlVisible;
    private int verticalScrollPolicy;
    private JComponent columnControlButton;
    private RolloverProducer rolloverProducer;
    private LinkController linkController;
    private int oldAutoResizeMode;
    protected boolean isXTableRowHeightSet;
    protected Searchable searchable;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        LookAndFeelAddons.getAddon();
    }

    public JXTable() {
        this.init();
    }

    public JXTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public JXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public JXTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public JXTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    protected void init() {
        this.setSortable(true);
        this.setFilters(null);
        this.initActionsAndBindings();
        this.updateRowHeightUI(false);
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    protected LinkController getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected LinkController createLinkController() {
        return new LinkController();
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer r = new RolloverProducer(){

            protected void updateRolloverPoint(JComponent component, Point mousePoint) {
                JXTable table = (JXTable)component;
                int col = table.columnAtPoint(mousePoint);
                int row = table.rowAtPoint(mousePoint);
                if (col < 0 || row < 0) {
                    row = -1;
                    col = -1;
                }
                this.rollover.x = col;
                this.rollover.y = row;
            }
        };
        return r;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    public void setDefaultLinkVisitor(ActionListener linkVisitor) {
        TableCellRenderer renderer;
        TableCellEditor editor = this.getDefaultEditor(LinkModel.class);
        if (editor instanceof LinkRenderer) {
            ((LinkRenderer)editor).setVisitingDelegate(linkVisitor);
        }
        if ((renderer = this.getDefaultRenderer(LinkModel.class)) instanceof LinkRenderer) {
            ((LinkRenderer)renderer).setVisitingDelegate(linkVisitor);
        }
        this.setRolloverEnabled(true);
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.configureColumnControl();
        this.configureViewportBackground();
    }

    protected void configureViewportBackground() {
        Container p = this.getParent();
        if (p instanceof JViewport) {
            p.setBackground(this.getBackground());
        }
    }

    private void configureColumnControl() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (this.isColumnControlVisible()) {
                this.verticalScrollPolicy = scrollPane.getVerticalScrollBarPolicy();
                scrollPane.setCorner("UPPER_TRAILING_CORNER", this.getColumnControl());
                scrollPane.setVerticalScrollBarPolicy(22);
            } else {
                if (this.verticalScrollPolicy != 0) {
                    scrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
                }
                try {
                    scrollPane.setCorner("UPPER_TRAILING_CORNER", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        this.configureColumnControl();
    }

    public boolean isColumnControlVisible() {
        return this.columnControlVisible;
    }

    public JComponent getColumnControl() {
        if (this.columnControlButton == null) {
            this.columnControlButton = new ColumnControlButton(this, (Icon)new ColumnControlIcon());
        }
        return this.columnControlButton;
    }

    public void setColumnControlVisible(boolean showColumnControl) {
        boolean old = this.columnControlVisible;
        this.columnControlVisible = showColumnControl;
        this.configureColumnControl();
        this.firePropertyChange("columnControlVisible", old, this.columnControlVisible);
    }

    private void initActionsAndBindings() {
        ActionMap map = this.getActionMap();
        map.put("print", new Actions("print"));
        map.put("find", new Actions("find"));
        map.put(PACKALL_ACTION_COMMAND, this.createPackAllAction());
        map.put(PACKSELECTED_ACTION_COMMAND, this.createPackSelectedAction());
        map.put(HORIZONTALSCROLL_ACTION_COMMAND, this.createHorizontalScrollAction());
        KeyStroke findStroke = KeyStroke.getKeyStroke("control F");
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createHorizontalScrollAction() {
        String actionName = this.getUIString(HORIZONTALSCROLL_ACTION_COMMAND);
        BoundAction action = new BoundAction(actionName, HORIZONTALSCROLL_ACTION_COMMAND);
        action.setStateAction();
        action.registerCallback(this, "setHorizontalScrollEnabled");
        action.setSelected(this.isHorizontalScrollEnabled());
        return action;
    }

    private String getUIString(String key) {
        String text = UIManager.getString(UIPREFIX + key);
        return text != null ? text : key;
    }

    private Action createPackSelectedAction() {
        String text = this.getUIString(PACKSELECTED_ACTION_COMMAND);
        BoundAction action = new BoundAction(text, PACKSELECTED_ACTION_COMMAND);
        action.registerCallback(this, "packSelected");
        action.setEnabled(this.getSelectedColumnCount() > 0);
        return action;
    }

    private Action createPackAllAction() {
        String text = this.getUIString(PACKALL_ACTION_COMMAND);
        BoundAction action = new BoundAction(text, PACKALL_ACTION_COMMAND);
        action.registerCallback(this, "packAll");
        return action;
    }

    public void packAll() {
        this.packTable(this.getDefaultPackMargin());
    }

    public void packSelected() {
        int selected = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (selected >= 0) {
            this.packColumn(selected, this.getDefaultPackMargin());
        }
    }

    public void setHorizontalScrollEnabled(boolean enabled) {
        if (enabled == this.isHorizontalScrollEnabled()) {
            return;
        }
        if (enabled) {
            this.oldAutoResizeMode = this.getAutoResizeMode();
            this.setAutoResizeMode(0);
        } else {
            this.setAutoResizeMode(this.oldAutoResizeMode);
        }
    }

    private boolean isHorizontalScrollEnabled() {
        return this.getAutoResizeMode() == 0;
    }

    private int getDefaultPackMargin() {
        return 4;
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        Action packSelected = this.getActionMap().get(PACKSELECTED_ACTION_COMMAND);
        if (packSelected != null) {
            packSelected.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
        }
    }

    public void setAutoResizeMode(int mode) {
        super.setAutoResizeMode(mode);
        Action showHorizontal = this.getActionMap().get(HORIZONTALSCROLL_ACTION_COMMAND);
        if (showHorizontal instanceof BoundAction) {
            ((BoundAction)showHorizontal).setSelected(this.isHorizontalScrollEnabled());
        }
    }

    public int getRowCount() {
        return this.filters == null ? super.getRowCount() : this.filters.getOutputSize();
    }

    public boolean isHierarchical(int column) {
        return false;
    }

    public int convertRowIndexToModel(int row) {
        return this.getFilters().convertRowIndexToModel(row);
    }

    public int convertRowIndexToView(int row) {
        return this.getFilters().convertRowIndexToView(row);
    }

    public Object getValueAt(int row, int column) {
        return this.getModel().getValueAt(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.getModel().setValueAt(aValue, this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
    }

    public boolean isCellEditable(int row, int column) {
        return this.getModel().isCellEditable(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
    }

    public void setModel(TableModel newModel) {
        this.getSelectionMapper().lock();
        super.setModel(newModel);
    }

    public void tableChanged(TableModelEvent e) {
        if (this.getSelectionModel().getValueIsAdjusting()) {
            this.getSelectionModel().setValueIsAdjusting(false);
        }
        this.getSelectionMapper().lock();
        super.tableChanged(e);
        this.updateSelectionAndRowModel(e);
        this.use(this.filters);
    }

    private void updateSelectionAndRowModel(TableModelEvent e) {
        if (e.getType() == 1) {
            int start = e.getFirstRow();
            int end = e.getLastRow();
            if (start < 0) {
                start = 0;
            }
            if (end < 0) {
                end = this.getModel().getRowCount() - 1;
            }
            int length = end - start + 1;
            this.getSelectionMapper().insertIndexInterval(start, length, true);
            this.getRowModelMapper().insertIndexInterval(start, length, this.getRowHeight());
        } else if (e.getType() == -1) {
            int start = e.getFirstRow();
            int end = e.getLastRow();
            if (start < 0) {
                start = 0;
            }
            if (end < 0) {
                end = this.getModel().getRowCount() - 1;
            }
            int deletedCount = end - start + 1;
            this.getSelectionMapper().removeIndexInterval(start, end);
            this.getRowModelMapper().removeIndexInterval(start, deletedCount);
        } else if (this.getSelectionModel().isSelectionEmpty()) {
            this.getSelectionMapper().clearModelSelection();
            this.getRowModelMapper().clearModelSizes();
            this.updateViewSizeSequence();
        }
    }

    protected void updateViewSizeSequence() {
        SizeSequence sizeSequence = null;
        if (this.isRowHeightEnabled()) {
            sizeSequence = this.getSuperRowModel();
        }
        this.getRowModelMapper().setViewSizeSequence(sizeSequence, this.getRowHeight());
    }

    private SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = new SelectionMapper(this.filters, this.getSelectionModel());
        }
        return this.selectionMapper;
    }

    public FilterPipeline getFilters() {
        return this.filters;
    }

    private void use(FilterPipeline pipeline) {
        if (pipeline != null) {
            if (this.initialUse(pipeline)) {
                pipeline.addPipelineListener(this.getFilterPipelineListener());
                pipeline.assign(this.getComponentAdapter());
            } else {
                pipeline.flush();
            }
        }
    }

    private boolean initialUse(FilterPipeline pipeline) {
        if (this.pipelineListener == null) {
            return true;
        }
        PipelineListener[] l = pipeline.getPipelineListeners();
        int i = 0;
        while (i < l.length) {
            if (this.pipelineListener.equals(l[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setFilters(FilterPipeline pipeline) {
        FilterPipeline old = this.getFilters();
        Sorter sorter = null;
        if (old != null) {
            old.removePipelineListener(this.pipelineListener);
            sorter = old.getSorter();
        }
        if (pipeline == null) {
            pipeline = new FilterPipeline();
        }
        this.filters = pipeline;
        this.filters.setSorter(sorter);
        this.use(this.filters);
        this.getRowModelMapper().setFilters(this.filters);
        this.getSelectionMapper().setFilters(this.filters);
    }

    protected PipelineListener getFilterPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = this.createPipelineListener();
        }
        return this.pipelineListener;
    }

    protected PipelineListener createPipelineListener() {
        PipelineListener l = new PipelineListener(){

            public void contentsChanged(PipelineEvent e) {
                JXTable.this.updateOnFilterContentChanged();
            }
        };
        return l;
    }

    protected void updateOnFilterContentChanged() {
        this.revalidate();
        this.repaint();
    }

    public void setSortable(boolean sortable) {
        if (sortable == this.isSortable()) {
            return;
        }
        this.sortable = sortable;
        if (!this.isSortable()) {
            this.resetSorter();
        }
        this.firePropertyChange("sortable", !sortable, sortable);
    }

    public boolean isSortable() {
        return this.sortable;
    }

    private void setInteractiveSorter(Sorter sorter) {
        if (this.filters == null) {
            return;
        }
        this.getFilters().setSorter(sorter);
    }

    private Sorter getInteractiveSorter() {
        if (this.filters == null) {
            return null;
        }
        return this.getFilters().getSorter();
    }

    protected void resetSorter() {
        this.setInteractiveSorter(null);
        this.getTableHeader().repaint();
    }

    public void columnRemoved(TableColumnModelEvent e) {
        this.updateSorterAfterColumnRemoved();
        super.columnRemoved(e);
    }

    private void updateSorterAfterColumnRemoved() {
        Sorter sorter = this.getInteractiveSorter();
        if (sorter != null) {
            int sorterColumn = sorter.getColumnIndex();
            List columns = this.getColumns(true);
            for (TableColumn column : columns) {
                if (column.getModelIndex() != sorterColumn) continue;
                return;
            }
            this.resetSorter();
        }
    }

    protected void setSorter(int columnIndex) {
        if (!this.isSortable()) {
            return;
        }
        Sorter sorter = this.getInteractiveSorter();
        if (sorter != null && sorter.getColumnIndex() == this.convertColumnIndexToModel(columnIndex)) {
            sorter.toggle();
        } else {
            TableColumnExt column = this.getColumnExt(columnIndex);
            this.getFilters().setSorter(column != null ? column.getSorter() : null);
        }
    }

    public Sorter getSorter(int columnIndex) {
        Sorter sorter = this.getInteractiveSorter();
        return sorter == null ? null : (sorter.getColumnIndex() == this.convertColumnIndexToModel(columnIndex) ? sorter : null);
    }

    protected void removeColumns() {
        List columns = this.getColumns(true);
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            this.getColumnModel().removeColumn((TableColumn)iter.next());
        }
    }

    public List getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public List getColumns(boolean includeHidden) {
        if (includeHidden && this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumns(includeHidden);
        }
        return this.getColumns();
    }

    public int getColumnCount(boolean includeHidden) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnCount(includeHidden);
        }
        return this.getColumnCount();
    }

    public void setColumnSequence(Object[] identifiers) {
        List columns = this.getColumns(true);
        HashMap<Object, TableColumn> map = new HashMap<Object, TableColumn>();
        for (TableColumn column : columns) {
            map.put(column.getIdentifier(), column);
            this.getColumnModel().removeColumn(column);
        }
        int i = 0;
        while (i < identifiers.length) {
            TableColumn column;
            column = (TableColumn)map.get(identifiers[i]);
            if (column != null) {
                this.getColumnModel().addColumn(column);
                columns.remove(column);
            }
            ++i;
        }
        for (TableColumn column : columns) {
            this.getColumnModel().addColumn(column);
        }
    }

    public TableColumnExt getColumnExt(Object identifier) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnExt(identifier);
        }
        try {
            TableColumn column = this.getColumn(identifier);
            if (column instanceof TableColumnExt) {
                return (TableColumnExt)column;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public TableColumnExt getColumnExt(int viewColumnIndex) {
        return (TableColumnExt)this.getColumnModel().getColumn(viewColumnIndex);
    }

    public void createDefaultColumnsFromModel() {
        TableModel model = this.getModel();
        if (model != null) {
            int modelColumnCount = model.getColumnCount();
            TableColumn[] newColumns = new TableColumn[modelColumnCount];
            int i = 0;
            while (i < newColumns.length) {
                newColumns[i] = this.createAndConfigureColumn(model, i);
                ++i;
            }
            this.removeColumns();
            i = 0;
            while (i < newColumns.length) {
                this.addColumn(newColumns[i]);
                ++i;
            }
        }
    }

    protected TableColumn createAndConfigureColumn(TableModel model, int modelColumn) {
        return this.getColumnFactory().createAndConfigureTableColumn(model, modelColumn);
    }

    protected ColumnFactory getColumnFactory() {
        if (this.columnFactory == null) {
            this.columnFactory = ColumnFactory.getInstance();
        }
        return this.columnFactory;
    }

    public int getColumnMargin() {
        return this.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int value) {
        this.getColumnModel().setColumnMargin(value);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    private void find() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TableSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = super.getPreferredScrollableViewportSize();
        if (prefSize.getWidth() == 450.0 && prefSize.getHeight() == 400.0) {
            TableColumnModel columnModel = this.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            int w = 0;
            int i = 0;
            while (i < columnCount) {
                TableColumn column = columnModel.getColumn(i);
                this.initializeColumnPreferredWidth(column);
                w += column.getPreferredWidth();
                ++i;
            }
            prefSize.width = w;
            JTableHeader header = this.getTableHeader();
            int rowCount = this.getVisibleRowCount();
            prefSize.height = rowCount * this.getRowHeight() + (header != null ? header.getPreferredSize().height : 0);
            this.setPreferredScrollableViewportSize(prefSize);
        }
        return prefSize;
    }

    public void packTable(int margin) {
        int c = 0;
        while (c < this.getColumnCount()) {
            this.packColumn(c, margin, -1);
            ++c;
        }
    }

    public void packColumn(int column, int margin) {
        this.packColumn(column, margin, -1);
    }

    public void packColumn(int column, int margin, int max) {
        this.getColumnFactory().packColumn(this, this.getColumnExt(column), margin, max);
    }

    protected void initializeColumnPreferredWidth(TableColumn column) {
        if (column instanceof TableColumnExt) {
            this.getColumnFactory().configureColumnWidths(this, (TableColumnExt)column);
        }
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TableAdapter(this);
        }
        return this.dataAdapter;
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline pipeline) {
        HighlighterPipeline old = this.getHighlighters();
        if (old != null) {
            old.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters = pipeline;
        if (this.highlighters != null) {
            this.highlighters.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", old, this.getHighlighters());
        this.repaint();
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JXTable.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component stamp = super.prepareRenderer(renderer, row, column);
        this.adjustComponentOrientation(stamp);
        if (this.highlighters == null) {
            return stamp;
        }
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.row = row;
        adapter.column = column;
        return this.highlighters.apply(stamp, adapter);
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component comp = super.prepareEditor(editor, row, column);
        this.adjustComponentOrientation(comp);
        return comp;
    }

    protected void adjustComponentOrientation(Component stamp) {
        if (stamp.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        stamp.applyComponentOrientation(this.getComponentOrientation());
    }

    public TableCellRenderer getNewDefaultRenderer(Class columnClass) {
        TableCellRenderer renderer = this.getDefaultRenderer(columnClass);
        if (renderer != null) {
            try {
                return (TableCellRenderer)renderer.getClass().newInstance();
            }
            catch (Exception e) {
                LOG.fine("could not create renderer for " + columnClass);
            }
        }
        return null;
    }

    protected void createDefaultEditors() {
        super.createDefaultEditors();
        this.setLazyEditor(LinkModel.class, "org.jdesktop.swingx.LinkRenderer");
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        this.setLazyRenderer(Object.class, "javax.swing.table.DefaultTableCellRenderer");
        this.setLazyRenderer(Number.class, "org.jdesktop.swingx.JXTable$NumberRenderer");
        this.setLazyRenderer(Float.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        this.setLazyRenderer(Double.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        this.setLazyRenderer(Date.class, "org.jdesktop.swingx.JXTable$DateRenderer");
        this.setLazyRenderer(Icon.class, "org.jdesktop.swingx.JXTable$IconRenderer");
        this.setLazyRenderer(ImageIcon.class, "org.jdesktop.swingx.JXTable$IconRenderer");
        this.setLazyRenderer(Boolean.class, "org.jdesktop.swingx.JXTable$BooleanRenderer");
        this.setLazyRenderer(LinkModel.class, "org.jdesktop.swingx.LinkRenderer");
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new UIDefaults.ProxyLazyValue(s));
    }

    private void setLazyRenderer(Class c, String s) {
        this.setLazyValue(this.defaultRenderersByColumnClass, c, s);
    }

    private void setLazyEditor(Class c, String s) {
        this.setLazyValue(this.defaultEditorsByColumnClass, c, s);
    }

    public void updateUI() {
        super.updateUI();
        if (this.columnControlButton != null) {
            this.columnControlButton.updateUI();
        }
        Enumeration defaultEditors = this.defaultEditorsByColumnClass.elements();
        while (defaultEditors.hasMoreElements()) {
            this.updateEditorUI(defaultEditors.nextElement());
        }
        Enumeration defaultRenderers = this.defaultRenderersByColumnClass.elements();
        while (defaultRenderers.hasMoreElements()) {
            this.updateRendererUI(defaultRenderers.nextElement());
        }
        List columns = this.getColumns(true);
        for (TableColumn column : columns) {
            this.updateEditorUI(column.getCellEditor());
            this.updateRendererUI(column.getCellRenderer());
            this.updateRendererUI(column.getHeaderRenderer());
        }
        this.updateRowHeightUI(true);
        this.updateHighlighters();
        this.configureViewportBackground();
    }

    protected void updateHighlighters() {
        if (this.getHighlighters() == null) {
            return;
        }
        this.getHighlighters().updateUI();
    }

    private void updateRowHeightUI(boolean respectRowSetFlag) {
        if (respectRowSetFlag && this.isXTableRowHeightSet) {
            return;
        }
        int minimumSize = this.getFont().getSize() + 6;
        int uiSize = UIManager.getInt("JXTable.rowHeight");
        this.setRowHeight(Math.max(minimumSize, uiSize != 0 ? uiSize : 18));
        this.isXTableRowHeightSet = false;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (rowHeight > 0) {
            this.isXTableRowHeightSet = true;
        }
        this.updateViewSizeSequence();
    }

    public void setRowHeight(int row, int rowHeight) {
        if (!this.isRowHeightEnabled()) {
            return;
        }
        super.setRowHeight(row, rowHeight);
        this.updateViewSizeSequence();
        this.resizeAndRepaint();
    }

    public void setRowHeightEnabled(boolean enabled) {
        boolean old = this.isRowHeightEnabled();
        if (old == enabled) {
            return;
        }
        if (enabled && !this.canEnableRowHeight()) {
            return;
        }
        this.rowHeightEnabled = enabled;
        if (!enabled) {
            this.adminSetRowHeight(this.getRowHeight());
        }
        this.firePropertyChange("rowHeightEnabled", old, this.rowHeightEnabled);
    }

    private boolean canEnableRowHeight() {
        return this.getRowModelField() != null;
    }

    public boolean isRowHeightEnabled() {
        return this.rowHeightEnabled;
    }

    private SizeSequence getSuperRowModel() {
        try {
            Field field = this.getRowModelField();
            if (field != null) {
                return (SizeSequence)field.get(this);
            }
        }
        catch (SecurityException e) {
            LOG.fine("cannot use reflection  - expected behaviour in sandbox");
        }
        catch (IllegalArgumentException e) {
            LOG.fine("problem while accessing super's private field - private api changed?");
        }
        catch (IllegalAccessException e) {
            LOG.fine("cannot access private field  - expected behaviour in sandbox. Could be program logic running wild in unrestricted contexts");
        }
        return null;
    }

    private Field getRowModelField() {
        if (this.rowModelField == null) {
            try {
                this.rowModelField = JTable.class.getDeclaredField("rowModel");
                this.rowModelField.setAccessible(true);
            }
            catch (SecurityException e) {
                this.rowModelField = null;
                LOG.fine("cannot access JTable private field rowModel - expected behaviour in sandbox");
            }
            catch (NoSuchFieldException e) {
                LOG.fine("problem while accessing super's private field - private api changed?");
            }
        }
        return this.rowModelField;
    }

    protected SizeSequenceMapper getRowModelMapper() {
        if (this.rowModelMapper == null) {
            this.rowModelMapper = new SizeSequenceMapper(this.filters);
        }
        return this.rowModelMapper;
    }

    protected void adminSetRowHeight(int rowHeight) {
        boolean heightSet = this.isXTableRowHeightSet;
        this.setRowHeight(rowHeight);
        this.isXTableRowHeightSet = heightSet;
    }

    private void updateEditorUI(Object value) {
        if (!(value instanceof TableCellEditor)) {
            return;
        }
        if (value instanceof JComponent || value instanceof DefaultCellEditor) {
            return;
        }
        try {
            Component comp = ((TableCellEditor)value).getTableCellEditorComponent(this, null, false, -1, -1);
            if (comp instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRendererUI(Object value) {
        if (!(value instanceof TableCellRenderer)) {
            return;
        }
        if (value instanceof JComponent) {
            return;
        }
        try {
            Component comp = ((TableCellRenderer)value).getTableCellRendererComponent(this, null, false, false, -1, -1);
            if (comp instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int rowAtPoint(Point point) {
        if (point.y < 0) {
            return -1;
        }
        return super.rowAtPoint(point);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.columnModel);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModelExt();
    }

    public static class LinkController
    implements PropertyChangeListener {
        private Cursor oldCursor;
        private JXTable table;
        static /* synthetic */ Class class$0;

        public void propertyChange(PropertyChangeEvent evt) {
            if ("swingx.rollover".equals(evt.getPropertyName())) {
                this.rollover((JXTable)evt.getSource(), (Point)evt.getOldValue(), (Point)evt.getNewValue());
            } else if ("swingx.clicked".equals(evt.getPropertyName())) {
                this.click((JXTable)evt.getSource(), (Point)evt.getOldValue(), (Point)evt.getNewValue());
            }
        }

        public void install(JXTable table) {
            this.release();
            this.table = table;
            table.addPropertyChangeListener(this);
            this.registerExecuteButtonAction();
        }

        public void release() {
            if (this.table == null) {
                return;
            }
            this.table.removePropertyChangeListener(this);
            this.unregisterExecuteButtonAction();
        }

        private void rollover(JXTable table, Point oldLocation, Point newLocation) {
            Rectangle r;
            if (oldLocation != null) {
                r = table.getCellRect(oldLocation.y, oldLocation.x, false);
                r.x = 0;
                r.width = table.getWidth();
                table.repaint(r);
            }
            if (newLocation != null) {
                r = table.getCellRect(newLocation.y, newLocation.x, false);
                r.x = 0;
                r.width = table.getWidth();
                table.repaint(r);
            }
            this.setLinkCursor(table, newLocation);
        }

        private void click(JXTable list, Point oldLocation, Point newLocation) {
            if (!this.isLinkColumn(list, newLocation)) {
                return;
            }
            if (list.isCellEditable(newLocation.y, newLocation.x)) {
                return;
            }
            TableCellRenderer renderer = list.getCellRenderer(newLocation.y, newLocation.x);
            Component comp = list.prepareRenderer(renderer, newLocation.y, newLocation.x);
            if (comp instanceof AbstractButton) {
                ((AbstractButton)comp).doClick();
                list.repaint();
            }
        }

        private void setLinkCursor(JXTable table, Point location) {
            if (this.isLinkColumn(table, location)) {
                if (this.oldCursor == null) {
                    this.oldCursor = table.getCursor();
                    table.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.oldCursor != null) {
                table.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }

        private boolean isLinkColumn(JXTable table, Point location) {
            if (location == null || location.x < 0) {
                return false;
            }
            return table.getColumnClass(location.x) == LinkModel.class;
        }

        private void unregisterExecuteButtonAction() {
            this.table.getActionMap().put(JXTable.EXECUTE_BUTTON_ACTIONCOMMAND, null);
            KeyStroke space = KeyStroke.getKeyStroke("released SPACE");
            this.table.getInputMap(1).put(space, null);
        }

        private void registerExecuteButtonAction() {
            this.table.getActionMap().put(JXTable.EXECUTE_BUTTON_ACTIONCOMMAND, this.createExecuteButtonAction());
            KeyStroke space = KeyStroke.getKeyStroke("released SPACE");
            this.table.getInputMap(1).put(space, JXTable.EXECUTE_BUTTON_ACTIONCOMMAND);
        }

        private Action createExecuteButtonAction() {
            AbstractAction action = new AbstractAction(this){
                final /* synthetic */ LinkController this$1;
                {
                    this.this$1 = linkController;
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractButton button = this.getClickableRendererComponent();
                    if (button != null) {
                        button.doClick();
                        LinkController.access$0(this.this$1).repaint();
                    }
                }

                public boolean isEnabled() {
                    return this.isClickable();
                }

                private boolean isClickable() {
                    return this.getClickableRendererComponent() != null;
                }

                private AbstractButton getClickableRendererComponent() {
                    if (LinkController.access$0(this.this$1) == null || !LinkController.access$0(this.this$1).isEnabled() || !LinkController.access$0(this.this$1).hasFocus()) {
                        return null;
                    }
                    int leadRow = LinkController.access$0(this.this$1).getSelectionModel().getLeadSelectionIndex();
                    int leadColumn = LinkController.access$0(this.this$1).getColumnModel().getSelectionModel().getLeadSelectionIndex();
                    if (leadRow < 0 || leadColumn < 0 || LinkController.access$0(this.this$1).isCellEditable(leadRow, leadColumn)) {
                        return null;
                    }
                    TableCellRenderer renderer = LinkController.access$0(this.this$1).getCellRenderer(leadRow, leadColumn);
                    Component rendererComp = LinkController.access$0(this.this$1).prepareRenderer(renderer, leadRow, leadColumn);
                    return rendererComp instanceof AbstractButton ? (AbstractButton)rendererComp : null;
                }
            };
            return action;
        }

        static /* synthetic */ JXTable access$0(LinkController linkController) {
            return linkController.table;
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("print".equals(this.getName())) {
                try {
                    JXTable.this.print();
                }
                catch (PrinterException ex) {
                    LOG.log(Level.WARNING, "", ex);
                }
            } else if ("find".equals(this.getName())) {
                JXTable.this.find();
            }
        }
    }

    public class TableSearchable
    extends AbstractSearchable {
        private SearchHighlighter searchHighlighter;

        protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
            AbstractSearchable.SearchResult matchRow = null;
            if (backwards) {
                int r = startRow;
                while (r >= -1 && matchRow == null) {
                    matchRow = this.findMatchBackwardsInRow(pattern, r);
                    this.updateState(matchRow);
                    --r;
                }
            } else {
                int r = startRow;
                while (r <= this.getSize() && matchRow == null) {
                    matchRow = this.findMatchForwardInRow(pattern, r);
                    this.updateState(matchRow);
                    ++r;
                }
            }
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
            return this.findMatchAt(pattern, row, this.lastSearchResult.foundColumn);
        }

        private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int row) {
            int startColumn;
            int n = startColumn = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
            if (this.isValidIndex(row)) {
                int column = startColumn;
                while (column < JXTable.this.getColumnCount()) {
                    AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                    if (result != null) {
                        return result;
                    }
                    ++column;
                }
            }
            return null;
        }

        private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int row) {
            int startColumn;
            int n = startColumn = this.lastSearchResult.foundColumn < 0 ? JXTable.this.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
            if (this.isValidIndex(row)) {
                int column = startColumn;
                while (column >= 0) {
                    AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                    if (result != null) {
                        return result;
                    }
                    --column;
                }
            }
            return null;
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row, int column) {
            Matcher matcher;
            Object value = JXTable.this.getValueAt(row, column);
            if (value != null && (matcher = pattern.matcher(value.toString())).find()) {
                return this.createSearchResult(matcher, row, column);
            }
            return null;
        }

        protected int adjustStartPosition(int startIndex, boolean backwards) {
            this.lastSearchResult.foundColumn = -1;
            return super.adjustStartPosition(startIndex, backwards);
        }

        protected int moveStartPosition(int startRow, boolean backwards) {
            if (backwards) {
                --this.lastSearchResult.foundColumn;
                if (this.lastSearchResult.foundColumn < 0) {
                    --startRow;
                }
            } else {
                ++this.lastSearchResult.foundColumn;
                if (this.lastSearchResult.foundColumn >= JXTable.this.getColumnCount()) {
                    this.lastSearchResult.foundColumn = -1;
                    ++startRow;
                }
            }
            return startRow;
        }

        protected boolean isEqualStartIndex(int startIndex) {
            return super.isEqualStartIndex(startIndex) && this.isValidColumn(this.lastSearchResult.foundColumn);
        }

        private boolean isValidColumn(int column) {
            return column >= 0 && column < JXTable.this.getColumnCount();
        }

        protected int getSize() {
            return JXTable.this.getRowCount();
        }

        protected void moveMatchMarker() {
            int row = this.lastSearchResult.foundRow;
            int column = this.lastSearchResult.foundColumn;
            Pattern pattern = this.lastSearchResult.pattern;
            if (row < 0 || column < 0) {
                if (this.markByHighlighter()) {
                    this.getSearchHighlighter().setPattern(null);
                }
                return;
            }
            if (this.markByHighlighter()) {
                Rectangle cellRect = JXTable.this.getCellRect(row, column, true);
                if (cellRect != null) {
                    JXTable.this.scrollRectToVisible(cellRect);
                }
                this.ensureInsertedSearchHighlighters();
                this.getSearchHighlighter().setPattern(pattern);
                int modelColumn = JXTable.this.convertColumnIndexToModel(column);
                this.getSearchHighlighter().setHighlightCell(row, modelColumn);
            } else {
                Rectangle cellRect;
                JXTable.this.changeSelection(row, column, false, false);
                if (!JXTable.this.getAutoscrolls() && (cellRect = JXTable.this.getCellRect(row, column, true)) != null) {
                    JXTable.this.scrollRectToVisible(cellRect);
                }
            }
        }

        private boolean markByHighlighter() {
            return Boolean.TRUE.equals(JXTable.this.getClientProperty(JXTable.MATCH_HIGHLIGHTER));
        }

        private SearchHighlighter getSearchHighlighter() {
            if (this.searchHighlighter == null) {
                this.searchHighlighter = this.createSearchHighlighter();
            }
            return this.searchHighlighter;
        }

        private void ensureInsertedSearchHighlighters() {
            if (JXTable.this.getHighlighters() == null) {
                JXTable.this.setHighlighters(new HighlighterPipeline(new Highlighter[]{this.getSearchHighlighter()}));
            } else if (!this.isInPipeline(this.getSearchHighlighter())) {
                JXTable.this.getHighlighters().addHighlighter(this.getSearchHighlighter());
            }
        }

        private boolean isInPipeline(PatternHighlighter searchHighlighter) {
            Highlighter[] inPipeline = JXTable.this.getHighlighters().getHighlighters();
            if (inPipeline.length > 0 && searchHighlighter.equals(inPipeline[inPipeline.length - 1])) {
                return true;
            }
            JXTable.this.getHighlighters().removeHighlighter(searchHighlighter);
            return false;
        }

        protected SearchHighlighter createSearchHighlighter() {
            return new SearchHighlighter();
        }
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final JXTable table;

        public TableAdapter(JXTable component) {
            super(component);
            this.table = component;
        }

        public JXTable getTable() {
            return this.table;
        }

        public String getColumnName(int columnIndex) {
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            return column == null ? "" : column.getHeaderValue().toString();
        }

        protected TableColumn getColumnByModelIndex(int modelColumn) {
            List columns = this.table.getColumns(true);
            for (TableColumn column : columns) {
                if (column.getModelIndex() != modelColumn) continue;
                return column;
            }
            return null;
        }

        public String getColumnIdentifier(int columnIndex) {
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            Object identifier = column != null ? column.getIdentifier() : null;
            return identifier != null ? identifier.toString() : null;
        }

        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        public Object getValueAt(int row, int column) {
            return this.table.getModel().getValueAt(row, column);
        }

        public void setValueAt(Object aValue, int row, int column) {
            this.table.getModel().setValueAt(aValue, row, column);
        }

        public boolean isCellEditable(int row, int column) {
            return this.table.getModel().isCellEditable(row, column);
        }

        public boolean isTestable(int column) {
            return this.getColumnByModelIndex(column) != null;
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.getValueAt(this.table.convertRowIndexToModel(row), column);
        }

        public boolean isSelected() {
            return this.table.isCellSelected(this.row, this.column);
        }

        public boolean hasFocus() {
            boolean colIsLead;
            boolean rowIsLead = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean bl = colIsLead = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && rowIsLead && colIsLead;
        }

        public int modelToView(int columnIndex) {
            return this.table.convertColumnIndexToView(columnIndex);
        }

        public int viewToModel(int columnIndex) {
            return this.table.convertColumnIndexToModel(columnIndex);
        }
    }

    public static class NumberRenderer
    extends DefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(11);
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        private final NumberFormat formatter;

        public DoubleRenderer() {
            this((NumberFormat)null);
        }

        public DoubleRenderer(NumberFormat formatter) {
            if (formatter == null) {
                formatter = NumberFormat.getInstance();
            }
            this.formatter = formatter;
        }

        public void setValue(Object value) {
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DateRenderer
    extends DefaultTableCellRenderer {
        private final DateFormat formatter;

        public DateRenderer() {
            this((DateFormat)null);
        }

        public DateRenderer(DateFormat formatter) {
            if (formatter == null) {
                formatter = DateFormat.getDateInstance();
            }
            this.formatter = formatter;
        }

        public void setValue(Object value) {
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }
}

